/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.trp.v20210515.models;

import com.tencentcloudapi.common.AbstractModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class Merchant extends AbstractModel{

    /**
    * 商户标识码
    */
    @SerializedName("MerchantId")
    @Expose
    private String MerchantId;

    /**
    * 企业id
    */
    @SerializedName("CorpId")
    @Expose
    private Long CorpId;

    /**
    * 商户名称
    */
    @SerializedName("Name")
    @Expose
    private String Name;

    /**
    * 备注
注意：此字段可能返回 null，表示取不到有效值。
    */
    @SerializedName("Remark")
    @Expose
    private String Remark;

    /**
    * 创建时间
    */
    @SerializedName("CreateTime")
    @Expose
    private String CreateTime;

    /**
    * 更新时间
    */
    @SerializedName("UpdateTime")
    @Expose
    private String UpdateTime;

    /**
    * 商户码规则
    */
    @SerializedName("CodeRule")
    @Expose
    private String CodeRule;

    /**
    * 码来源类型 0: 安心平台 1: 第三方码
    */
    @SerializedName("CodeType")
    @Expose
    private Long CodeType;

    /**
    * 第三方码域名前缀
注意：此字段可能返回 null，表示取不到有效值。
    */
    @SerializedName("CodeUrl")
    @Expose
    private String CodeUrl;

    /**
     * Get 商户标识码 
     * @return MerchantId 商户标识码
     */
    public String getMerchantId() {
        return this.MerchantId;
    }

    /**
     * Set 商户标识码
     * @param MerchantId 商户标识码
     */
    public void setMerchantId(String MerchantId) {
        this.MerchantId = MerchantId;
    }

    /**
     * Get 企业id 
     * @return CorpId 企业id
     */
    public Long getCorpId() {
        return this.CorpId;
    }

    /**
     * Set 企业id
     * @param CorpId 企业id
     */
    public void setCorpId(Long CorpId) {
        this.CorpId = CorpId;
    }

    /**
     * Get 商户名称 
     * @return Name 商户名称
     */
    public String getName() {
        return this.Name;
    }

    /**
     * Set 商户名称
     * @param Name 商户名称
     */
    public void setName(String Name) {
        this.Name = Name;
    }

    /**
     * Get 备注
注意：此字段可能返回 null，表示取不到有效值。 
     * @return Remark 备注
注意：此字段可能返回 null，表示取不到有效值。
     */
    public String getRemark() {
        return this.Remark;
    }

    /**
     * Set 备注
注意：此字段可能返回 null，表示取不到有效值。
     * @param Remark 备注
注意：此字段可能返回 null，表示取不到有效值。
     */
    public void setRemark(String Remark) {
        this.Remark = Remark;
    }

    /**
     * Get 创建时间 
     * @return CreateTime 创建时间
     */
    public String getCreateTime() {
        return this.CreateTime;
    }

    /**
     * Set 创建时间
     * @param CreateTime 创建时间
     */
    public void setCreateTime(String CreateTime) {
        this.CreateTime = CreateTime;
    }

    /**
     * Get 更新时间 
     * @return UpdateTime 更新时间
     */
    public String getUpdateTime() {
        return this.UpdateTime;
    }

    /**
     * Set 更新时间
     * @param UpdateTime 更新时间
     */
    public void setUpdateTime(String UpdateTime) {
        this.UpdateTime = UpdateTime;
    }

    /**
     * Get 商户码规则 
     * @return CodeRule 商户码规则
     */
    public String getCodeRule() {
        return this.CodeRule;
    }

    /**
     * Set 商户码规则
     * @param CodeRule 商户码规则
     */
    public void setCodeRule(String CodeRule) {
        this.CodeRule = CodeRule;
    }

    /**
     * Get 码来源类型 0: 安心平台 1: 第三方码 
     * @return CodeType 码来源类型 0: 安心平台 1: 第三方码
     */
    public Long getCodeType() {
        return this.CodeType;
    }

    /**
     * Set 码来源类型 0: 安心平台 1: 第三方码
     * @param CodeType 码来源类型 0: 安心平台 1: 第三方码
     */
    public void setCodeType(Long CodeType) {
        this.CodeType = CodeType;
    }

    /**
     * Get 第三方码域名前缀
注意：此字段可能返回 null，表示取不到有效值。 
     * @return CodeUrl 第三方码域名前缀
注意：此字段可能返回 null，表示取不到有效值。
     */
    public String getCodeUrl() {
        return this.CodeUrl;
    }

    /**
     * Set 第三方码域名前缀
注意：此字段可能返回 null，表示取不到有效值。
     * @param CodeUrl 第三方码域名前缀
注意：此字段可能返回 null，表示取不到有效值。
     */
    public void setCodeUrl(String CodeUrl) {
        this.CodeUrl = CodeUrl;
    }

    public Merchant() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public Merchant(Merchant source) {
        if (source.MerchantId != null) {
            this.MerchantId = new String(source.MerchantId);
        }
        if (source.CorpId != null) {
            this.CorpId = new Long(source.CorpId);
        }
        if (source.Name != null) {
            this.Name = new String(source.Name);
        }
        if (source.Remark != null) {
            this.Remark = new String(source.Remark);
        }
        if (source.CreateTime != null) {
            this.CreateTime = new String(source.CreateTime);
        }
        if (source.UpdateTime != null) {
            this.UpdateTime = new String(source.UpdateTime);
        }
        if (source.CodeRule != null) {
            this.CodeRule = new String(source.CodeRule);
        }
        if (source.CodeType != null) {
            this.CodeType = new Long(source.CodeType);
        }
        if (source.CodeUrl != null) {
            this.CodeUrl = new String(source.CodeUrl);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "MerchantId", this.MerchantId);
        this.setParamSimple(map, prefix + "CorpId", this.CorpId);
        this.setParamSimple(map, prefix + "Name", this.Name);
        this.setParamSimple(map, prefix + "Remark", this.Remark);
        this.setParamSimple(map, prefix + "CreateTime", this.CreateTime);
        this.setParamSimple(map, prefix + "UpdateTime", this.UpdateTime);
        this.setParamSimple(map, prefix + "CodeRule", this.CodeRule);
        this.setParamSimple(map, prefix + "CodeType", this.CodeType);
        this.setParamSimple(map, prefix + "CodeUrl", this.CodeUrl);

    }
}

