/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.yinsuda.v20220527.models;

import com.tencentcloudapi.common.AbstractModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeKTVTagsResponse extends AbstractModel{

    /**
    * 标签分组列表。
    */
    @SerializedName("TagGroupInfoSet")
    @Expose
    private KTVTagGroupInfo [] TagGroupInfoSet;

    /**
    * 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get 标签分组列表。 
     * @return TagGroupInfoSet 标签分组列表。
     */
    public KTVTagGroupInfo [] getTagGroupInfoSet() {
        return this.TagGroupInfoSet;
    }

    /**
     * Set 标签分组列表。
     * @param TagGroupInfoSet 标签分组列表。
     */
    public void setTagGroupInfoSet(KTVTagGroupInfo [] TagGroupInfoSet) {
        this.TagGroupInfoSet = TagGroupInfoSet;
    }

    /**
     * Get 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。 
     * @return RequestId 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
     * @param RequestId 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeKTVTagsResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeKTVTagsResponse(DescribeKTVTagsResponse source) {
        if (source.TagGroupInfoSet != null) {
            this.TagGroupInfoSet = new KTVTagGroupInfo[source.TagGroupInfoSet.length];
            for (int i = 0; i < source.TagGroupInfoSet.length; i++) {
                this.TagGroupInfoSet[i] = new KTVTagGroupInfo(source.TagGroupInfoSet[i]);
            }
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamArrayObj(map, prefix + "TagGroupInfoSet.", this.TagGroupInfoSet);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

