/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.ams.v20200608.models;

import com.tencentcloudapi.common.AbstractModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class ImageResultsResultDetail extends AbstractModel{

    /**
    * 位置信息
注意：此字段可能返回 null，表示取不到有效值。
    */
    @SerializedName("Location")
    @Expose
    private ImageResultsResultDetailLocation [] Location;

    /**
    * 任务名称
注意：此字段可能返回 null，表示取不到有效值。
    */
    @SerializedName("Name")
    @Expose
    private String Name;

    /**
    * OCR识别文本
注意：此字段可能返回 null，表示取不到有效值。
    */
    @SerializedName("Text")
    @Expose
    private String Text;

    /**
    * 标签
    */
    @SerializedName("Label")
    @Expose
    private String Label;

    /**
    * 库ID
注意：此字段可能返回 null，表示取不到有效值。
    */
    @SerializedName("LibId")
    @Expose
    private String LibId;

    /**
    * 库名称
注意：此字段可能返回 null，表示取不到有效值。
    */
    @SerializedName("LibName")
    @Expose
    private String LibName;

    /**
    * 命中的关键词
注意：此字段可能返回 null，表示取不到有效值。
    */
    @SerializedName("Keywords")
    @Expose
    private String [] Keywords;

    /**
    * 建议
注意：此字段可能返回 null，表示取不到有效值。
    */
    @SerializedName("Suggestion")
    @Expose
    private String Suggestion;

    /**
    * 得分
注意：此字段可能返回 null，表示取不到有效值。
    */
    @SerializedName("Score")
    @Expose
    private Long Score;

    /**
    * 子标签码
注意：此字段可能返回 null，表示取不到有效值。
    */
    @SerializedName("SubLabelCode")
    @Expose
    private String SubLabelCode;

    /**
     * Get 位置信息
注意：此字段可能返回 null，表示取不到有效值。 
     * @return Location 位置信息
注意：此字段可能返回 null，表示取不到有效值。
     */
    public ImageResultsResultDetailLocation [] getLocation() {
        return this.Location;
    }

    /**
     * Set 位置信息
注意：此字段可能返回 null，表示取不到有效值。
     * @param Location 位置信息
注意：此字段可能返回 null，表示取不到有效值。
     */
    public void setLocation(ImageResultsResultDetailLocation [] Location) {
        this.Location = Location;
    }

    /**
     * Get 任务名称
注意：此字段可能返回 null，表示取不到有效值。 
     * @return Name 任务名称
注意：此字段可能返回 null，表示取不到有效值。
     */
    public String getName() {
        return this.Name;
    }

    /**
     * Set 任务名称
注意：此字段可能返回 null，表示取不到有效值。
     * @param Name 任务名称
注意：此字段可能返回 null，表示取不到有效值。
     */
    public void setName(String Name) {
        this.Name = Name;
    }

    /**
     * Get OCR识别文本
注意：此字段可能返回 null，表示取不到有效值。 
     * @return Text OCR识别文本
注意：此字段可能返回 null，表示取不到有效值。
     */
    public String getText() {
        return this.Text;
    }

    /**
     * Set OCR识别文本
注意：此字段可能返回 null，表示取不到有效值。
     * @param Text OCR识别文本
注意：此字段可能返回 null，表示取不到有效值。
     */
    public void setText(String Text) {
        this.Text = Text;
    }

    /**
     * Get 标签 
     * @return Label 标签
     */
    public String getLabel() {
        return this.Label;
    }

    /**
     * Set 标签
     * @param Label 标签
     */
    public void setLabel(String Label) {
        this.Label = Label;
    }

    /**
     * Get 库ID
注意：此字段可能返回 null，表示取不到有效值。 
     * @return LibId 库ID
注意：此字段可能返回 null，表示取不到有效值。
     */
    public String getLibId() {
        return this.LibId;
    }

    /**
     * Set 库ID
注意：此字段可能返回 null，表示取不到有效值。
     * @param LibId 库ID
注意：此字段可能返回 null，表示取不到有效值。
     */
    public void setLibId(String LibId) {
        this.LibId = LibId;
    }

    /**
     * Get 库名称
注意：此字段可能返回 null，表示取不到有效值。 
     * @return LibName 库名称
注意：此字段可能返回 null，表示取不到有效值。
     */
    public String getLibName() {
        return this.LibName;
    }

    /**
     * Set 库名称
注意：此字段可能返回 null，表示取不到有效值。
     * @param LibName 库名称
注意：此字段可能返回 null，表示取不到有效值。
     */
    public void setLibName(String LibName) {
        this.LibName = LibName;
    }

    /**
     * Get 命中的关键词
注意：此字段可能返回 null，表示取不到有效值。 
     * @return Keywords 命中的关键词
注意：此字段可能返回 null，表示取不到有效值。
     */
    public String [] getKeywords() {
        return this.Keywords;
    }

    /**
     * Set 命中的关键词
注意：此字段可能返回 null，表示取不到有效值。
     * @param Keywords 命中的关键词
注意：此字段可能返回 null，表示取不到有效值。
     */
    public void setKeywords(String [] Keywords) {
        this.Keywords = Keywords;
    }

    /**
     * Get 建议
注意：此字段可能返回 null，表示取不到有效值。 
     * @return Suggestion 建议
注意：此字段可能返回 null，表示取不到有效值。
     */
    public String getSuggestion() {
        return this.Suggestion;
    }

    /**
     * Set 建议
注意：此字段可能返回 null，表示取不到有效值。
     * @param Suggestion 建议
注意：此字段可能返回 null，表示取不到有效值。
     */
    public void setSuggestion(String Suggestion) {
        this.Suggestion = Suggestion;
    }

    /**
     * Get 得分
注意：此字段可能返回 null，表示取不到有效值。 
     * @return Score 得分
注意：此字段可能返回 null，表示取不到有效值。
     */
    public Long getScore() {
        return this.Score;
    }

    /**
     * Set 得分
注意：此字段可能返回 null，表示取不到有效值。
     * @param Score 得分
注意：此字段可能返回 null，表示取不到有效值。
     */
    public void setScore(Long Score) {
        this.Score = Score;
    }

    /**
     * Get 子标签码
注意：此字段可能返回 null，表示取不到有效值。 
     * @return SubLabelCode 子标签码
注意：此字段可能返回 null，表示取不到有效值。
     */
    public String getSubLabelCode() {
        return this.SubLabelCode;
    }

    /**
     * Set 子标签码
注意：此字段可能返回 null，表示取不到有效值。
     * @param SubLabelCode 子标签码
注意：此字段可能返回 null，表示取不到有效值。
     */
    public void setSubLabelCode(String SubLabelCode) {
        this.SubLabelCode = SubLabelCode;
    }

    public ImageResultsResultDetail() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public ImageResultsResultDetail(ImageResultsResultDetail source) {
        if (source.Location != null) {
            this.Location = new ImageResultsResultDetailLocation[source.Location.length];
            for (int i = 0; i < source.Location.length; i++) {
                this.Location[i] = new ImageResultsResultDetailLocation(source.Location[i]);
            }
        }
        if (source.Name != null) {
            this.Name = new String(source.Name);
        }
        if (source.Text != null) {
            this.Text = new String(source.Text);
        }
        if (source.Label != null) {
            this.Label = new String(source.Label);
        }
        if (source.LibId != null) {
            this.LibId = new String(source.LibId);
        }
        if (source.LibName != null) {
            this.LibName = new String(source.LibName);
        }
        if (source.Keywords != null) {
            this.Keywords = new String[source.Keywords.length];
            for (int i = 0; i < source.Keywords.length; i++) {
                this.Keywords[i] = new String(source.Keywords[i]);
            }
        }
        if (source.Suggestion != null) {
            this.Suggestion = new String(source.Suggestion);
        }
        if (source.Score != null) {
            this.Score = new Long(source.Score);
        }
        if (source.SubLabelCode != null) {
            this.SubLabelCode = new String(source.SubLabelCode);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamArrayObj(map, prefix + "Location.", this.Location);
        this.setParamSimple(map, prefix + "Name", this.Name);
        this.setParamSimple(map, prefix + "Text", this.Text);
        this.setParamSimple(map, prefix + "Label", this.Label);
        this.setParamSimple(map, prefix + "LibId", this.LibId);
        this.setParamSimple(map, prefix + "LibName", this.LibName);
        this.setParamArraySimple(map, prefix + "Keywords.", this.Keywords);
        this.setParamSimple(map, prefix + "Suggestion", this.Suggestion);
        this.setParamSimple(map, prefix + "Score", this.Score);
        this.setParamSimple(map, prefix + "SubLabelCode", this.SubLabelCode);

    }
}

