/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.iecp.v20210914.models;

import com.tencentcloudapi.common.AbstractModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DeleteApplicationsRequest extends AbstractModel{

    /**
    * 应用模板ID列表
    */
    @SerializedName("ApplicationIds")
    @Expose
    private Long [] ApplicationIds;

    /**
     * Get 应用模板ID列表 
     * @return ApplicationIds 应用模板ID列表
     */
    public Long [] getApplicationIds() {
        return this.ApplicationIds;
    }

    /**
     * Set 应用模板ID列表
     * @param ApplicationIds 应用模板ID列表
     */
    public void setApplicationIds(Long [] ApplicationIds) {
        this.ApplicationIds = ApplicationIds;
    }

    public DeleteApplicationsRequest() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DeleteApplicationsRequest(DeleteApplicationsRequest source) {
        if (source.ApplicationIds != null) {
            this.ApplicationIds = new Long[source.ApplicationIds.length];
            for (int i = 0; i < source.ApplicationIds.length; i++) {
                this.ApplicationIds[i] = new Long(source.ApplicationIds[i]);
            }
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamArraySimple(map, prefix + "ApplicationIds.", this.ApplicationIds);

    }
}

