/*
 * Decompiled with CFR 0.152.
 */
package com.testmonitor.actions;

import com.testmonitor.api.Connector;
import com.testmonitor.parsers.TestRunParser;
import com.testmonitor.resources.Milestone;
import com.testmonitor.resources.Project;
import com.testmonitor.resources.TestRun;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.message.BasicNameValuePair;
import org.json.JSONObject;

public class TestRuns {
    private final Connector connector;
    private final Integer projectId;

    public TestRuns(Connector connector, Project project) {
        this.connector = connector;
        this.projectId = project.getId();
    }

    public ArrayList<TestRun> list() {
        return this.list(1);
    }

    public ArrayList<TestRun> list(Integer page) {
        return this.list(page, 15);
    }

    public ArrayList<TestRun> list(Integer page, Integer limit) {
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        params.add(new BasicNameValuePair("page", page.toString()));
        params.add(new BasicNameValuePair("limit", limit.toString()));
        params.add(new BasicNameValuePair("project_id", this.projectId.toString()));
        return TestRunParser.parse(this.connector.get("test-runs", params));
    }

    public TestRun get(Integer id) {
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        params.add(new BasicNameValuePair("project_id", this.projectId.toString()));
        JSONObject response = this.connector.get("test-runs/" + id, params);
        HashMap testRun = (HashMap)response.getJSONObject("data").toMap();
        return TestRunParser.parse(testRun);
    }

    public ArrayList<TestRun> search(String search) {
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        params.add(new BasicNameValuePair("query", search));
        params.add(new BasicNameValuePair("project_id", this.projectId.toString()));
        return TestRunParser.parse(this.connector.get("test-runs", params));
    }

    public ArrayList<TestRun> search(String search, Integer milestoneId) {
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        params.add(new BasicNameValuePair("query", search));
        params.add(new BasicNameValuePair("project_id", this.projectId.toString()));
        params.add(new BasicNameValuePair("milestone_id", milestoneId.toString()));
        return TestRunParser.parse(this.connector.get("test-runs", params));
    }

    public TestRun create(TestRun testRun) {
        List<NameValuePair> params = testRun.toHttpParams();
        params.add(new BasicNameValuePair("project_id", this.projectId.toString()));
        JSONObject response = this.connector.post("test-runs", params);
        HashMap newTestRun = (HashMap)response.getJSONObject("data").toMap();
        return TestRunParser.parse(newTestRun);
    }

    public TestRun create(String name, Integer milestoneId) {
        TestRun testRun = new TestRun();
        testRun.setName(name);
        testRun.setStartsAt(new Date());
        testRun.setEndsAt(new Date());
        testRun.setMilestoneId(milestoneId);
        return this.create(testRun);
    }

    public TestRun create(String name, Milestone milestone) {
        return this.create(name, milestone.getId());
    }

    public TestRun findOrCreate(TestRun testRun) {
        return this.findOrCreate(testRun.getName(), testRun.getMilestoneId());
    }

    public TestRun findOrCreate(String search, Milestone milestone) {
        return this.findOrCreate(search, milestone.getId());
    }

    public TestRun findOrCreate(String search, Integer milestoneId) {
        ArrayList<TestRun> testRuns = this.search("\"" + search + "\"");
        if (testRuns.size() > 0) {
            return testRuns.get(0);
        }
        return this.create(search, milestoneId);
    }

    public TestRun update(TestRun testRun) {
        JSONObject response = this.connector.put("test-runs/" + testRun.getId(), testRun.toHttpParams());
        HashMap updatedTestRun = (HashMap)response.getJSONObject("data").toMap();
        return TestRunParser.parse(updatedTestRun);
    }

    public TestRun assignUsers(TestRun testRun, List<Integer> userIds) {
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        for (Integer userId : userIds) {
            params.add(new BasicNameValuePair("users[]", userId.toString()));
        }
        JSONObject response = this.connector.put("test-runs/" + testRun.getId(), params);
        HashMap updatedTestRun = (HashMap)response.getJSONObject("data").toMap();
        return TestRunParser.parse(updatedTestRun);
    }

    public TestRun assignTestCases(TestRun testRun, List<Integer> testCaseIds) {
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        params.add(new BasicNameValuePair("merge", "1"));
        for (Integer testCaseId : testCaseIds) {
            params.add(new BasicNameValuePair("test_cases[]", testCaseId.toString()));
        }
        JSONObject response = this.connector.put("test-runs/" + testRun.getId(), params);
        HashMap updatedTestRun = (HashMap)response.getJSONObject("data").toMap();
        return TestRunParser.parse(updatedTestRun);
    }
}

