/*
 * Decompiled with CFR 0.152.
 */
package com.testmonitor.actions;

import com.testmonitor.api.Connector;
import com.testmonitor.parsers.TestCaseParser;
import com.testmonitor.resources.Project;
import com.testmonitor.resources.TestCase;
import com.testmonitor.resources.TestSuite;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.message.BasicNameValuePair;
import org.json.JSONObject;

public class TestCases {
    private final Connector connector;
    private final Integer projectId;

    public TestCases(Connector connector, Project project) {
        this.connector = connector;
        this.projectId = project.getId();
    }

    public ArrayList<TestCase> list() {
        return this.list(1);
    }

    public ArrayList<TestCase> list(Integer page) {
        return this.list(page, 15);
    }

    public ArrayList<TestCase> list(Integer page, Integer limit) {
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        params.add((NameValuePair)new BasicNameValuePair("page", page.toString()));
        params.add((NameValuePair)new BasicNameValuePair("limit", limit.toString()));
        params.add((NameValuePair)new BasicNameValuePair("project_id", this.projectId.toString()));
        return TestCaseParser.parse(this.connector.get("test-cases", params));
    }

    public TestCase get(Integer id) {
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        params.add((NameValuePair)new BasicNameValuePair("project_id", this.projectId.toString()));
        JSONObject response = this.connector.get("test-cases/" + id, params);
        HashMap testCase = (HashMap)response.getJSONObject("data").toMap();
        return TestCaseParser.parse(testCase);
    }

    public ArrayList<TestCase> search(String search) {
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        params.add((NameValuePair)new BasicNameValuePair("query", search));
        params.add((NameValuePair)new BasicNameValuePair("project_id", this.projectId.toString()));
        return TestCaseParser.parse(this.connector.get("test-cases", params));
    }

    public ArrayList<TestCase> search(String search, Integer testSuiteId) {
        ArrayList<TestCase> testCases = this.search(search);
        testCases.removeIf(testCase -> !testCase.getTestSuiteId().equals(testSuiteId));
        return testCases;
    }

    public TestCase create(TestCase testCase) {
        JSONObject response = this.connector.post("test-cases", testCase.toHttpParams());
        testCase.setId(response.getJSONObject("data").get("id").toString());
        return testCase;
    }

    public TestCase create(String name, Integer testSuiteId) {
        TestCase testCase = new TestCase();
        testCase.setName(name);
        testCase.setTestSuiteId(testSuiteId);
        return this.create(testCase);
    }

    public TestCase create(String name, TestSuite testSuite) {
        return this.create(name, testSuite.getId());
    }

    public TestCase findOrCreate(String search, TestSuite testSuite) {
        return this.findOrCreate(search, testSuite.getId());
    }

    public TestCase findOrCreate(TestCase testCase) {
        return this.findOrCreate(testCase.getName(), testCase.getTestSuiteId());
    }

    public TestCase findOrCreate(String search, Integer testSuiteId) {
        ArrayList<TestCase> testCases = this.search("\"" + search + "\"", testSuiteId);
        if (testCases.size() > 0) {
            return testCases.get(0);
        }
        return this.create(search, testSuiteId);
    }

    public TestCase update(TestCase testCase) {
        JSONObject response = this.connector.put("test-cases/" + testCase.getId(), testCase.toHttpParams());
        HashMap updatedTestCase = (HashMap)response.getJSONObject("data").toMap();
        return TestCaseParser.parse(updatedTestCase);
    }
}

