/*
 * Decompiled with CFR 0.152.
 */
package com.testmonitor.actions;

import com.testmonitor.api.Connector;
import com.testmonitor.parsers.MilestoneParser;
import com.testmonitor.resources.Milestone;
import com.testmonitor.resources.Project;
import java.io.IOException;
import java.net.URISyntaxException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.message.BasicNameValuePair;
import org.json.JSONObject;

public class Milestones {
    private final Connector connector;
    private final Integer projectId;

    public Milestones(Connector connector, Project project) {
        this.connector = connector;
        this.projectId = project.getId();
    }

    public ArrayList<Milestone> list() throws IOException, URISyntaxException {
        return this.list(1);
    }

    public ArrayList<Milestone> list(Integer page) throws IOException, URISyntaxException {
        return this.list(page, 15);
    }

    public ArrayList<Milestone> list(Integer page, Integer limit) throws IOException, URISyntaxException {
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        params.add(new BasicNameValuePair("project_id", this.projectId.toString()));
        params.add(new BasicNameValuePair("page", page.toString()));
        params.add(new BasicNameValuePair("limit", limit.toString()));
        return MilestoneParser.parse(this.connector.get("milestones", params));
    }

    public Milestone get(Integer id) throws IOException {
        JSONObject response = this.connector.get("milestones/" + id);
        HashMap milestone = (HashMap)response.getJSONObject("data").toMap();
        return MilestoneParser.parse(milestone);
    }

    public ArrayList<Milestone> search(String query) throws IOException, URISyntaxException {
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        params.add(new BasicNameValuePair("project_id", this.projectId.toString()));
        params.add(new BasicNameValuePair("query", query));
        return MilestoneParser.parse(this.connector.get("milestones", params));
    }

    public Milestone create(String name) throws IOException {
        Milestone milestone = new Milestone();
        milestone.setName(name);
        milestone.setEndsAt(LocalDate.now().plusMonths(1L));
        milestone.setProjectId(this.projectId);
        return this.create(milestone);
    }

    public Milestone create(Milestone milestone) throws IOException {
        JSONObject response = this.connector.post("milestones", milestone.toHttpParams());
        milestone.setId(response.getJSONObject("data").get("id").toString());
        return milestone;
    }

    public Milestone findOrCreate(String query) throws IOException, URISyntaxException {
        ArrayList<Milestone> milestones = this.search('\"' + query + '\"');
        if (milestones.size() > 0) {
            return milestones.get(0);
        }
        return this.create(query);
    }

    public Milestone update(Milestone milestone) throws IOException {
        JSONObject response = this.connector.put("milestones/" + milestone.getId(), milestone.toHttpParams());
        HashMap updatedMilestone = (HashMap)response.getJSONObject("data").toMap();
        return MilestoneParser.parse(updatedMilestone);
    }
}

