/*
 * Decompiled with CFR 0.152.
 */
package com.testmonitor.actions;

import com.testmonitor.api.Connector;
import com.testmonitor.parsers.TestCaseParser;
import com.testmonitor.resources.Project;
import com.testmonitor.resources.TestCase;
import com.testmonitor.resources.TestSuite;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.message.BasicNameValuePair;
import org.json.JSONObject;

public class TestCases {
    private final Connector connector;
    private final Integer projectId;

    public TestCases(Connector connector, Project project) {
        this.connector = connector;
        this.projectId = project.getId();
    }

    public ArrayList<TestCase> list() throws IOException, URISyntaxException {
        return this.list(1);
    }

    public ArrayList<TestCase> list(Integer page) throws IOException, URISyntaxException {
        return this.list(page, 15);
    }

    public ArrayList<TestCase> list(Integer page, Integer limit) throws IOException, URISyntaxException {
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        params.add(new BasicNameValuePair("project_id", this.projectId.toString()));
        params.add(new BasicNameValuePair("page", page.toString()));
        params.add(new BasicNameValuePair("limit", limit.toString()));
        return TestCaseParser.parse(this.connector.get("test-cases", params));
    }

    public TestCase get(Integer id) throws IOException, URISyntaxException {
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        params.add(new BasicNameValuePair("project_id", this.projectId.toString()));
        JSONObject response = this.connector.get("test-cases/" + id, params);
        HashMap testCase = (HashMap)response.getJSONObject("data").toMap();
        return TestCaseParser.parse(testCase);
    }

    public ArrayList<TestCase> search(String query) throws IOException, URISyntaxException {
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        params.add(new BasicNameValuePair("project_id", this.projectId.toString()));
        params.add(new BasicNameValuePair("query", query));
        return TestCaseParser.parse(this.connector.get("test-cases", params));
    }

    public ArrayList<TestCase> search(String query, Integer testSuiteId) throws IOException, URISyntaxException {
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        params.add(new BasicNameValuePair("project_id", this.projectId.toString()));
        params.add(new BasicNameValuePair("test_suite", testSuiteId.toString()));
        params.add(new BasicNameValuePair("query", query));
        return TestCaseParser.parse(this.connector.get("test-cases", params));
    }

    public TestCase create(TestCase testCase) throws IOException {
        JSONObject response = this.connector.post("test-cases", testCase.toHttpParams());
        testCase.setId(response.getJSONObject("data").get("id").toString());
        return testCase;
    }

    public TestCase create(String name, Integer testSuiteId) throws IOException {
        TestCase testCase = new TestCase();
        testCase.setName(name);
        testCase.setTestSuiteId(testSuiteId);
        return this.create(testCase);
    }

    public TestCase create(String name, TestSuite testSuite) throws IOException {
        return this.create(name, testSuite.getId());
    }

    public TestCase findOrCreate(String query, TestSuite testSuite) throws IOException, URISyntaxException {
        return this.findOrCreate(query, testSuite.getId());
    }

    public TestCase findOrCreate(TestCase testCase) throws IOException, URISyntaxException {
        return this.findOrCreate(testCase.getName(), testCase.getTestSuiteId());
    }

    public TestCase findOrCreate(String query, Integer testSuiteId) throws IOException, URISyntaxException {
        ArrayList<TestCase> testCases = this.search('\"' + query + '\"', testSuiteId);
        if (testCases.size() > 0) {
            return testCases.get(0);
        }
        return this.create(query, testSuiteId);
    }

    public TestCase update(TestCase testCase) throws IOException {
        JSONObject response = this.connector.put("test-cases/" + testCase.getId(), testCase.toHttpParams());
        HashMap updatedTestCase = (HashMap)response.getJSONObject("data").toMap();
        return TestCaseParser.parse(updatedTestCase);
    }
}

