/*
 * Decompiled with CFR 0.152.
 */
package com.testmonitor.actions;

import com.testmonitor.api.Connector;
import com.testmonitor.parsers.TestSuiteParser;
import com.testmonitor.resources.Project;
import com.testmonitor.resources.TestSuite;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.message.BasicNameValuePair;
import org.json.JSONObject;

public class TestSuites {
    private final Connector connector;
    private final Integer projectId;

    public TestSuites(Connector connector, Project project) {
        this.connector = connector;
        this.projectId = project.getId();
    }

    public ArrayList<TestSuite> list() throws IOException, URISyntaxException {
        return this.list(1);
    }

    public ArrayList<TestSuite> list(Integer page) throws IOException, URISyntaxException {
        return this.list(page, 15);
    }

    public ArrayList<TestSuite> list(Integer page, Integer limit) throws IOException, URISyntaxException {
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        params.add(new BasicNameValuePair("page", page.toString()));
        params.add(new BasicNameValuePair("limit", limit.toString()));
        params.add(new BasicNameValuePair("project_id", this.projectId.toString()));
        return TestSuiteParser.parse(this.connector.get("test-suites", params));
    }

    public TestSuite get(Integer id) throws IOException {
        JSONObject response = this.connector.get("test-suites/" + id);
        HashMap testSuite = (HashMap)response.getJSONObject("data").toMap();
        return TestSuiteParser.parse(testSuite);
    }

    public ArrayList<TestSuite> search(String query) throws IOException, URISyntaxException {
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        params.add(new BasicNameValuePair("project_id", this.projectId.toString()));
        params.add(new BasicNameValuePair("query", query));
        return TestSuiteParser.parse(this.connector.get("test-suites", params));
    }

    public TestSuite create(String name) throws IOException {
        TestSuite testSuite = new TestSuite();
        testSuite.setName(name);
        testSuite.setProjectId(this.projectId);
        return this.create(testSuite);
    }

    public TestSuite create(TestSuite testSuite) throws IOException {
        JSONObject response = this.connector.post("test-suites", testSuite.toHttpParams());
        HashMap updatedTestSuite = (HashMap)response.getJSONObject("data").toMap();
        return TestSuiteParser.parse(updatedTestSuite);
    }

    public ArrayList<TestSuite> findByName(String name) throws IOException, URISyntaxException {
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        params.add(new BasicNameValuePair("project_id", this.projectId.toString()));
        params.add(new BasicNameValuePair("filter[name]", name));
        return TestSuiteParser.parse(this.connector.get("test-suites", params));
    }

    public TestSuite findOrCreate(String name) throws IOException, URISyntaxException {
        ArrayList<TestSuite> testSuites = this.findByName(name);
        if (testSuites.size() > 0) {
            return testSuites.get(0);
        }
        return this.create(name);
    }

    public TestSuite update(TestSuite testSuite) throws IOException {
        JSONObject response = this.connector.put("test-suites/" + testSuite.getId(), testSuite.toHttpParams());
        HashMap updatedTestSuite = (HashMap)response.getJSONObject("data").toMap();
        return TestSuiteParser.parse(updatedTestSuite);
    }
}

