/*
 * Decompiled with CFR 0.152.
 */
package com.testmonitor.parsers;

import com.testmonitor.resources.TestRun;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import org.json.JSONObject;

public class TestRunParser {
    public static ArrayList<TestRun> parse(JSONObject response) {
        ArrayList<TestRun> testRuns = new ArrayList<TestRun>();
        for (Object obj : response.getJSONArray("data").toList()) {
            HashMap testRun = (HashMap)obj;
            testRuns.add(TestRunParser.parse(testRun));
        }
        return testRuns;
    }

    public static TestRun parse(HashMap<String, Object> item) {
        TestRun testRun = new TestRun();
        testRun.setId(item.get("id").toString()).setName(item.get("name").toString()).setMilestoneId(item.get("milestone_id").toString());
        if (item.get("description") != null) {
            testRun.setDescription(item.get("description").toString());
        }
        if (item.get("starts_at") != null) {
            testRun.setStartsAt(LocalDateTime.parse(item.get("starts_at").toString()));
        }
        if (item.get("ends_at") != null) {
            testRun.setEndsAt(LocalDateTime.parse(item.get("ends_at").toString()));
        }
        return testRun;
    }
}

