/*
 * Decompiled with CFR 0.152.
 */
package com.textkernel.tx;

import com.textkernel.tx.ApiEndpoints;
import com.textkernel.tx.DataCenter;
import com.textkernel.tx.TxUIClient;
import com.textkernel.tx.exceptions.TxException;
import com.textkernel.tx.exceptions.TxGeocodeJobException;
import com.textkernel.tx.exceptions.TxGeocodeResumeException;
import com.textkernel.tx.exceptions.TxIndexJobException;
import com.textkernel.tx.exceptions.TxIndexResumeException;
import com.textkernel.tx.http.HttpResponse;
import com.textkernel.tx.models.GeoCoordinates;
import com.textkernel.tx.models.api.ApiResponse;
import com.textkernel.tx.models.api.ApiResponseInfoLite;
import com.textkernel.tx.models.api.account.GetAccountInfoResponse;
import com.textkernel.tx.models.api.bimetricscoring.BimetricScoreJobRequest;
import com.textkernel.tx.models.api.bimetricscoring.BimetricScoreResponse;
import com.textkernel.tx.models.api.bimetricscoring.BimetricScoreResumeRequest;
import com.textkernel.tx.models.api.bimetricscoring.IParsedDocWithId;
import com.textkernel.tx.models.api.bimetricscoring.ParsedJobWithId;
import com.textkernel.tx.models.api.bimetricscoring.ParsedResumeWithId;
import com.textkernel.tx.models.api.dataenrichment.AutocompleteRequest;
import com.textkernel.tx.models.api.dataenrichment.GetMetadataResponse;
import com.textkernel.tx.models.api.dataenrichment.TaxonomyFormat;
import com.textkernel.tx.models.api.dataenrichment.ontology.request.CompareProfessionsRequest;
import com.textkernel.tx.models.api.dataenrichment.ontology.request.CompareSkillsToProfessionRequest;
import com.textkernel.tx.models.api.dataenrichment.ontology.request.SkillsSimilarityScoreRequest;
import com.textkernel.tx.models.api.dataenrichment.ontology.request.SuggestProfessionsRequest;
import com.textkernel.tx.models.api.dataenrichment.ontology.request.SuggestSkillsFromProfessionsRequest;
import com.textkernel.tx.models.api.dataenrichment.ontology.request.SuggestSkillsFromSkillsRequest;
import com.textkernel.tx.models.api.dataenrichment.ontology.response.CompareProfessionsResponse;
import com.textkernel.tx.models.api.dataenrichment.ontology.response.CompareSkillsToProfessionResponse;
import com.textkernel.tx.models.api.dataenrichment.ontology.response.SkillScore;
import com.textkernel.tx.models.api.dataenrichment.ontology.response.SkillsSimilarityScoreResponse;
import com.textkernel.tx.models.api.dataenrichment.ontology.response.SuggestProfessionsResponse;
import com.textkernel.tx.models.api.dataenrichment.ontology.response.SuggestSkillsResponse;
import com.textkernel.tx.models.api.dataenrichment.professions.request.LookupProfessionCodesRequest;
import com.textkernel.tx.models.api.dataenrichment.professions.request.NormalizeProfessionsRequest;
import com.textkernel.tx.models.api.dataenrichment.professions.response.GetProfessionsTaxonomyResponse;
import com.textkernel.tx.models.api.dataenrichment.professions.response.LookupProfessionCodesResponse;
import com.textkernel.tx.models.api.dataenrichment.professions.response.NormalizeProfessionsResponse;
import com.textkernel.tx.models.api.dataenrichment.professions.response.ProfessionsAutoCompleteResponse;
import com.textkernel.tx.models.api.dataenrichment.skills.request.ExtractSkillsRequest;
import com.textkernel.tx.models.api.dataenrichment.skills.request.LookupSkillsRequest;
import com.textkernel.tx.models.api.dataenrichment.skills.request.NormalizeSkillsRequest;
import com.textkernel.tx.models.api.dataenrichment.skills.request.SkillsAutoCompleteRequest;
import com.textkernel.tx.models.api.dataenrichment.skills.response.AutoCompleteSkillsResponse;
import com.textkernel.tx.models.api.dataenrichment.skills.response.ExtractSkillsResponse;
import com.textkernel.tx.models.api.dataenrichment.skills.response.GetSkillsTaxonomyResponse;
import com.textkernel.tx.models.api.dataenrichment.skills.response.LookupSkillCodesResponse;
import com.textkernel.tx.models.api.dataenrichment.skills.response.NormalizeSkillsResponse;
import com.textkernel.tx.models.api.geocoding.Address;
import com.textkernel.tx.models.api.geocoding.GeocodeAndIndexJobRequest;
import com.textkernel.tx.models.api.geocoding.GeocodeAndIndexJobResponse;
import com.textkernel.tx.models.api.geocoding.GeocodeAndIndexJobResponseValue;
import com.textkernel.tx.models.api.geocoding.GeocodeAndIndexResumeRequest;
import com.textkernel.tx.models.api.geocoding.GeocodeAndIndexResumeResponse;
import com.textkernel.tx.models.api.geocoding.GeocodeAndIndexResumeResponseValue;
import com.textkernel.tx.models.api.geocoding.GeocodeCredentials;
import com.textkernel.tx.models.api.geocoding.GeocodeJobRequest;
import com.textkernel.tx.models.api.geocoding.GeocodeJobResponse;
import com.textkernel.tx.models.api.geocoding.GeocodeOptionsBase;
import com.textkernel.tx.models.api.geocoding.GeocodeProvider;
import com.textkernel.tx.models.api.geocoding.GeocodeResumeRequest;
import com.textkernel.tx.models.api.geocoding.GeocodeResumeResponse;
import com.textkernel.tx.models.api.indexes.CreateIndexRequest;
import com.textkernel.tx.models.api.indexes.CreateIndexResponse;
import com.textkernel.tx.models.api.indexes.DeleteDocumentResponse;
import com.textkernel.tx.models.api.indexes.DeleteIndexResponse;
import com.textkernel.tx.models.api.indexes.DeleteMultipleDocumentsResponse;
import com.textkernel.tx.models.api.indexes.GetAllIndexesResponse;
import com.textkernel.tx.models.api.indexes.GetJobResponse;
import com.textkernel.tx.models.api.indexes.GetResumeResponse;
import com.textkernel.tx.models.api.indexes.IndexDocumentResponse;
import com.textkernel.tx.models.api.indexes.IndexJobInfo;
import com.textkernel.tx.models.api.indexes.IndexJobRequest;
import com.textkernel.tx.models.api.indexes.IndexMultipleDocumentsResponse;
import com.textkernel.tx.models.api.indexes.IndexMultipleJobsRequest;
import com.textkernel.tx.models.api.indexes.IndexMultipleResumesRequest;
import com.textkernel.tx.models.api.indexes.IndexResumeInfo;
import com.textkernel.tx.models.api.indexes.IndexResumeRequest;
import com.textkernel.tx.models.api.indexes.IndexSingleDocumentInfo;
import com.textkernel.tx.models.api.indexes.UpdateUserDefinedTagsRequest;
import com.textkernel.tx.models.api.indexes.UpdateUserDefinedTagsResponse;
import com.textkernel.tx.models.api.indexes.UserDefinedTagsMethod;
import com.textkernel.tx.models.api.matching.CategoryWeights;
import com.textkernel.tx.models.api.matching.MatchJobRequest;
import com.textkernel.tx.models.api.matching.MatchResponse;
import com.textkernel.tx.models.api.matching.MatchResumeRequest;
import com.textkernel.tx.models.api.matching.SearchRequest;
import com.textkernel.tx.models.api.matching.SearchResponse;
import com.textkernel.tx.models.api.matching.request.FilterCriteria;
import com.textkernel.tx.models.api.matching.request.MatchByDocumentIdOptions;
import com.textkernel.tx.models.api.matching.request.PaginationSettings;
import com.textkernel.tx.models.api.matching.request.SearchMatchSettings;
import com.textkernel.tx.models.api.matching.ui.GenerateUIResponse;
import com.textkernel.tx.models.api.matching.ui.request.MatchUISettings;
import com.textkernel.tx.models.api.matching.ui.request.UIBimetricScoreJobRequest;
import com.textkernel.tx.models.api.matching.ui.request.UIBimetricScoreResumeRequest;
import com.textkernel.tx.models.api.matching.ui.request.UIMatchByDocumentIdOptions;
import com.textkernel.tx.models.api.matching.ui.request.UIMatchJobRequest;
import com.textkernel.tx.models.api.matching.ui.request.UIMatchResumeRequest;
import com.textkernel.tx.models.api.matching.ui.request.UISearchRequest;
import com.textkernel.tx.models.api.parsing.ParseJobResponse;
import com.textkernel.tx.models.api.parsing.ParseJobResponseValue;
import com.textkernel.tx.models.api.parsing.ParseRequest;
import com.textkernel.tx.models.api.parsing.ParseResumeResponse;
import com.textkernel.tx.models.api.parsing.ParseResumeResponseValue;
import com.textkernel.tx.models.job.ParsedJob;
import com.textkernel.tx.models.matching.IndexType;
import com.textkernel.tx.models.resume.ParsedResume;
import com.textkernel.tx.models.resume.employment.Position;
import com.textkernel.tx.models.resume.skills.ResumeNormalizedSkill;
import com.textkernel.tx.utilities.TxJsonSerializer;
import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okio.Buffer;
import okio.BufferedSink;

public class TxClient {
    private ApiEndpoints _endpoints;
    private OkHttpClient _client;
    private static final MediaType JSON = MediaType.get((String)"application/json; charset=utf-8");
    private static final String _sdkVersion = TxClient.class.getPackage().getImplementationVersion();
    public boolean ShowFullRequestBodyInExceptions = false;

    public TxClient(String accountId, String serviceKey, DataCenter dataCenter) {
        this(accountId, serviceKey, dataCenter, null);
    }

    public TxClient(final String accountId, final String serviceKey, DataCenter dataCenter, List<String> trackingTags) {
        String trackingTagsHeaderValue;
        if (accountId == null || accountId.length() == 0) {
            throw new IllegalArgumentException("'accountId' must have a valid value");
        }
        if (serviceKey == null || serviceKey.length() == 0) {
            throw new IllegalArgumentException("'serviceKey' must have a valid value");
        }
        if (dataCenter == null) {
            throw new IllegalArgumentException("'dataCenter' must not be null");
        }
        this._endpoints = new ApiEndpoints(dataCenter);
        if (trackingTags != null && trackingTags.size() > 0) {
            trackingTagsHeaderValue = String.join((CharSequence)", ", trackingTags);
            if (trackingTagsHeaderValue.length() >= 75) {
                throw new IllegalArgumentException("'trackingTags' has too many values or the values are too long");
            }
        } else {
            trackingTagsHeaderValue = null;
        }
        this._client = new OkHttpClient.Builder().addInterceptor(new Interceptor(){

            public Response intercept(Interceptor.Chain chain) throws IOException {
                Request original = chain.request();
                Request.Builder builder = original.newBuilder();
                builder.header("Sovren-AccountId", accountId);
                builder.header("Sovren-ServiceKey", serviceKey);
                builder.header("User-Agent", "tx-java-" + _sdkVersion);
                if (trackingTagsHeaderValue != null && !trackingTagsHeaderValue.isEmpty()) {
                    builder.header("Sovren-TrackingTag", trackingTagsHeaderValue);
                }
                Request request = builder.build();
                return chain.proceed(request);
            }
        }).build();
    }

    private RequestBody createJsonBody(Object body) {
        return RequestBody.create((MediaType)JSON, (String)TxJsonSerializer.serialize(body));
    }

    private <T extends ApiResponse<?>> HttpResponse<T> executeRequest(Request apiRequest, Class<T> classOfT, String requestBody) throws TxException {
        ApiResponseInfoLite errorInfo = new ApiResponseInfoLite();
        errorInfo.Code = "Error";
        errorInfo.Message = "Unknown API error.";
        HttpResponse<T> apiResponse = null;
        Response rawResponse = null;
        try {
            rawResponse = this._client.newCall(apiRequest).execute();
            apiResponse = new HttpResponse<T>(rawResponse, classOfT);
            if (rawResponse != null && rawResponse.code() == 413) {
                errorInfo.Message = "Request body was too large.";
                throw new TxException(requestBody, rawResponse, errorInfo, null);
            }
            if (rawResponse != null && apiResponse.getData() == null && rawResponse.code() != 200) {
                errorInfo.Message = rawResponse.code() + " - " + rawResponse.message();
            }
            if (apiResponse == null || apiResponse.getData() == null) {
                throw new TxException(requestBody, rawResponse, errorInfo, null);
            }
        }
        catch (IOException e) {
            errorInfo.Message = e.getMessage();
            TxException newEx = new TxException(requestBody, rawResponse, errorInfo, null);
            newEx.InnerException = e;
            throw newEx;
        }
        if (!rawResponse.isSuccessful()) {
            throw new TxException(requestBody, rawResponse, ((ApiResponse)apiResponse.getData()).Info);
        }
        return apiResponse;
    }

    private GenerateUIResponse executeUIRequest(Request apiRequest, String requestBody) throws TxException {
        ApiResponseInfoLite errorInfo = new ApiResponseInfoLite();
        errorInfo.Code = "Error";
        errorInfo.Message = "Unknown API error.";
        GenerateUIResponse apiResponse = null;
        Response rawResponse = null;
        String transId = "matchui-" + Instant.now().toString();
        try {
            rawResponse = this._client.newCall(apiRequest).execute();
            if (!rawResponse.isSuccessful()) {
                errorInfo.Message = rawResponse.body().string();
                throw new TxException(requestBody, rawResponse, errorInfo, transId);
            }
            String responseBodyStr = rawResponse.body().string();
            apiResponse = TxJsonSerializer.deserialize(responseBodyStr, GenerateUIResponse.class);
            if (apiResponse == null) {
                throw new TxException(requestBody, rawResponse, errorInfo, transId);
            }
        }
        catch (IOException e) {
            errorInfo.Message = e.getMessage();
            TxException newEx = new TxException(requestBody, rawResponse, errorInfo, transId);
            newEx.InnerException = e;
            throw newEx;
        }
        return apiResponse;
    }

    private String getBodyIfDebug(Request request) {
        if (this.ShowFullRequestBodyInExceptions) {
            try {
                Request copy = request.newBuilder().build();
                Buffer buffer = new Buffer();
                copy.body().writeTo((BufferedSink)buffer);
                return buffer.readUtf8();
            }
            catch (IOException e) {
                return null;
            }
        }
        return null;
    }

    public GetAccountInfoResponse getAccountInfo() throws TxException {
        Request apiRequest = new Request.Builder().url(this._endpoints.account()).build();
        HttpResponse<GetAccountInfoResponse> response = this.executeRequest(apiRequest, GetAccountInfoResponse.class, this.getBodyIfDebug(apiRequest));
        return response.getData();
    }

    public ParseResumeResponse parseResume(ParseRequest request) throws TxException {
        RequestBody body = this.createJsonBody(request);
        Request apiRequest = new Request.Builder().url(this._endpoints.parseResume()).post(body).build();
        HttpResponse<ParseResumeResponse> response = this.executeRequest(apiRequest, ParseResumeResponse.class, this.getBodyIfDebug(apiRequest));
        if (((ParseResumeResponseValue)response.getData().Value).ParsingResponse != null && !((ParseResumeResponseValue)response.getData().Value).ParsingResponse.isSuccess()) {
            throw new TxException(this.getBodyIfDebug(apiRequest), response.getResponse(), ((ParseResumeResponseValue)response.getData().Value).ParsingResponse, response.getData().Info.TransactionId);
        }
        if (((ParseResumeResponseValue)response.getData().Value).GeocodeResponse != null && !((ParseResumeResponseValue)response.getData().Value).GeocodeResponse.isSuccess()) {
            throw new TxGeocodeResumeException(response.getResponse(), ((ParseResumeResponseValue)response.getData().Value).GeocodeResponse, response.getData().Info.TransactionId, response.getData());
        }
        if (((ParseResumeResponseValue)response.getData().Value).IndexingResponse != null && !((ParseResumeResponseValue)response.getData().Value).IndexingResponse.isSuccess()) {
            throw new TxIndexResumeException(response.getResponse(), ((ParseResumeResponseValue)response.getData().Value).IndexingResponse, response.getData().Info.TransactionId, response.getData());
        }
        return response.getData();
    }

    public ParseJobResponse parseJob(ParseRequest request) throws TxException {
        RequestBody body = this.createJsonBody(request);
        Request apiRequest = new Request.Builder().url(this._endpoints.parseJob()).post(body).build();
        HttpResponse<ParseJobResponse> response = this.executeRequest(apiRequest, ParseJobResponse.class, this.getBodyIfDebug(apiRequest));
        if (((ParseJobResponseValue)response.getData().Value).ParsingResponse != null && !((ParseJobResponseValue)response.getData().Value).ParsingResponse.isSuccess()) {
            throw new TxException(this.getBodyIfDebug(apiRequest), response.getResponse(), ((ParseJobResponseValue)response.getData().Value).ParsingResponse, response.getData().Info.TransactionId);
        }
        if (((ParseJobResponseValue)response.getData().Value).GeocodeResponse != null && !((ParseJobResponseValue)response.getData().Value).GeocodeResponse.isSuccess()) {
            throw new TxGeocodeJobException(response.getResponse(), ((ParseJobResponseValue)response.getData().Value).GeocodeResponse, response.getData().Info.TransactionId, response.getData());
        }
        if (((ParseJobResponseValue)response.getData().Value).IndexingResponse != null && !((ParseJobResponseValue)response.getData().Value).IndexingResponse.isSuccess()) {
            throw new TxIndexJobException(response.getResponse(), ((ParseJobResponseValue)response.getData().Value).IndexingResponse, response.getData().Info.TransactionId, response.getData());
        }
        return response.getData();
    }

    public CreateIndexResponse createIndex(IndexType type, String indexId) throws TxException {
        CreateIndexRequest request = new CreateIndexRequest();
        request.IndexType = type;
        RequestBody body = this.createJsonBody(request);
        Request apiRequest = new Request.Builder().url(this._endpoints.index(indexId)).post(body).build();
        HttpResponse<CreateIndexResponse> response = this.executeRequest(apiRequest, CreateIndexResponse.class, this.getBodyIfDebug(apiRequest));
        return response.getData();
    }

    public GetAllIndexesResponse getAllIndexes() throws TxException {
        Request apiRequest = new Request.Builder().url(this._endpoints.allIndexes()).build();
        HttpResponse<GetAllIndexesResponse> response = this.executeRequest(apiRequest, GetAllIndexesResponse.class, this.getBodyIfDebug(apiRequest));
        return response.getData();
    }

    public DeleteIndexResponse deleteIndex(String indexId) throws TxException {
        Request apiRequest = new Request.Builder().url(this._endpoints.index(indexId)).delete().build();
        HttpResponse<DeleteIndexResponse> response = this.executeRequest(apiRequest, DeleteIndexResponse.class, this.getBodyIfDebug(apiRequest));
        return response.getData();
    }

    public IndexDocumentResponse indexDocument(ParsedResume resume, String indexId, String documentId, List<String> userDefinedTags) throws TxException {
        IndexResumeRequest request = new IndexResumeRequest();
        request.ResumeData = resume;
        request.UserDefinedTags = userDefinedTags;
        RequestBody body = this.createJsonBody(request);
        Request apiRequest = new Request.Builder().url(this._endpoints.resume(indexId, documentId)).post(body).build();
        HttpResponse<IndexDocumentResponse> response = this.executeRequest(apiRequest, IndexDocumentResponse.class, this.getBodyIfDebug(apiRequest));
        return response.getData();
    }

    public IndexDocumentResponse indexDocument(ParsedJob job, String indexId, String documentId, List<String> userDefinedTags) throws TxException {
        IndexJobRequest request = new IndexJobRequest();
        request.JobData = job;
        request.UserDefinedTags = userDefinedTags;
        RequestBody body = this.createJsonBody(request);
        Request apiRequest = new Request.Builder().url(this._endpoints.job(indexId, documentId)).post(body).build();
        HttpResponse<IndexDocumentResponse> response = this.executeRequest(apiRequest, IndexDocumentResponse.class, this.getBodyIfDebug(apiRequest));
        return response.getData();
    }

    public IndexMultipleDocumentsResponse indexMultipleResumes(List<IndexResumeInfo> resumes, String indexId) throws TxException {
        IndexMultipleResumesRequest request = new IndexMultipleResumesRequest();
        request.Resumes = resumes;
        RequestBody body = this.createJsonBody(request);
        Request apiRequest = new Request.Builder().url(this._endpoints.multipleResumes(indexId)).post(body).build();
        HttpResponse<IndexMultipleDocumentsResponse> response = this.executeRequest(apiRequest, IndexMultipleDocumentsResponse.class, this.getBodyIfDebug(apiRequest));
        return response.getData();
    }

    public IndexMultipleDocumentsResponse indexMultipleJobs(List<IndexJobInfo> jobs, String indexId) throws TxException {
        IndexMultipleJobsRequest request = new IndexMultipleJobsRequest();
        request.Jobs = jobs;
        RequestBody body = this.createJsonBody(request);
        Request apiRequest = new Request.Builder().url(this._endpoints.multipleJobs(indexId)).post(body).build();
        HttpResponse<IndexMultipleDocumentsResponse> response = this.executeRequest(apiRequest, IndexMultipleDocumentsResponse.class, this.getBodyIfDebug(apiRequest));
        return response.getData();
    }

    public DeleteDocumentResponse deleteDocument(String indexId, String documentId) throws TxException {
        Request apiRequest = new Request.Builder().url(this._endpoints.document(indexId, documentId)).delete().build();
        HttpResponse<DeleteDocumentResponse> response = this.executeRequest(apiRequest, DeleteDocumentResponse.class, this.getBodyIfDebug(apiRequest));
        return response.getData();
    }

    public DeleteMultipleDocumentsResponse deleteMultipleDocuments(String indexId, List<String> documentIds) throws TxException {
        RequestBody requestBody = this.createJsonBody(documentIds);
        Request apiRequest = new Request.Builder().url(this._endpoints.multipleDocuments(indexId)).delete(requestBody).build();
        HttpResponse<DeleteMultipleDocumentsResponse> response = this.executeRequest(apiRequest, DeleteMultipleDocumentsResponse.class, this.getBodyIfDebug(apiRequest));
        return response.getData();
    }

    public GetResumeResponse getResume(String indexId, String documentId) throws TxException {
        Request apiRequest = new Request.Builder().url(this._endpoints.resume(indexId, documentId)).build();
        HttpResponse<GetResumeResponse> response = this.executeRequest(apiRequest, GetResumeResponse.class, this.getBodyIfDebug(apiRequest));
        return response.getData();
    }

    public GetJobResponse getJob(String indexId, String documentId) throws TxException {
        Request apiRequest = new Request.Builder().url(this._endpoints.job(indexId, documentId)).build();
        HttpResponse<GetJobResponse> response = this.executeRequest(apiRequest, GetJobResponse.class, this.getBodyIfDebug(apiRequest));
        return response.getData();
    }

    public UpdateUserDefinedTagsResponse updateResumeUserDefinedTags(String indexId, String documentId, List<String> userDefinedTags, UserDefinedTagsMethod method) throws TxException {
        UpdateUserDefinedTagsRequest request = new UpdateUserDefinedTagsRequest();
        request.UserDefinedTags = userDefinedTags;
        request.Method = method;
        RequestBody body = this.createJsonBody(request);
        Request apiRequest = new Request.Builder().url(this._endpoints.resume(indexId, documentId)).patch(body).build();
        HttpResponse<UpdateUserDefinedTagsResponse> response = this.executeRequest(apiRequest, UpdateUserDefinedTagsResponse.class, this.getBodyIfDebug(apiRequest));
        return response.getData();
    }

    public UpdateUserDefinedTagsResponse updateJobUserDefinedTags(String indexId, String documentId, List<String> userDefinedTags, UserDefinedTagsMethod method) throws TxException {
        UpdateUserDefinedTagsRequest request = new UpdateUserDefinedTagsRequest();
        request.UserDefinedTags = userDefinedTags;
        request.Method = method;
        RequestBody body = this.createJsonBody(request);
        Request apiRequest = new Request.Builder().url(this._endpoints.job(indexId, documentId)).patch(body).build();
        HttpResponse<UpdateUserDefinedTagsResponse> response = this.executeRequest(apiRequest, UpdateUserDefinedTagsResponse.class, this.getBodyIfDebug(apiRequest));
        return response.getData();
    }

    public MatchResponse match(ParsedResume resume, List<String> indexesToQuery, CategoryWeights preferredWeights, FilterCriteria filters, SearchMatchSettings settings, int numResults) throws TxException {
        MatchResumeRequest request = this.createRequest(resume, indexesToQuery, preferredWeights, filters, settings, numResults);
        RequestBody body = this.createJsonBody(request);
        Request apiRequest = new Request.Builder().url(this._endpoints.matchResume(false)).post(body).build();
        HttpResponse<MatchResponse> response = this.executeRequest(apiRequest, MatchResponse.class, this.getBodyIfDebug(apiRequest));
        return response.getData();
    }

    MatchResumeRequest createRequest(ParsedResume resume, List<String> indexesToQuery, CategoryWeights preferredWeights, FilterCriteria filters, SearchMatchSettings settings, int numResults) {
        MatchResumeRequest request = new MatchResumeRequest();
        request.ResumeData = resume;
        request.IndexIdsToSearchInto = indexesToQuery;
        request.PreferredCategoryWeights = preferredWeights;
        request.FilterCriteria = filters;
        request.Settings = settings;
        request.Take = numResults;
        return request;
    }

    public MatchResponse match(ParsedJob job, List<String> indexesToQuery, CategoryWeights preferredWeights, FilterCriteria filters, SearchMatchSettings settings, int numResults) throws TxException {
        MatchJobRequest request = this.createRequest(job, indexesToQuery, preferredWeights, filters, settings, numResults);
        RequestBody body = this.createJsonBody(request);
        Request apiRequest = new Request.Builder().url(this._endpoints.matchJob(false)).post(body).build();
        HttpResponse<MatchResponse> response = this.executeRequest(apiRequest, MatchResponse.class, this.getBodyIfDebug(apiRequest));
        return response.getData();
    }

    MatchJobRequest createRequest(ParsedJob job, List<String> indexesToQuery, CategoryWeights preferredWeights, FilterCriteria filters, SearchMatchSettings settings, int numResults) {
        MatchJobRequest request = new MatchJobRequest();
        request.JobData = job;
        request.IndexIdsToSearchInto = indexesToQuery;
        request.PreferredCategoryWeights = preferredWeights;
        request.FilterCriteria = filters;
        request.Settings = settings;
        request.Take = numResults;
        return request;
    }

    public MatchResponse match(String indexId, String documentId, List<String> indexesToQuery, CategoryWeights preferredWeights, FilterCriteria filters, SearchMatchSettings settings, int numResults) throws TxException {
        MatchByDocumentIdOptions request = this.createRequest(indexesToQuery, preferredWeights, filters, settings, numResults);
        RequestBody body = this.createJsonBody(request);
        Request apiRequest = new Request.Builder().url(this._endpoints.matchDocId(indexId, documentId, false)).post(body).build();
        HttpResponse<MatchResponse> response = this.executeRequest(apiRequest, MatchResponse.class, this.getBodyIfDebug(apiRequest));
        return response.getData();
    }

    MatchByDocumentIdOptions createRequest(List<String> indexesToQuery, CategoryWeights preferredWeights, FilterCriteria filters, SearchMatchSettings settings, int numResults) {
        MatchByDocumentIdOptions request = new MatchByDocumentIdOptions();
        request.IndexIdsToSearchInto = indexesToQuery;
        request.PreferredCategoryWeights = preferredWeights;
        request.FilterCriteria = filters;
        request.Settings = settings;
        request.Take = numResults;
        return request;
    }

    GenerateUIResponse uiMatch(String indexId, String documentId, UIMatchByDocumentIdOptions options) throws TxException {
        RequestBody body = this.createJsonBody(options);
        Request apiRequest = new Request.Builder().url(this._endpoints.matchDocId(indexId, documentId, true)).post(body).build();
        GenerateUIResponse response = this.executeUIRequest(apiRequest, this.getBodyIfDebug(apiRequest));
        return response;
    }

    GenerateUIResponse uiMatch(UIMatchResumeRequest request) throws TxException {
        RequestBody body = this.createJsonBody(request);
        Request apiRequest = new Request.Builder().url(this._endpoints.matchResume(true)).post(body).build();
        GenerateUIResponse response = this.executeUIRequest(apiRequest, this.getBodyIfDebug(apiRequest));
        return response;
    }

    GenerateUIResponse uiMatch(UIMatchJobRequest request) throws TxException {
        RequestBody body = this.createJsonBody(request);
        Request apiRequest = new Request.Builder().url(this._endpoints.matchJob(true)).post(body).build();
        GenerateUIResponse response = this.executeUIRequest(apiRequest, this.getBodyIfDebug(apiRequest));
        return response;
    }

    public SearchResponse search(List<String> indexesToQuery, FilterCriteria query, SearchMatchSettings settings, PaginationSettings pagination) throws TxException {
        SearchRequest request = this.createRequest(indexesToQuery, query, settings, pagination);
        RequestBody body = this.createJsonBody(request);
        Request apiRequest = new Request.Builder().url(this._endpoints.search(false)).post(body).build();
        HttpResponse<SearchResponse> response = this.executeRequest(apiRequest, SearchResponse.class, this.getBodyIfDebug(apiRequest));
        return response.getData();
    }

    SearchRequest createRequest(List<String> indexesToQuery, FilterCriteria query, SearchMatchSettings settings, PaginationSettings pagination) {
        SearchRequest request = new SearchRequest();
        request.IndexIdsToSearchInto = indexesToQuery;
        request.FilterCriteria = query;
        request.Settings = settings;
        request.PaginationSettings = pagination;
        return request;
    }

    GenerateUIResponse uiSearch(UISearchRequest request) throws TxException {
        RequestBody body = this.createJsonBody(request);
        Request apiRequest = new Request.Builder().url(this._endpoints.search(true)).post(body).build();
        GenerateUIResponse response = this.executeUIRequest(apiRequest, this.getBodyIfDebug(apiRequest));
        return response;
    }

    public <TTarget extends IParsedDocWithId> BimetricScoreResponse bimetricScore(ParsedResumeWithId sourceResume, List<TTarget> targetDocuments, CategoryWeights preferredWeights, SearchMatchSettings settings) throws TxException {
        BimetricScoreResumeRequest request = this.createRequest(sourceResume, targetDocuments, preferredWeights, settings);
        RequestBody body = this.createJsonBody(request);
        Request apiRequest = new Request.Builder().url(this._endpoints.bimetricScoreResume(false)).post(body).build();
        HttpResponse<BimetricScoreResponse> response = this.executeRequest(apiRequest, BimetricScoreResponse.class, this.getBodyIfDebug(apiRequest));
        return response.getData();
    }

    <TTarget extends IParsedDocWithId> BimetricScoreResumeRequest createRequest(ParsedResumeWithId sourceResume, List<TTarget> targetDocuments, CategoryWeights preferredWeights, SearchMatchSettings settings) {
        BimetricScoreResumeRequest request = new BimetricScoreResumeRequest();
        request.PreferredCategoryWeights = preferredWeights;
        request.Settings = settings;
        request.SourceResume = sourceResume;
        if (targetDocuments.size() > 0) {
            if (targetDocuments.get(0) instanceof ParsedResumeWithId) {
                request.TargetResumes = targetDocuments;
            } else {
                request.TargetJobs = targetDocuments;
            }
        }
        return request;
    }

    public <TTarget extends IParsedDocWithId> BimetricScoreResponse bimetricScore(ParsedJobWithId sourceJob, List<TTarget> targetDocuments, CategoryWeights preferredWeights, SearchMatchSettings settings) throws TxException {
        BimetricScoreJobRequest request = this.createRequest(sourceJob, targetDocuments, preferredWeights, settings);
        RequestBody body = this.createJsonBody(request);
        Request apiRequest = new Request.Builder().url(this._endpoints.bimetricScoreJob(false)).post(body).build();
        HttpResponse<BimetricScoreResponse> response = this.executeRequest(apiRequest, BimetricScoreResponse.class, this.getBodyIfDebug(apiRequest));
        return response.getData();
    }

    <TTarget extends IParsedDocWithId> BimetricScoreJobRequest createRequest(ParsedJobWithId sourceJob, List<TTarget> targetDocuments, CategoryWeights preferredWeights, SearchMatchSettings settings) {
        BimetricScoreJobRequest request = new BimetricScoreJobRequest();
        request.PreferredCategoryWeights = preferredWeights;
        request.Settings = settings;
        request.SourceJob = sourceJob;
        if (targetDocuments.size() > 0) {
            if (targetDocuments.get(0) instanceof ParsedResumeWithId) {
                request.TargetResumes = targetDocuments;
            } else {
                request.TargetJobs = targetDocuments;
            }
        }
        return request;
    }

    GenerateUIResponse uiBimetricScore(UIBimetricScoreResumeRequest request) throws TxException {
        RequestBody body = this.createJsonBody(request);
        Request apiRequest = new Request.Builder().url(this._endpoints.bimetricScoreResume(true)).post(body).build();
        GenerateUIResponse response = this.executeUIRequest(apiRequest, this.getBodyIfDebug(apiRequest));
        return response;
    }

    GenerateUIResponse uiBimetricScore(UIBimetricScoreJobRequest request) throws TxException {
        RequestBody body = this.createJsonBody(request);
        Request apiRequest = new Request.Builder().url(this._endpoints.bimetricScoreJob(true)).post(body).build();
        GenerateUIResponse response = this.executeUIRequest(apiRequest, this.getBodyIfDebug(apiRequest));
        return response;
    }

    private GeocodeResumeResponse internalGeocode(ParsedResume resume, GeocodeCredentials geocodeCredentials, Address address) throws TxException {
        GeocodeResumeRequest request = new GeocodeResumeRequest();
        request.ResumeData = resume;
        request.Provider = geocodeCredentials != null ? geocodeCredentials.Provider : GeocodeProvider.Google;
        request.ProviderKey = geocodeCredentials != null ? geocodeCredentials.ProviderKey : null;
        request.PostalAddress = address;
        RequestBody body = this.createJsonBody(request);
        Request apiRequest = new Request.Builder().url(this._endpoints.geocodeResume()).post(body).build();
        HttpResponse<GeocodeResumeResponse> response = this.executeRequest(apiRequest, GeocodeResumeResponse.class, this.getBodyIfDebug(apiRequest));
        return response.getData();
    }

    private GeocodeJobResponse internalGeocode(ParsedJob job, GeocodeCredentials geocodeCredentials, Address address) throws TxException {
        GeocodeJobRequest request = new GeocodeJobRequest();
        request.JobData = job;
        request.Provider = geocodeCredentials != null ? geocodeCredentials.Provider : GeocodeProvider.Google;
        request.ProviderKey = geocodeCredentials != null ? geocodeCredentials.ProviderKey : null;
        request.PostalAddress = address;
        RequestBody body = this.createJsonBody(request);
        Request apiRequest = new Request.Builder().url(this._endpoints.geocodeJob()).post(body).build();
        HttpResponse<GeocodeJobResponse> response = this.executeRequest(apiRequest, GeocodeJobResponse.class, this.getBodyIfDebug(apiRequest));
        return response.getData();
    }

    public GeocodeResumeResponse geocode(ParsedResume resume, GeocodeCredentials geocodeCredentials) throws TxException {
        return this.internalGeocode(resume, geocodeCredentials, null);
    }

    public GeocodeResumeResponse geocode(ParsedResume resume, Address address, GeocodeCredentials geocodeCredentials) throws TxException {
        return this.internalGeocode(resume, geocodeCredentials, address);
    }

    public GeocodeJobResponse geocode(ParsedJob job, GeocodeCredentials geocodeCredentials) throws TxException {
        return this.internalGeocode(job, geocodeCredentials, null);
    }

    public GeocodeJobResponse geocode(ParsedJob job, Address address, GeocodeCredentials geocodeCredentials) throws TxException {
        return this.internalGeocode(job, geocodeCredentials, address);
    }

    private GeocodeAndIndexResumeResponse internalGeocodeAndIndex(ParsedResume resume, GeocodeCredentials geocodeCredentials, IndexSingleDocumentInfo indexingOptions, boolean indexIfGeocodeFails, Address address, GeoCoordinates coordinates) throws TxException {
        GeocodeOptionsBase options = new GeocodeOptionsBase();
        options.Provider = geocodeCredentials != null ? geocodeCredentials.Provider : GeocodeProvider.Google;
        options.ProviderKey = geocodeCredentials != null ? geocodeCredentials.ProviderKey : null;
        options.PostalAddress = address;
        options.GeoCoordinates = coordinates;
        GeocodeAndIndexResumeRequest request = new GeocodeAndIndexResumeRequest();
        request.ResumeData = resume;
        request.GeocodeOptions = options;
        request.IndexingOptions = indexingOptions;
        request.IndexIfGeocodeFails = indexIfGeocodeFails;
        RequestBody body = this.createJsonBody(request);
        Request apiRequest = new Request.Builder().url(this._endpoints.geocodeAndIndexResume()).post(body).build();
        HttpResponse<GeocodeAndIndexResumeResponse> response = this.executeRequest(apiRequest, GeocodeAndIndexResumeResponse.class, this.getBodyIfDebug(apiRequest));
        GeocodeAndIndexResumeResponseValue responseVal = (GeocodeAndIndexResumeResponseValue)response.getData().Value;
        if (!indexIfGeocodeFails && responseVal.GeocodeResponse != null && !responseVal.GeocodeResponse.isSuccess()) {
            throw new TxException(this.getBodyIfDebug(apiRequest), response.getResponse(), responseVal.GeocodeResponse, response.getData().getInfo().TransactionId);
        }
        if (responseVal.IndexingResponse != null && !responseVal.IndexingResponse.isSuccess()) {
            throw new TxException(this.getBodyIfDebug(apiRequest), response.getResponse(), responseVal.IndexingResponse, response.getData().getInfo().TransactionId);
        }
        return response.getData();
    }

    private GeocodeAndIndexJobResponse internalGeocodeAndIndex(ParsedJob job, GeocodeCredentials geocodeCredentials, IndexSingleDocumentInfo indexingOptions, boolean indexIfGeocodeFails, Address address, GeoCoordinates coordinates) throws TxException {
        GeocodeOptionsBase options = new GeocodeOptionsBase();
        options.Provider = geocodeCredentials != null ? geocodeCredentials.Provider : GeocodeProvider.Google;
        options.ProviderKey = geocodeCredentials != null ? geocodeCredentials.ProviderKey : null;
        options.PostalAddress = address;
        options.GeoCoordinates = coordinates;
        GeocodeAndIndexJobRequest request = new GeocodeAndIndexJobRequest();
        request.JobData = job;
        request.GeocodeOptions = options;
        request.IndexingOptions = indexingOptions;
        request.IndexIfGeocodeFails = indexIfGeocodeFails;
        RequestBody body = this.createJsonBody(request);
        Request apiRequest = new Request.Builder().url(this._endpoints.geocodeAndIndexJob()).post(body).build();
        HttpResponse<GeocodeAndIndexJobResponse> response = this.executeRequest(apiRequest, GeocodeAndIndexJobResponse.class, this.getBodyIfDebug(apiRequest));
        GeocodeAndIndexJobResponseValue responseVal = (GeocodeAndIndexJobResponseValue)response.getData().Value;
        if (!indexIfGeocodeFails && responseVal.GeocodeResponse != null && !responseVal.GeocodeResponse.isSuccess()) {
            throw new TxException(this.getBodyIfDebug(apiRequest), response.getResponse(), responseVal.GeocodeResponse, response.getData().getInfo().TransactionId);
        }
        if (responseVal.IndexingResponse != null && !responseVal.IndexingResponse.isSuccess()) {
            throw new TxException(this.getBodyIfDebug(apiRequest), response.getResponse(), responseVal.IndexingResponse, response.getData().getInfo().TransactionId);
        }
        return response.getData();
    }

    public GeocodeAndIndexResumeResponse geocodeAndIndex(ParsedResume resume, IndexSingleDocumentInfo indexingOptions, boolean indexIfGeocodeFails, GeocodeCredentials geocodeCredentials) throws TxException {
        return this.internalGeocodeAndIndex(resume, geocodeCredentials, indexingOptions, indexIfGeocodeFails, null, null);
    }

    public GeocodeAndIndexResumeResponse geocodeAndIndex(ParsedResume resume, IndexSingleDocumentInfo indexingOptions, Address address, boolean indexIfGeocodeFails, GeocodeCredentials geocodeCredentials) throws TxException {
        return this.internalGeocodeAndIndex(resume, geocodeCredentials, indexingOptions, indexIfGeocodeFails, address, null);
    }

    public GeocodeAndIndexResumeResponse geocodeAndIndex(ParsedResume resume, IndexSingleDocumentInfo indexingOptions, GeoCoordinates coordinates, boolean indexIfGeocodeFails, GeocodeCredentials geocodeCredentials) throws TxException {
        return this.internalGeocodeAndIndex(resume, geocodeCredentials, indexingOptions, indexIfGeocodeFails, null, coordinates);
    }

    public GeocodeAndIndexJobResponse geocodeAndIndex(ParsedJob job, IndexSingleDocumentInfo indexingOptions, boolean indexIfGeocodeFails, GeocodeCredentials geocodeCredentials) throws TxException {
        return this.internalGeocodeAndIndex(job, geocodeCredentials, indexingOptions, indexIfGeocodeFails, null, null);
    }

    public GeocodeAndIndexJobResponse geocodeAndIndex(ParsedJob job, IndexSingleDocumentInfo indexingOptions, Address address, boolean indexIfGeocodeFails, GeocodeCredentials geocodeCredentials) throws TxException {
        return this.internalGeocodeAndIndex(job, geocodeCredentials, indexingOptions, indexIfGeocodeFails, address, null);
    }

    public GeocodeAndIndexJobResponse geocodeAndIndex(ParsedJob job, IndexSingleDocumentInfo indexingOptions, GeoCoordinates coordinates, boolean indexIfGeocodeFails, GeocodeCredentials geocodeCredentials) throws TxException {
        return this.internalGeocodeAndIndex(job, geocodeCredentials, indexingOptions, indexIfGeocodeFails, null, coordinates);
    }

    public TxUIClient ui(MatchUISettings uiOptions) {
        return new TxUIClient(uiOptions, this);
    }

    public GetSkillsTaxonomyResponse getSkillsTaxonomy(TaxonomyFormat format) throws TxException {
        Request apiRequest = new Request.Builder().url(this._endpoints.desSkillsGetTaxonomy(format)).build();
        HttpResponse<GetSkillsTaxonomyResponse> response = this.executeRequest(apiRequest, GetSkillsTaxonomyResponse.class, this.getBodyIfDebug(apiRequest));
        return response.getData();
    }

    public GetSkillsTaxonomyResponse getSkillsTaxonomy() throws TxException {
        return this.getSkillsTaxonomy(TaxonomyFormat.json);
    }

    public GetMetadataResponse getSkillsTaxonomyMetadata() throws TxException {
        Request apiRequest = new Request.Builder().url(this._endpoints.desSkillsGetMetadata()).build();
        HttpResponse<GetMetadataResponse> response = this.executeRequest(apiRequest, GetMetadataResponse.class, this.getBodyIfDebug(apiRequest));
        return response.getData();
    }

    public AutoCompleteSkillsResponse autocompleteSkill(String prefix, List<String> languages, String outputLanguage, List<String> types, int limit) throws TxException {
        SkillsAutoCompleteRequest request = new SkillsAutoCompleteRequest();
        request.Prefix = prefix;
        request.Limit = limit;
        request.Types = types;
        request.Languages = languages;
        request.OutputLanguage = outputLanguage;
        RequestBody body = this.createJsonBody(request);
        Request apiRequest = new Request.Builder().url(this._endpoints.desSkillsAutoComplete()).post(body).build();
        HttpResponse<AutoCompleteSkillsResponse> response = this.executeRequest(apiRequest, AutoCompleteSkillsResponse.class, this.getBodyIfDebug(apiRequest));
        return response.getData();
    }

    public AutoCompleteSkillsResponse autocompleteSkill(String prefix) throws TxException {
        return this.autocompleteSkill(prefix, null, null, null, 10);
    }

    public LookupSkillCodesResponse lookupSkills(List<String> skillIds, String outputLanguage) throws TxException {
        LookupSkillsRequest request = new LookupSkillsRequest();
        request.SkillIds = skillIds;
        request.OutputLanguage = outputLanguage;
        RequestBody body = this.createJsonBody(request);
        Request apiRequest = new Request.Builder().url(this._endpoints.desSkillsLookup()).post(body).build();
        HttpResponse<LookupSkillCodesResponse> response = this.executeRequest(apiRequest, LookupSkillCodesResponse.class, this.getBodyIfDebug(apiRequest));
        return response.getData();
    }

    public LookupSkillCodesResponse lookupSkills(List<String> skillIds) throws TxException {
        return this.lookupSkills(skillIds, null);
    }

    public NormalizeSkillsResponse normalizeSkills(List<String> skills, String language, String outputLanguage) throws TxException {
        NormalizeSkillsRequest request = new NormalizeSkillsRequest();
        request.Skills = skills;
        request.Language = language;
        request.OutputLanguage = outputLanguage;
        RequestBody body = this.createJsonBody(request);
        Request apiRequest = new Request.Builder().url(this._endpoints.desSkillsNormalize()).post(body).build();
        HttpResponse<NormalizeSkillsResponse> response = this.executeRequest(apiRequest, NormalizeSkillsResponse.class, this.getBodyIfDebug(apiRequest));
        return response.getData();
    }

    public NormalizeSkillsResponse normalizeSkills(List<String> skills) throws TxException {
        return this.normalizeSkills(skills, null, null);
    }

    public ExtractSkillsResponse extractSkills(String text, String language, String outputLanguage, float threshold) throws TxException {
        ExtractSkillsRequest request = new ExtractSkillsRequest();
        request.Text = text;
        request.Language = language;
        request.OutputLanguage = outputLanguage;
        request.Threshold = threshold;
        RequestBody body = this.createJsonBody(request);
        Request apiRequest = new Request.Builder().url(this._endpoints.desSkillsExtract()).post(body).build();
        HttpResponse<ExtractSkillsResponse> response = this.executeRequest(apiRequest, ExtractSkillsResponse.class, this.getBodyIfDebug(apiRequest));
        return response.getData();
    }

    public ExtractSkillsResponse extractSkills(String text) throws TxException {
        return this.extractSkills(text, null, null, 0.5f);
    }

    public GetProfessionsTaxonomyResponse getProfessionsTaxonomy(String language, TaxonomyFormat format) throws TxException {
        Request apiRequest = new Request.Builder().url(this._endpoints.desProfessionsGetTaxonomy(format, language)).build();
        HttpResponse<GetProfessionsTaxonomyResponse> response = this.executeRequest(apiRequest, GetProfessionsTaxonomyResponse.class, this.getBodyIfDebug(apiRequest));
        return response.getData();
    }

    public GetProfessionsTaxonomyResponse getProfessionsTaxonomy() throws TxException {
        return this.getProfessionsTaxonomy(null, TaxonomyFormat.json);
    }

    public GetMetadataResponse getProfessionsTaxonomyMetadata() throws TxException {
        Request apiRequest = new Request.Builder().url(this._endpoints.desProfessionsGetMetadata()).build();
        HttpResponse<GetMetadataResponse> response = this.executeRequest(apiRequest, GetMetadataResponse.class, this.getBodyIfDebug(apiRequest));
        return response.getData();
    }

    public ProfessionsAutoCompleteResponse autocompleteProfession(String prefix, List<String> languages, String outputLanguage, int limit) throws TxException {
        AutocompleteRequest request = new AutocompleteRequest();
        request.Prefix = prefix;
        request.Limit = limit;
        request.Languages = languages;
        request.OutputLanguage = outputLanguage;
        RequestBody body = this.createJsonBody(request);
        Request apiRequest = new Request.Builder().url(this._endpoints.desProfessionsAutoComplete()).post(body).build();
        HttpResponse<ProfessionsAutoCompleteResponse> response = this.executeRequest(apiRequest, ProfessionsAutoCompleteResponse.class, this.getBodyIfDebug(apiRequest));
        return response.getData();
    }

    public ProfessionsAutoCompleteResponse autocompleteProfession(String prefix) throws TxException {
        ArrayList<String> languages = new ArrayList<String>();
        languages.add("en");
        return this.autocompleteProfession(prefix, languages, "en", 10);
    }

    public NormalizeProfessionsResponse normalizeProfessions(List<String> jobTitles, String language, String outputLanguage) throws TxException {
        NormalizeProfessionsRequest request = new NormalizeProfessionsRequest();
        request.JobTitles = jobTitles;
        request.Language = language;
        request.OutputLanguage = outputLanguage;
        RequestBody body = this.createJsonBody(request);
        Request apiRequest = new Request.Builder().url(this._endpoints.desProfessionsNormalize()).post(body).build();
        HttpResponse<NormalizeProfessionsResponse> response = this.executeRequest(apiRequest, NormalizeProfessionsResponse.class, this.getBodyIfDebug(apiRequest));
        return response.getData();
    }

    public NormalizeProfessionsResponse normalizeProfessions(List<String> jobTitles) throws TxException {
        return this.normalizeProfessions(jobTitles, null, null);
    }

    public LookupProfessionCodesResponse lookupProfessions(List<Integer> codeIds, String outputLanguage) throws TxException {
        LookupProfessionCodesRequest request = new LookupProfessionCodesRequest();
        request.CodeIds = codeIds;
        request.OutputLanguage = outputLanguage;
        RequestBody body = this.createJsonBody(request);
        Request apiRequest = new Request.Builder().url(this._endpoints.desProfessionsLookup()).post(body).build();
        HttpResponse<LookupProfessionCodesResponse> response = this.executeRequest(apiRequest, LookupProfessionCodesResponse.class, this.getBodyIfDebug(apiRequest));
        return response.getData();
    }

    public LookupProfessionCodesResponse lookupProfessions(List<Integer> codeIds) throws TxException {
        return this.lookupProfessions(codeIds, null);
    }

    public CompareProfessionsResponse compareProfessions(int profession1, int profession2, String outputLanguage) throws TxException {
        CompareProfessionsRequest request = new CompareProfessionsRequest();
        request.ProfessionACodeId = profession1;
        request.ProfessionBCodeId = profession2;
        request.OutputLanguage = outputLanguage;
        RequestBody body = this.createJsonBody(request);
        Request apiRequest = new Request.Builder().url(this._endpoints.desOntologyCompareProfessions()).post(body).build();
        HttpResponse<CompareProfessionsResponse> response = this.executeRequest(apiRequest, CompareProfessionsResponse.class, this.getBodyIfDebug(apiRequest));
        return response.getData();
    }

    public CompareSkillsToProfessionResponse compareSkillsToProfessions(int professionCodeId, String outputLanguage, List<SkillScore> skills) throws TxException {
        CompareSkillsToProfessionRequest request = new CompareSkillsToProfessionRequest();
        request.Skills = new ArrayList<SkillScore>();
        int amountOfSkills = skills.size() > 50 ? 50 : skills.size();
        for (int i = 0; i < amountOfSkills; ++i) {
            request.Skills.add(skills.get(i));
        }
        request.ProfessionCodeId = professionCodeId;
        request.OutputLanguage = outputLanguage;
        RequestBody body = this.createJsonBody(request);
        Request apiRequest = new Request.Builder().url(this._endpoints.desOntologyCompareSkillsToProfession()).post(body).build();
        HttpResponse<CompareSkillsToProfessionResponse> response = this.executeRequest(apiRequest, CompareSkillsToProfessionResponse.class, this.getBodyIfDebug(apiRequest));
        return response.getData();
    }

    public CompareSkillsToProfessionResponse compareSkillsToProfessions(ParsedResume resume, int professionCodeId, String outputLanguage, boolean weightSkillsByExperience) throws TxException {
        if (resume != null && resume.Skills != null && resume.Skills.Normalized != null && resume.Skills.Normalized.size() > 0) {
            return this.compareSkillsToProfessions(professionCodeId, outputLanguage, this.getNormalizedSkillsFromResume(resume, weightSkillsByExperience));
        }
        throw new IllegalArgumentException("The resume must be parsed with V2 skills selected, and with skills normalization enabled");
    }

    public SuggestSkillsResponse suggestSkillsFromProfessions(List<Integer> professionCodeIds, int limit, String outputLanguage) throws TxException {
        SuggestSkillsFromProfessionsRequest request = new SuggestSkillsFromProfessionsRequest();
        request.ProfessionCodeIds = professionCodeIds;
        request.Limit = limit;
        request.OutputLanguage = outputLanguage;
        RequestBody body = this.createJsonBody(request);
        Request apiRequest = new Request.Builder().url(this._endpoints.desOntologySuggestSkillsFromProfessions()).post(body).build();
        HttpResponse<SuggestSkillsResponse> response = this.executeRequest(apiRequest, SuggestSkillsResponse.class, this.getBodyIfDebug(apiRequest));
        return response.getData();
    }

    public SuggestSkillsResponse suggestSkillsFromProfessions(List<Integer> professionCodeIds, String outputLanguage) throws TxException {
        return this.suggestSkillsFromProfessions(professionCodeIds, 10, outputLanguage);
    }

    public SuggestSkillsResponse suggestSkillsFromProfessions(ParsedResume resume, String outputLanguage) throws TxException {
        if (resume != null && resume.EmploymentHistory != null && resume.EmploymentHistory.Positions != null) {
            ArrayList<Integer> normalizedProfs = new ArrayList<Integer>();
            for (Position position : resume.EmploymentHistory.Positions) {
                if (position == null || position.NormalizedProfession == null || position.NormalizedProfession.Profession == null || position.NormalizedProfession.Profession.CodeId == null) continue;
                normalizedProfs.add((Integer)position.NormalizedProfession.Profession.CodeId);
            }
            if (normalizedProfs.size() > 0) {
                return this.suggestSkillsFromProfessions(normalizedProfs, outputLanguage);
            }
        }
        throw new IllegalArgumentException("No professions were found in the resume, or the resume was parsed without professions normalization enabled");
    }

    public SuggestSkillsResponse suggestSkillsFromProfessions(ParsedResume resume) throws TxException {
        return this.suggestSkillsFromProfessions(resume, null);
    }

    public SuggestSkillsResponse suggestSkillsFromProfessions(ParsedJob job, String outputLanguage) throws TxException {
        if (job != null && job.JobTitles != null && job.JobTitles.NormalizedProfession != null && job.JobTitles.NormalizedProfession.Profession != null && job.JobTitles.NormalizedProfession.Profession.CodeId != null) {
            ArrayList<Integer> ids = new ArrayList<Integer>();
            ids.add((Integer)job.JobTitles.NormalizedProfession.Profession.CodeId);
            return this.suggestSkillsFromProfessions(ids, outputLanguage);
        }
        throw new IllegalArgumentException("No professions were found in the job, or the job was parsed without professions normalization enabled");
    }

    public SuggestSkillsResponse suggestSkillsFromProfessions(ParsedJob job) throws TxException {
        return this.suggestSkillsFromProfessions(job, null);
    }

    private List<SkillScore> getNormalizedSkillsFromResume(ParsedResume resume, boolean weightSkillsByExperience) {
        if (resume != null && resume.Skills != null && resume.Skills.Normalized != null && resume.Skills.Normalized.size() > 0) {
            ArrayList<SkillScore> skills = new ArrayList<SkillScore>();
            ResumeNormalizedSkill maxExperienceSkill = Collections.max(resume.Skills.Normalized, Comparator.comparing(s -> s.MonthsExperience != null ? (Integer)s.MonthsExperience.Value : 0));
            Integer maxExperience = Optional.ofNullable(maxExperienceSkill).map(s -> s.MonthsExperience).map(e -> (Integer)e.Value).orElse(0);
            for (int i = 0; i < resume.Skills.Normalized.size(); ++i) {
                ResumeNormalizedSkill curSkill = resume.Skills.Normalized.get(i);
                SkillScore newSkill = new SkillScore(curSkill.Id);
                int curMonthsExperience = Optional.ofNullable(curSkill.MonthsExperience).map(e -> (Integer)e.Value).orElse(0);
                newSkill.Score = weightSkillsByExperience && maxExperience > 0 ? (float)curMonthsExperience / (float)maxExperience.intValue() : 1.0f;
                skills.add(newSkill);
            }
            return skills;
        }
        throw new IllegalArgumentException("The resume must be parsed with V2 skills selected, and with skills normalization enabled.");
    }

    public SuggestProfessionsResponse suggestProfessionsFromSkills(ParsedResume resume, int limit, boolean returnMissingSkills, String outputLanguage, boolean weightSkillsByExperience) throws TxException {
        if (resume != null && resume.Skills != null && resume.Skills.Normalized != null && resume.Skills.Normalized.size() > 0) {
            return this.suggestProfessionsFromSkills(this.getNormalizedSkillsFromResume(resume, weightSkillsByExperience), limit, returnMissingSkills, outputLanguage);
        }
        throw new IllegalArgumentException("The resume must be parsed with V2 skills selected, and with skills normalization enabled.");
    }

    public SuggestProfessionsResponse suggestProfessionsFromSkills(ParsedResume resume, String outputLanguage) throws TxException {
        return this.suggestProfessionsFromSkills(resume, 10, false, outputLanguage, true);
    }

    public SuggestProfessionsResponse suggestProfessionsFromSkills(ParsedResume resume) throws TxException {
        return this.suggestProfessionsFromSkills(resume, null);
    }

    public SuggestProfessionsResponse suggestProfessionsFromSkills(ParsedJob job, int limit, boolean returnMissingSkills, String outputLanguage) throws TxException {
        if (job != null && job.Skills != null && job.Skills.Normalized != null && job.Skills.Normalized.size() > 0) {
            ArrayList<SkillScore> skills = new ArrayList<SkillScore>();
            int amountOfSkills = job.Skills.Normalized.size() > 50 ? 50 : job.Skills.Normalized.size();
            for (int i = 0; i < amountOfSkills; ++i) {
                skills.add(new SkillScore(job.Skills.Normalized.get((int)i).Id));
            }
            return this.suggestProfessionsFromSkills(skills, limit, returnMissingSkills, outputLanguage);
        }
        throw new IllegalArgumentException("The job must be parsed with V2 skills selected, and with skills normalization enabled");
    }

    public SuggestProfessionsResponse suggestProfessionsFromSkills(ParsedJob job, String outputLanguage) throws TxException {
        return this.suggestProfessionsFromSkills(job, 10, false, outputLanguage);
    }

    public SuggestProfessionsResponse suggestProfessionsFromSkills(ParsedJob job) throws TxException {
        return this.suggestProfessionsFromSkills(job, null);
    }

    public SuggestProfessionsResponse suggestProfessionsFromSkills(List<SkillScore> skills, int limit, boolean returnMissingSkills, String outputLanguage) throws TxException {
        SuggestProfessionsRequest request = new SuggestProfessionsRequest();
        request.Skills = skills;
        request.Limit = limit;
        request.ReturnMissingSkills = returnMissingSkills;
        request.OutputLanguage = outputLanguage;
        RequestBody body = this.createJsonBody(request);
        Request apiRequest = new Request.Builder().url(this._endpoints.desOntologySuggestProfessions()).post(body).build();
        HttpResponse<SuggestProfessionsResponse> response = this.executeRequest(apiRequest, SuggestProfessionsResponse.class, this.getBodyIfDebug(apiRequest));
        return response.getData();
    }

    public SuggestProfessionsResponse suggestProfessionsFromSkills(List<String> skillIds, String outputLanguage) throws TxException {
        List<SkillScore> skills = skillIds.stream().map(s -> new SkillScore((String)s)).collect(Collectors.toList());
        return this.suggestProfessionsFromSkills(skills, 10, false, outputLanguage);
    }

    public SuggestSkillsResponse suggestSkillsFromSkills(List<SkillScore> skills, int limit, String outputLanguage) throws TxException {
        SuggestSkillsFromSkillsRequest request = new SuggestSkillsFromSkillsRequest();
        request.Skills = skills;
        request.Limit = limit;
        request.OutputLanguage = outputLanguage;
        RequestBody body = this.createJsonBody(request);
        Request apiRequest = new Request.Builder().url(this._endpoints.desOntologySuggestSkillsFromSkills()).post(body).build();
        HttpResponse<SuggestSkillsResponse> response = this.executeRequest(apiRequest, SuggestSkillsResponse.class, this.getBodyIfDebug(apiRequest));
        return response.getData();
    }

    public SuggestSkillsResponse suggestSkillsFromSkills(List<String> skillIds, String outputLanguage) throws TxException {
        return this.suggestSkillsFromSkills(skillIds.stream().map(s -> new SkillScore((String)s)).collect(Collectors.toList()), 25, outputLanguage);
    }

    public SuggestSkillsResponse suggestSkillsFromSkills(ParsedJob job, int limit, String outputLanguage) throws TxException {
        if (job != null && job.Skills != null && job.Skills.Normalized != null && job.Skills.Normalized.size() > 0) {
            ArrayList<SkillScore> skills = new ArrayList<SkillScore>();
            int amountOfSkills = job.Skills.Normalized.size() > 50 ? 50 : job.Skills.Normalized.size();
            for (int i = 0; i < amountOfSkills; ++i) {
                skills.add(new SkillScore(job.Skills.Normalized.get((int)i).Id));
            }
            return this.suggestSkillsFromSkills(skills, limit, outputLanguage);
        }
        throw new IllegalArgumentException("The job must be parsed with V2 skills selected, and with skills normalization enabled");
    }

    public SuggestSkillsResponse suggestSkillsFromSkills(ParsedJob job, String outputLanguage) throws TxException {
        return this.suggestSkillsFromSkills(job, 25, outputLanguage);
    }

    public SuggestSkillsResponse suggestSkillsFromSkills(ParsedResume resume, int limit, String outputLanguage, boolean weightSkillsByExperience) throws TxException {
        return this.suggestSkillsFromSkills(this.getNormalizedSkillsFromResume(resume, weightSkillsByExperience), limit, outputLanguage);
    }

    public SuggestSkillsResponse suggestSkillsFromSkills(ParsedResume resume, String outputLanguage) throws TxException {
        return this.suggestSkillsFromSkills(resume, 25, outputLanguage, true);
    }

    public SkillsSimilarityScoreResponse skillsSimilarityScore(List<SkillScore> skillSetA, List<SkillScore> skillSetB) throws TxException {
        SkillsSimilarityScoreRequest request = new SkillsSimilarityScoreRequest();
        request.SkillsA = skillSetA;
        request.SkillsB = skillSetB;
        RequestBody body = this.createJsonBody(request);
        Request apiRequest = new Request.Builder().url(this._endpoints.desOntologySkillsSimilarityScore()).post(body).build();
        HttpResponse<SkillsSimilarityScoreResponse> response = this.executeRequest(apiRequest, SkillsSimilarityScoreResponse.class, this.getBodyIfDebug(apiRequest));
        return response.getData();
    }
}

