/*
 * Decompiled with CFR 0.152.
 */
package com.textkernel.tx.services;

import com.textkernel.tx.EnvironmentSettings;
import com.textkernel.tx.exceptions.TxException;
import com.textkernel.tx.exceptions.TxGeocodeJobException;
import com.textkernel.tx.exceptions.TxGeocodeResumeException;
import com.textkernel.tx.exceptions.TxIndexJobException;
import com.textkernel.tx.exceptions.TxIndexResumeException;
import com.textkernel.tx.http.HttpResponse;
import com.textkernel.tx.models.api.parsing.ParseJobResponse;
import com.textkernel.tx.models.api.parsing.ParseJobResponseValue;
import com.textkernel.tx.models.api.parsing.ParseRequest;
import com.textkernel.tx.models.api.parsing.ParseResumeResponse;
import com.textkernel.tx.models.api.parsing.ParseResumeResponseValue;
import com.textkernel.tx.services.ServiceBase;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;

public class ParserService
extends ServiceBase {
    public ParserService(OkHttpClient httpClient, EnvironmentSettings settings) {
        super(httpClient, settings);
    }

    public ParseResumeResponse parseResume(ParseRequest request) throws TxException {
        this.setEnvironment(request.IndexingOptions);
        RequestBody body = this.createJsonBody(request);
        Request apiRequest = new Request.Builder().url(this._endpoints.parseResume()).post(body).build();
        HttpResponse<ParseResumeResponse> response = this.executeRequest(apiRequest, ParseResumeResponse.class, ParserService.getBodyIfDebug(apiRequest));
        if (((ParseResumeResponseValue)response.getData().Value).ParsingResponse != null && !((ParseResumeResponseValue)response.getData().Value).ParsingResponse.isSuccess()) {
            throw new TxException(ParserService.getBodyIfDebug(apiRequest), response.getResponse(), ((ParseResumeResponseValue)response.getData().Value).ParsingResponse, response.getData().Info.TransactionId);
        }
        if (((ParseResumeResponseValue)response.getData().Value).GeocodeResponse != null && !((ParseResumeResponseValue)response.getData().Value).GeocodeResponse.isSuccess()) {
            throw new TxGeocodeResumeException(response.getResponse(), ((ParseResumeResponseValue)response.getData().Value).GeocodeResponse, response.getData().Info.TransactionId, response.getData());
        }
        if (((ParseResumeResponseValue)response.getData().Value).IndexingResponse != null && !((ParseResumeResponseValue)response.getData().Value).IndexingResponse.isSuccess()) {
            throw new TxIndexResumeException(response.getResponse(), ((ParseResumeResponseValue)response.getData().Value).IndexingResponse, response.getData().Info.TransactionId, response.getData());
        }
        return response.getData();
    }

    public ParseJobResponse parseJob(ParseRequest request) throws TxException {
        this.setEnvironment(request.IndexingOptions);
        RequestBody body = this.createJsonBody(request);
        Request apiRequest = new Request.Builder().url(this._endpoints.parseJob()).post(body).build();
        HttpResponse<ParseJobResponse> response = this.executeRequest(apiRequest, ParseJobResponse.class, ParserService.getBodyIfDebug(apiRequest));
        if (((ParseJobResponseValue)response.getData().Value).ParsingResponse != null && !((ParseJobResponseValue)response.getData().Value).ParsingResponse.isSuccess()) {
            throw new TxException(ParserService.getBodyIfDebug(apiRequest), response.getResponse(), ((ParseJobResponseValue)response.getData().Value).ParsingResponse, response.getData().Info.TransactionId);
        }
        if (((ParseJobResponseValue)response.getData().Value).GeocodeResponse != null && !((ParseJobResponseValue)response.getData().Value).GeocodeResponse.isSuccess()) {
            throw new TxGeocodeJobException(response.getResponse(), ((ParseJobResponseValue)response.getData().Value).GeocodeResponse, response.getData().Info.TransactionId, response.getData());
        }
        if (((ParseJobResponseValue)response.getData().Value).IndexingResponse != null && !((ParseJobResponseValue)response.getData().Value).IndexingResponse.isSuccess()) {
            throw new TxIndexJobException(response.getResponse(), ((ParseJobResponseValue)response.getData().Value).IndexingResponse, response.getData().Info.TransactionId, response.getData());
        }
        return response.getData();
    }
}

