/*
 * Decompiled with CFR 0.152.
 */
package com.textkernel.tx.services;

import com.textkernel.tx.EnvironmentSettings;
import com.textkernel.tx.exceptions.TxException;
import com.textkernel.tx.http.HttpResponse;
import com.textkernel.tx.models.api.dataenrichment.AutocompleteRequest;
import com.textkernel.tx.models.api.dataenrichment.GetMetadataResponse;
import com.textkernel.tx.models.api.dataenrichment.TaxonomyFormat;
import com.textkernel.tx.models.api.dataenrichment.ontology.request.CompareProfessionsRequest;
import com.textkernel.tx.models.api.dataenrichment.ontology.request.CompareSkillsToProfessionRequest;
import com.textkernel.tx.models.api.dataenrichment.ontology.request.SkillsSimilarityScoreRequest;
import com.textkernel.tx.models.api.dataenrichment.ontology.request.SuggestProfessionsRequest;
import com.textkernel.tx.models.api.dataenrichment.ontology.request.SuggestSkillsFromProfessionsRequest;
import com.textkernel.tx.models.api.dataenrichment.ontology.request.SuggestSkillsFromSkillsRequest;
import com.textkernel.tx.models.api.dataenrichment.ontology.response.CompareProfessionsResponse;
import com.textkernel.tx.models.api.dataenrichment.ontology.response.CompareSkillsToProfessionResponse;
import com.textkernel.tx.models.api.dataenrichment.ontology.response.SkillScore;
import com.textkernel.tx.models.api.dataenrichment.ontology.response.SkillsSimilarityScoreResponse;
import com.textkernel.tx.models.api.dataenrichment.ontology.response.SuggestProfessionsResponse;
import com.textkernel.tx.models.api.dataenrichment.ontology.response.SuggestSkillsResponse;
import com.textkernel.tx.models.api.dataenrichment.professions.request.LookupProfessionCodesRequest;
import com.textkernel.tx.models.api.dataenrichment.professions.request.NormalizeProfessionsRequest;
import com.textkernel.tx.models.api.dataenrichment.professions.response.GetProfessionsTaxonomyResponse;
import com.textkernel.tx.models.api.dataenrichment.professions.response.LookupProfessionCodesResponse;
import com.textkernel.tx.models.api.dataenrichment.professions.response.NormalizeProfessionsResponse;
import com.textkernel.tx.models.api.dataenrichment.professions.response.ProfessionsAutoCompleteResponse;
import com.textkernel.tx.models.api.dataenrichment.skills.request.ExtractSkillsRequest;
import com.textkernel.tx.models.api.dataenrichment.skills.request.LookupSkillsRequest;
import com.textkernel.tx.models.api.dataenrichment.skills.request.NormalizeSkillsRequest;
import com.textkernel.tx.models.api.dataenrichment.skills.request.SkillsAutoCompleteRequest;
import com.textkernel.tx.models.api.dataenrichment.skills.response.AutoCompleteSkillsResponse;
import com.textkernel.tx.models.api.dataenrichment.skills.response.ExtractSkillsResponse;
import com.textkernel.tx.models.api.dataenrichment.skills.response.GetSkillsTaxonomyResponse;
import com.textkernel.tx.models.api.dataenrichment.skills.response.LookupSkillCodesResponse;
import com.textkernel.tx.models.api.dataenrichment.skills.response.NormalizeSkillsResponse;
import com.textkernel.tx.models.api.jobdescription.GenerateJobRequest;
import com.textkernel.tx.models.api.jobdescription.GenerateJobResponse;
import com.textkernel.tx.models.api.jobdescription.SuggestSkillsFromJobTitleRequest;
import com.textkernel.tx.models.api.jobdescription.SuggestSkillsFromJobTitleResponse;
import com.textkernel.tx.models.job.ParsedJob;
import com.textkernel.tx.models.resume.ParsedResume;
import com.textkernel.tx.models.resume.employment.Position;
import com.textkernel.tx.models.resume.skills.ResumeNormalizedSkill;
import com.textkernel.tx.services.ServiceBase;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;

public class SkillsIntelligenceService
extends ServiceBase {
    public SkillsIntelligenceService(OkHttpClient httpClient, EnvironmentSettings settings) {
        super(httpClient, settings);
    }

    public GetSkillsTaxonomyResponse getSkillsTaxonomy(TaxonomyFormat format) throws TxException {
        Request apiRequest = new Request.Builder().url(this._endpoints.desSkillsGetTaxonomy(format, this._settings.SkillsIntelligenceIncludeCertifications)).build();
        HttpResponse<GetSkillsTaxonomyResponse> response = this.executeRequest(apiRequest, GetSkillsTaxonomyResponse.class, SkillsIntelligenceService.getBodyIfDebug(apiRequest));
        return response.getData();
    }

    public GetSkillsTaxonomyResponse getSkillsTaxonomy() throws TxException {
        return this.getSkillsTaxonomy(TaxonomyFormat.json);
    }

    public GetMetadataResponse getSkillsTaxonomyMetadata() throws TxException {
        Request apiRequest = new Request.Builder().url(this._endpoints.desSkillsGetMetadata(this._settings.SkillsIntelligenceIncludeCertifications)).build();
        HttpResponse<GetMetadataResponse> response = this.executeRequest(apiRequest, GetMetadataResponse.class, SkillsIntelligenceService.getBodyIfDebug(apiRequest));
        return response.getData();
    }

    public AutoCompleteSkillsResponse autocompleteSkill(String prefix, List<String> languages, String outputLanguage, List<String> types, int limit) throws TxException {
        SkillsAutoCompleteRequest request = new SkillsAutoCompleteRequest();
        request.Prefix = prefix;
        request.Limit = limit;
        request.Types = types;
        request.Languages = languages;
        request.OutputLanguage = outputLanguage;
        RequestBody body = this.createJsonBody(request);
        Request apiRequest = new Request.Builder().url(this._endpoints.desSkillsAutoComplete(this._settings.SkillsIntelligenceIncludeCertifications)).post(body).build();
        HttpResponse<AutoCompleteSkillsResponse> response = this.executeRequest(apiRequest, AutoCompleteSkillsResponse.class, SkillsIntelligenceService.getBodyIfDebug(apiRequest));
        return response.getData();
    }

    public AutoCompleteSkillsResponse autocompleteSkill(String prefix) throws TxException {
        return this.autocompleteSkill(prefix, null, null, null, 10);
    }

    public LookupSkillCodesResponse lookupSkills(List<String> skillIds, String outputLanguage) throws TxException {
        LookupSkillsRequest request = new LookupSkillsRequest();
        request.SkillIds = skillIds;
        request.OutputLanguage = outputLanguage;
        RequestBody body = this.createJsonBody(request);
        Request apiRequest = new Request.Builder().url(this._endpoints.desSkillsLookup(this._settings.SkillsIntelligenceIncludeCertifications)).post(body).build();
        HttpResponse<LookupSkillCodesResponse> response = this.executeRequest(apiRequest, LookupSkillCodesResponse.class, SkillsIntelligenceService.getBodyIfDebug(apiRequest));
        return response.getData();
    }

    public LookupSkillCodesResponse lookupSkills(List<String> skillIds) throws TxException {
        return this.lookupSkills(skillIds, null);
    }

    public NormalizeSkillsResponse normalizeSkills(List<String> skills, String language, String outputLanguage) throws TxException {
        NormalizeSkillsRequest request = new NormalizeSkillsRequest();
        request.Skills = skills;
        request.Language = language;
        request.OutputLanguage = outputLanguage;
        RequestBody body = this.createJsonBody(request);
        Request apiRequest = new Request.Builder().url(this._endpoints.desSkillsNormalize(this._settings.SkillsIntelligenceIncludeCertifications)).post(body).build();
        HttpResponse<NormalizeSkillsResponse> response = this.executeRequest(apiRequest, NormalizeSkillsResponse.class, SkillsIntelligenceService.getBodyIfDebug(apiRequest));
        return response.getData();
    }

    public NormalizeSkillsResponse normalizeSkills(List<String> skills) throws TxException {
        return this.normalizeSkills(skills, null, null);
    }

    public ExtractSkillsResponse extractSkills(String text, String language, String outputLanguage, float threshold) throws TxException {
        ExtractSkillsRequest request = new ExtractSkillsRequest();
        request.Text = text;
        request.Language = language;
        request.OutputLanguage = outputLanguage;
        request.Threshold = threshold;
        RequestBody body = this.createJsonBody(request);
        Request apiRequest = new Request.Builder().url(this._endpoints.desSkillsExtract(this._settings.SkillsIntelligenceIncludeCertifications)).post(body).build();
        HttpResponse<ExtractSkillsResponse> response = this.executeRequest(apiRequest, ExtractSkillsResponse.class, SkillsIntelligenceService.getBodyIfDebug(apiRequest));
        return response.getData();
    }

    public ExtractSkillsResponse extractSkills(String text) throws TxException {
        return this.extractSkills(text, null, null, 0.5f);
    }

    public GetProfessionsTaxonomyResponse getProfessionsTaxonomy(String language, TaxonomyFormat format) throws TxException {
        Request apiRequest = new Request.Builder().url(this._endpoints.desProfessionsGetTaxonomy(format, language)).build();
        HttpResponse<GetProfessionsTaxonomyResponse> response = this.executeRequest(apiRequest, GetProfessionsTaxonomyResponse.class, SkillsIntelligenceService.getBodyIfDebug(apiRequest));
        return response.getData();
    }

    public GetProfessionsTaxonomyResponse getProfessionsTaxonomy() throws TxException {
        return this.getProfessionsTaxonomy(null, TaxonomyFormat.json);
    }

    public GetMetadataResponse getProfessionsTaxonomyMetadata() throws TxException {
        Request apiRequest = new Request.Builder().url(this._endpoints.desProfessionsGetMetadata()).build();
        HttpResponse<GetMetadataResponse> response = this.executeRequest(apiRequest, GetMetadataResponse.class, SkillsIntelligenceService.getBodyIfDebug(apiRequest));
        return response.getData();
    }

    public ProfessionsAutoCompleteResponse autocompleteProfession(String prefix, List<String> languages, String outputLanguage, int limit) throws TxException {
        AutocompleteRequest request = new AutocompleteRequest();
        request.Prefix = prefix;
        request.Limit = limit;
        request.Languages = languages;
        request.OutputLanguage = outputLanguage;
        RequestBody body = this.createJsonBody(request);
        Request apiRequest = new Request.Builder().url(this._endpoints.desProfessionsAutoComplete()).post(body).build();
        HttpResponse<ProfessionsAutoCompleteResponse> response = this.executeRequest(apiRequest, ProfessionsAutoCompleteResponse.class, SkillsIntelligenceService.getBodyIfDebug(apiRequest));
        return response.getData();
    }

    public ProfessionsAutoCompleteResponse autocompleteProfession(String prefix) throws TxException {
        ArrayList<String> languages = new ArrayList<String>();
        languages.add("en");
        return this.autocompleteProfession(prefix, languages, "en", 10);
    }

    public NormalizeProfessionsResponse normalizeProfessions(List<String> jobTitles, String language, String outputLanguage) throws TxException {
        NormalizeProfessionsRequest request = new NormalizeProfessionsRequest();
        request.JobTitles = jobTitles;
        request.Language = language;
        request.OutputLanguage = outputLanguage;
        RequestBody body = this.createJsonBody(request);
        Request apiRequest = new Request.Builder().url(this._endpoints.desProfessionsNormalize()).post(body).build();
        HttpResponse<NormalizeProfessionsResponse> response = this.executeRequest(apiRequest, NormalizeProfessionsResponse.class, SkillsIntelligenceService.getBodyIfDebug(apiRequest));
        return response.getData();
    }

    public NormalizeProfessionsResponse normalizeProfessions(List<String> jobTitles) throws TxException {
        return this.normalizeProfessions(jobTitles, null, null);
    }

    public LookupProfessionCodesResponse lookupProfessions(List<Integer> codeIds, String outputLanguage) throws TxException {
        LookupProfessionCodesRequest request = new LookupProfessionCodesRequest();
        request.CodeIds = codeIds;
        request.OutputLanguage = outputLanguage;
        RequestBody body = this.createJsonBody(request);
        Request apiRequest = new Request.Builder().url(this._endpoints.desProfessionsLookup()).post(body).build();
        HttpResponse<LookupProfessionCodesResponse> response = this.executeRequest(apiRequest, LookupProfessionCodesResponse.class, SkillsIntelligenceService.getBodyIfDebug(apiRequest));
        return response.getData();
    }

    public LookupProfessionCodesResponse lookupProfessions(List<Integer> codeIds) throws TxException {
        return this.lookupProfessions(codeIds, null);
    }

    public CompareProfessionsResponse compareProfessions(int profession1, int profession2, String outputLanguage) throws TxException {
        CompareProfessionsRequest request = new CompareProfessionsRequest();
        request.ProfessionACodeId = profession1;
        request.ProfessionBCodeId = profession2;
        request.OutputLanguage = outputLanguage;
        RequestBody body = this.createJsonBody(request);
        Request apiRequest = new Request.Builder().url(this._endpoints.desOntologyCompareProfessions(this._settings.SkillsIntelligenceIncludeCertifications)).post(body).build();
        HttpResponse<CompareProfessionsResponse> response = this.executeRequest(apiRequest, CompareProfessionsResponse.class, SkillsIntelligenceService.getBodyIfDebug(apiRequest));
        return response.getData();
    }

    public CompareSkillsToProfessionResponse compareSkillsToProfessions(int professionCodeId, String outputLanguage, List<SkillScore> skills) throws TxException {
        CompareSkillsToProfessionRequest request = new CompareSkillsToProfessionRequest();
        request.Skills = new ArrayList<SkillScore>();
        int amountOfSkills = skills.size() > 50 ? 50 : skills.size();
        for (int i = 0; i < amountOfSkills; ++i) {
            request.Skills.add(skills.get(i));
        }
        request.ProfessionCodeId = professionCodeId;
        request.OutputLanguage = outputLanguage;
        RequestBody body = this.createJsonBody(request);
        Request apiRequest = new Request.Builder().url(this._endpoints.desOntologyCompareSkillsToProfession(this._settings.SkillsIntelligenceIncludeCertifications)).post(body).build();
        HttpResponse<CompareSkillsToProfessionResponse> response = this.executeRequest(apiRequest, CompareSkillsToProfessionResponse.class, SkillsIntelligenceService.getBodyIfDebug(apiRequest));
        return response.getData();
    }

    public CompareSkillsToProfessionResponse compareSkillsToProfessions(ParsedResume resume, int professionCodeId, String outputLanguage, boolean weightSkillsByExperience) throws TxException {
        if (resume != null && resume.Skills != null && resume.Skills.Normalized != null && resume.Skills.Normalized.size() > 0) {
            return this.compareSkillsToProfessions(professionCodeId, outputLanguage, this.getNormalizedSkillsFromResume(resume, weightSkillsByExperience));
        }
        throw new IllegalArgumentException("The resume must be parsed with V2 skills selected, and with skills normalization enabled");
    }

    public SuggestSkillsResponse suggestSkillsFromProfessions(List<Integer> professionCodeIds, int limit, String outputLanguage) throws TxException {
        SuggestSkillsFromProfessionsRequest request = new SuggestSkillsFromProfessionsRequest();
        request.ProfessionCodeIds = professionCodeIds;
        request.Limit = limit;
        request.OutputLanguage = outputLanguage;
        RequestBody body = this.createJsonBody(request);
        Request apiRequest = new Request.Builder().url(this._endpoints.desOntologySuggestSkillsFromProfessions(this._settings.SkillsIntelligenceIncludeCertifications)).post(body).build();
        HttpResponse<SuggestSkillsResponse> response = this.executeRequest(apiRequest, SuggestSkillsResponse.class, SkillsIntelligenceService.getBodyIfDebug(apiRequest));
        return response.getData();
    }

    public SuggestSkillsResponse suggestSkillsFromProfessions(List<Integer> professionCodeIds, String outputLanguage) throws TxException {
        return this.suggestSkillsFromProfessions(professionCodeIds, 10, outputLanguage);
    }

    public SuggestSkillsResponse suggestSkillsFromProfessions(ParsedResume resume, String outputLanguage) throws TxException {
        if (resume != null && resume.EmploymentHistory != null && resume.EmploymentHistory.Positions != null) {
            ArrayList<Integer> normalizedProfs = new ArrayList<Integer>();
            for (Position position : resume.EmploymentHistory.Positions) {
                if (position == null || position.NormalizedProfession == null || position.NormalizedProfession.Profession == null || position.NormalizedProfession.Profession.CodeId == null) continue;
                normalizedProfs.add((Integer)position.NormalizedProfession.Profession.CodeId);
            }
            if (normalizedProfs.size() > 0) {
                return this.suggestSkillsFromProfessions(normalizedProfs, outputLanguage);
            }
        }
        throw new IllegalArgumentException("No professions were found in the resume, or the resume was parsed without professions normalization enabled");
    }

    public SuggestSkillsResponse suggestSkillsFromProfessions(ParsedResume resume) throws TxException {
        return this.suggestSkillsFromProfessions(resume, null);
    }

    public SuggestSkillsResponse suggestSkillsFromProfessions(ParsedJob job, String outputLanguage) throws TxException {
        if (job != null && job.JobTitles != null && job.JobTitles.NormalizedProfession != null && job.JobTitles.NormalizedProfession.Profession != null && job.JobTitles.NormalizedProfession.Profession.CodeId != null) {
            ArrayList<Integer> ids = new ArrayList<Integer>();
            ids.add((Integer)job.JobTitles.NormalizedProfession.Profession.CodeId);
            return this.suggestSkillsFromProfessions(ids, outputLanguage);
        }
        throw new IllegalArgumentException("No professions were found in the job, or the job was parsed without professions normalization enabled");
    }

    public SuggestSkillsResponse suggestSkillsFromProfessions(ParsedJob job) throws TxException {
        return this.suggestSkillsFromProfessions(job, null);
    }

    private List<SkillScore> getNormalizedSkillsFromResume(ParsedResume resume, boolean weightSkillsByExperience) {
        if (resume != null && resume.Skills != null && resume.Skills.Normalized != null && resume.Skills.Normalized.size() > 0) {
            ArrayList<SkillScore> skills = new ArrayList<SkillScore>();
            ResumeNormalizedSkill maxExperienceSkill = Collections.max(resume.Skills.Normalized, Comparator.comparing(s -> s.MonthsExperience != null ? (Integer)s.MonthsExperience.Value : 0));
            Integer maxExperience = Optional.ofNullable(maxExperienceSkill).map(s -> s.MonthsExperience).map(e -> (Integer)e.Value).orElse(0);
            for (int i = 0; i < resume.Skills.Normalized.size(); ++i) {
                ResumeNormalizedSkill curSkill = resume.Skills.Normalized.get(i);
                SkillScore newSkill = new SkillScore(curSkill.Id);
                int curMonthsExperience = Optional.ofNullable(curSkill.MonthsExperience).map(e -> (Integer)e.Value).orElse(0);
                newSkill.Score = weightSkillsByExperience && maxExperience > 0 ? (float)curMonthsExperience / (float)maxExperience.intValue() : 1.0f;
                skills.add(newSkill);
            }
            return skills;
        }
        throw new IllegalArgumentException("The resume must be parsed with V2 skills selected, and with skills normalization enabled.");
    }

    public SuggestProfessionsResponse suggestProfessionsFromSkills(ParsedResume resume, int limit, boolean returnMissingSkills, String outputLanguage, boolean weightSkillsByExperience) throws TxException {
        if (resume != null && resume.Skills != null && resume.Skills.Normalized != null && resume.Skills.Normalized.size() > 0) {
            return this.suggestProfessionsFromSkills(this.getNormalizedSkillsFromResume(resume, weightSkillsByExperience), limit, returnMissingSkills, outputLanguage);
        }
        throw new IllegalArgumentException("The resume must be parsed with V2 skills selected, and with skills normalization enabled.");
    }

    public SuggestProfessionsResponse suggestProfessionsFromSkills(ParsedResume resume, String outputLanguage) throws TxException {
        return this.suggestProfessionsFromSkills(resume, 10, false, outputLanguage, true);
    }

    public SuggestProfessionsResponse suggestProfessionsFromSkills(ParsedResume resume) throws TxException {
        return this.suggestProfessionsFromSkills(resume, null);
    }

    public SuggestProfessionsResponse suggestProfessionsFromSkills(ParsedJob job, int limit, boolean returnMissingSkills, String outputLanguage) throws TxException {
        if (job != null && job.Skills != null && job.Skills.Normalized != null && job.Skills.Normalized.size() > 0) {
            ArrayList<SkillScore> skills = new ArrayList<SkillScore>();
            int amountOfSkills = job.Skills.Normalized.size() > 50 ? 50 : job.Skills.Normalized.size();
            for (int i = 0; i < amountOfSkills; ++i) {
                skills.add(new SkillScore(job.Skills.Normalized.get((int)i).Id));
            }
            return this.suggestProfessionsFromSkills(skills, limit, returnMissingSkills, outputLanguage);
        }
        throw new IllegalArgumentException("The job must be parsed with V2 skills selected, and with skills normalization enabled");
    }

    public SuggestProfessionsResponse suggestProfessionsFromSkills(ParsedJob job, String outputLanguage) throws TxException {
        return this.suggestProfessionsFromSkills(job, 10, false, outputLanguage);
    }

    public SuggestProfessionsResponse suggestProfessionsFromSkills(ParsedJob job) throws TxException {
        return this.suggestProfessionsFromSkills(job, null);
    }

    public SuggestProfessionsResponse suggestProfessionsFromSkills(List<SkillScore> skills, int limit, boolean returnMissingSkills, String outputLanguage) throws TxException {
        SuggestProfessionsRequest request = new SuggestProfessionsRequest();
        request.Skills = skills;
        request.Limit = limit;
        request.ReturnMissingSkills = returnMissingSkills;
        request.OutputLanguage = outputLanguage;
        RequestBody body = this.createJsonBody(request);
        Request apiRequest = new Request.Builder().url(this._endpoints.desOntologySuggestProfessions(this._settings.SkillsIntelligenceIncludeCertifications)).post(body).build();
        HttpResponse<SuggestProfessionsResponse> response = this.executeRequest(apiRequest, SuggestProfessionsResponse.class, SkillsIntelligenceService.getBodyIfDebug(apiRequest));
        return response.getData();
    }

    public SuggestProfessionsResponse suggestProfessionsFromSkills(List<String> skillIds, String outputLanguage) throws TxException {
        List<SkillScore> skills = skillIds.stream().map(s -> new SkillScore((String)s)).collect(Collectors.toList());
        return this.suggestProfessionsFromSkills(skills, 10, false, outputLanguage);
    }

    public SuggestSkillsResponse suggestSkillsFromSkills(List<SkillScore> skills, int limit, String outputLanguage) throws TxException {
        SuggestSkillsFromSkillsRequest request = new SuggestSkillsFromSkillsRequest();
        request.Skills = skills;
        request.Limit = limit;
        request.OutputLanguage = outputLanguage;
        RequestBody body = this.createJsonBody(request);
        Request apiRequest = new Request.Builder().url(this._endpoints.desOntologySuggestSkillsFromSkills(this._settings.SkillsIntelligenceIncludeCertifications)).post(body).build();
        HttpResponse<SuggestSkillsResponse> response = this.executeRequest(apiRequest, SuggestSkillsResponse.class, SkillsIntelligenceService.getBodyIfDebug(apiRequest));
        return response.getData();
    }

    public SuggestSkillsResponse suggestSkillsFromSkills(List<String> skillIds, String outputLanguage) throws TxException {
        return this.suggestSkillsFromSkills(skillIds.stream().map(s -> new SkillScore((String)s)).collect(Collectors.toList()), 25, outputLanguage);
    }

    public SuggestSkillsResponse suggestSkillsFromSkills(ParsedJob job, int limit, String outputLanguage) throws TxException {
        if (job != null && job.Skills != null && job.Skills.Normalized != null && job.Skills.Normalized.size() > 0) {
            ArrayList<SkillScore> skills = new ArrayList<SkillScore>();
            int amountOfSkills = job.Skills.Normalized.size() > 50 ? 50 : job.Skills.Normalized.size();
            for (int i = 0; i < amountOfSkills; ++i) {
                skills.add(new SkillScore(job.Skills.Normalized.get((int)i).Id));
            }
            return this.suggestSkillsFromSkills(skills, limit, outputLanguage);
        }
        throw new IllegalArgumentException("The job must be parsed with V2 skills selected, and with skills normalization enabled");
    }

    public SuggestSkillsResponse suggestSkillsFromSkills(ParsedJob job, String outputLanguage) throws TxException {
        return this.suggestSkillsFromSkills(job, 25, outputLanguage);
    }

    public SuggestSkillsResponse suggestSkillsFromSkills(ParsedResume resume, int limit, String outputLanguage, boolean weightSkillsByExperience) throws TxException {
        return this.suggestSkillsFromSkills(this.getNormalizedSkillsFromResume(resume, weightSkillsByExperience), limit, outputLanguage);
    }

    public SuggestSkillsResponse suggestSkillsFromSkills(ParsedResume resume, String outputLanguage) throws TxException {
        return this.suggestSkillsFromSkills(resume, 25, outputLanguage, true);
    }

    public SkillsSimilarityScoreResponse skillsSimilarityScore(List<SkillScore> skillSetA, List<SkillScore> skillSetB) throws TxException {
        SkillsSimilarityScoreRequest request = new SkillsSimilarityScoreRequest();
        request.SkillsA = skillSetA;
        request.SkillsB = skillSetB;
        RequestBody body = this.createJsonBody(request);
        Request apiRequest = new Request.Builder().url(this._endpoints.desOntologySkillsSimilarityScore(this._settings.SkillsIntelligenceIncludeCertifications)).post(body).build();
        HttpResponse<SkillsSimilarityScoreResponse> response = this.executeRequest(apiRequest, SkillsSimilarityScoreResponse.class, SkillsIntelligenceService.getBodyIfDebug(apiRequest));
        return response.getData();
    }

    public GenerateJobResponse generateJobDescription(GenerateJobRequest request) throws TxException {
        RequestBody body = this.createJsonBody(request);
        Request apiRequest = new Request.Builder().url(this._endpoints.jobDescriptionGenerate()).post(body).build();
        HttpResponse<GenerateJobResponse> response = this.executeRequest(apiRequest, GenerateJobResponse.class, SkillsIntelligenceService.getBodyIfDebug(apiRequest));
        return response.getData();
    }

    public SuggestSkillsFromJobTitleResponse suggestSkillsFromJobTitle(String jobTitle, String language, Integer limit) throws TxException {
        SuggestSkillsFromJobTitleRequest request = new SuggestSkillsFromJobTitleRequest();
        request.JobTitle = jobTitle;
        request.Language = language;
        request.Limit = limit;
        RequestBody body = this.createJsonBody(request);
        Request apiRequest = new Request.Builder().url(this._endpoints.jobDescriptionSuggestSkills()).post(body).build();
        HttpResponse<SuggestSkillsFromJobTitleResponse> response = this.executeRequest(apiRequest, SuggestSkillsFromJobTitleResponse.class, SkillsIntelligenceService.getBodyIfDebug(apiRequest));
        return response.getData();
    }

    public SuggestSkillsFromJobTitleResponse suggestSkillsFromJobTitle(String jobTitle) throws TxException {
        return this.suggestSkillsFromJobTitle(jobTitle, "en", null);
    }
}

