/*
 * Decompiled with CFR 0.152.
 */
package haxe.io;

import haxe.io.BytesInput;
import haxe.io.Error;
import haxe.io.FPHelper;
import haxe.lang.Closure;
import haxe.lang.EmptyObject;
import haxe.lang.Exceptions;
import haxe.lang.HaxeException;
import haxe.lang.HxObject;
import haxe.lang.Runtime;
import haxe.lang.StringExt;
import haxe.root.Array;
import haxe.root.StringBuf;

public class Bytes
extends HxObject {
    public int length;
    public byte[] b;

    public Bytes(EmptyObject emptyObject) {
    }

    public Bytes(int n, byte[] byArray) {
        Bytes.__hx_ctor_haxe_io_Bytes(this, n, byArray);
    }

    public static void __hx_ctor_haxe_io_Bytes(Bytes bytes, int n, byte[] byArray) {
        bytes.length = n;
        bytes.b = byArray;
    }

    public static Bytes alloc(int n) {
        return new Bytes(n, new byte[n]);
    }

    public static Bytes ofString(String string) {
        try {
            byte[] byArray = string.getBytes(Runtime.toString("UTF-8"));
            return new Bytes(byArray.length, byArray);
        }
        catch (Throwable throwable) {
            Exceptions.setException(throwable);
            Object object = throwable;
            if (object instanceof HaxeException) {
                object = ((HaxeException)throwable).obj;
            }
            Throwable throwable2 = object;
            throw HaxeException.wrap(throwable2);
        }
    }

    public static Bytes ofData(byte[] byArray) {
        return new Bytes(byArray.length, byArray);
    }

    public static int fastGet(byte[] byArray, int n) {
        return byArray[n] & 0xFF;
    }

    public static Object __hx_createEmpty() {
        return new Bytes(EmptyObject.EMPTY);
    }

    public static Object __hx_create(Array array) {
        return new Bytes(Runtime.toInt(array.__get(0)), (byte[])array.__get(1));
    }

    public final int get(int n) {
        return this.b[n] & 0xFF;
    }

    public final void set(int n, int n2) {
        this.b[n] = (byte)n2;
    }

    public void blit(int n, Bytes bytes, int n2, int n3) {
        if (n < 0 || n2 < 0 || n3 < 0 || n + n3 > this.length || n2 + n3 > bytes.length) {
            throw HaxeException.wrap(Error.OutsideBounds);
        }
        System.arraycopy(bytes.b, n2, this.b, n, n3);
    }

    public void fill(int n, int n2, int n3) {
        int n4 = 0;
        while (n4 < n2) {
            int n5 = n4++;
            int n6 = n++;
            this.b[n6] = (byte)n3;
        }
    }

    public Bytes sub(int n, int n2) {
        if (n < 0 || n2 < 0 || n + n2 > this.length) {
            throw HaxeException.wrap(Error.OutsideBounds);
        }
        byte[] byArray = new byte[n2];
        System.arraycopy(this.b, n, byArray, 0, n2);
        return new Bytes(n2, byArray);
    }

    public int compare(Bytes bytes) {
        byte[] byArray = this.b;
        byte[] byArray2 = bytes.b;
        int n = 0;
        n = this.length < bytes.length ? this.length : bytes.length;
        int n2 = 0;
        while (n2 < n) {
            int n3;
            if (byArray[n3 = n2++] == byArray2[n3]) continue;
            return byArray[n3] - byArray2[n3];
        }
        return this.length - bytes.length;
    }

    public double getDouble(int n) {
        int n2 = 0;
        int n3 = n + 4;
        n2 = this.b[n3] & 0xFF | (this.b[n3 + 1] & 0xFF) << 8 | (this.b[n3 + 2] & 0xFF) << 16 | (this.b[n3 + 3] & 0xFF) << 24;
        return FPHelper.i64ToDouble(this.b[n] & 0xFF | (this.b[n + 1] & 0xFF) << 8 | (this.b[n + 2] & 0xFF) << 16 | (this.b[n + 3] & 0xFF) << 24, n2);
    }

    public double getFloat(int n) {
        BytesInput bytesInput = new BytesInput(this, n, 4);
        return FPHelper.i32ToFloat(bytesInput.readInt32());
    }

    public void setDouble(int n, double d) {
        long l = FPHelper.doubleToI64(d);
        int n2 = Runtime.toInt(l);
        this.b[n] = (byte)n2;
        this.b[n + 1] = (byte)(n2 >> 8);
        this.b[n + 2] = (byte)(n2 >> 16);
        this.b[n + 3] = (byte)(n2 >>> 24);
        n2 = n + 4;
        int n3 = Runtime.toInt(l >> 32);
        this.b[n2] = (byte)n3;
        this.b[n2 + 1] = (byte)(n3 >> 8);
        this.b[n2 + 2] = (byte)(n3 >> 16);
        this.b[n2 + 3] = (byte)(n3 >>> 24);
    }

    public void setFloat(int n, double d) {
        int n2 = FPHelper.floatToI32(d);
        this.b[n] = (byte)n2;
        this.b[n + 1] = (byte)(n2 >> 8);
        this.b[n + 2] = (byte)(n2 >> 16);
        this.b[n + 3] = (byte)(n2 >>> 24);
    }

    public final int getUInt16(int n) {
        return this.b[n] & 0xFF | (this.b[n + 1] & 0xFF) << 8;
    }

    public final void setUInt16(int n, int n2) {
        this.b[n] = (byte)n2;
        this.b[n + 1] = (byte)(n2 >> 8);
    }

    public final int getInt32(int n) {
        return this.b[n] & 0xFF | (this.b[n + 1] & 0xFF) << 8 | (this.b[n + 2] & 0xFF) << 16 | (this.b[n + 3] & 0xFF) << 24;
    }

    public final long getInt64(int n) {
        long l = 0L;
        int n2 = 0;
        int n3 = n + 4;
        n2 = this.b[n3] & 0xFF | (this.b[n3 + 1] & 0xFF) << 8 | (this.b[n3 + 2] & 0xFF) << 16 | (this.b[n3 + 3] & 0xFF) << 24;
        long l2 = (long)(this.b[n] & 0xFF | (this.b[n + 1] & 0xFF) << 8 | (this.b[n + 2] & 0xFF) << 16 | (this.b[n + 3] & 0xFF) << 24) & 0xFFFFFFFFL;
        l = (long)n2 << 32 | l2;
        return l;
    }

    public final void setInt32(int n, int n2) {
        this.b[n] = (byte)n2;
        this.b[n + 1] = (byte)(n2 >> 8);
        this.b[n + 2] = (byte)(n2 >> 16);
        this.b[n + 3] = (byte)(n2 >>> 24);
    }

    public final void setInt64(int n, long l) {
        int n2 = Runtime.toInt(l);
        this.b[n] = (byte)n2;
        this.b[n + 1] = (byte)(n2 >> 8);
        this.b[n + 2] = (byte)(n2 >> 16);
        this.b[n + 3] = (byte)(n2 >>> 24);
        n2 = n + 4;
        int n3 = Runtime.toInt(l >> 32);
        this.b[n2] = (byte)n3;
        this.b[n2 + 1] = (byte)(n3 >> 8);
        this.b[n2 + 2] = (byte)(n3 >> 16);
        this.b[n2 + 3] = (byte)(n3 >>> 24);
    }

    public String getString(int n, int n2) {
        if (n < 0 || n2 < 0 || n + n2 > this.length) {
            throw HaxeException.wrap(Error.OutsideBounds);
        }
        try {
            return new String(this.b, n, n2, "UTF-8");
        }
        catch (Throwable throwable) {
            Exceptions.setException(throwable);
            Object object = throwable;
            if (object instanceof HaxeException) {
                object = ((HaxeException)throwable).obj;
            }
            Throwable throwable2 = object;
            throw HaxeException.wrap(throwable2);
        }
    }

    public final String readString(int n, int n2) {
        return this.getString(n, n2);
    }

    public String toString() {
        try {
            return new String(this.b, 0, this.length, "UTF-8");
        }
        catch (Throwable throwable) {
            Exceptions.setException(throwable);
            Object object = throwable;
            if (object instanceof HaxeException) {
                object = ((HaxeException)throwable).obj;
            }
            Throwable throwable2 = object;
            throw HaxeException.wrap(throwable2);
        }
    }

    public String toHex() {
        int n;
        StringBuf stringBuf = new StringBuf();
        Array<Object> array = new Array<Object>(new Object[0]);
        String string = "0123456789abcdef";
        int n2 = 0;
        int n3 = string.length();
        while (n2 < n3) {
            n = n2++;
            array.push(StringExt.charCodeAt(string, n));
        }
        n2 = 0;
        n3 = this.length;
        while (n2 < n3) {
            n = n2++;
            int n4 = this.b[n] & 0xFF;
            stringBuf.addChar(Runtime.toInt(array.__get(n4 >> 4)));
            stringBuf.addChar(Runtime.toInt(array.__get(n4 & 0xF)));
        }
        return stringBuf.toString();
    }

    public final byte[] getData() {
        return this.b;
    }

    @Override
    public double __hx_setField_f(String string, double d, boolean bl) {
        boolean bl2 = true;
        switch (string.hashCode()) {
            case -1106363674: {
                if (!string.equals("length")) break;
                bl2 = false;
                this.length = (int)d;
                return d;
            }
        }
        if (bl2) {
            return super.__hx_setField_f(string, d, bl);
        }
        throw null;
    }

    @Override
    public Object __hx_setField(String string, Object object, boolean bl) {
        boolean bl2 = true;
        switch (string.hashCode()) {
            case 98: {
                if (!string.equals("b")) break;
                bl2 = false;
                this.b = (byte[])object;
                return object;
            }
            case -1106363674: {
                if (!string.equals("length")) break;
                bl2 = false;
                this.length = Runtime.toInt(object);
                return object;
            }
        }
        if (bl2) {
            return super.__hx_setField(string, object, bl);
        }
        throw null;
    }

    @Override
    public Object __hx_getField(String string, boolean bl, boolean bl2, boolean bl3) {
        boolean bl4 = true;
        switch (string.hashCode()) {
            case -75605984: {
                if (!string.equals("getData")) break;
                bl4 = false;
                return new Closure(this, "getData");
            }
            case -1106363674: {
                if (!string.equals("length")) break;
                bl4 = false;
                return this.length;
            }
            case 110507680: {
                if (!string.equals("toHex")) break;
                bl4 = false;
                return new Closure(this, "toHex");
            }
            case 98: {
                if (!string.equals("b")) break;
                bl4 = false;
                return this.b;
            }
            case -1776922004: {
                if (!string.equals("toString")) break;
                bl4 = false;
                return new Closure(this, "toString");
            }
            case 102230: {
                if (!string.equals("get")) break;
                bl4 = false;
                return new Closure(this, "get");
            }
            case -500196025: {
                if (!string.equals("readString")) break;
                bl4 = false;
                return new Closure(this, "readString");
            }
            case 113762: {
                if (!string.equals("set")) break;
                bl4 = false;
                return new Closure(this, "set");
            }
            case 804029191: {
                if (!string.equals("getString")) break;
                bl4 = false;
                return new Closure(this, "getString");
            }
            case 3026677: {
                if (!string.equals("blit")) break;
                bl4 = false;
                return new Closure(this, "blit");
            }
            case 1395072939: {
                if (!string.equals("setInt64")) break;
                bl4 = false;
                return new Closure(this, "setInt64");
            }
            case 3143043: {
                if (!string.equals("fill")) break;
                bl4 = false;
                return new Closure(this, "fill");
            }
            case 1395072844: {
                if (!string.equals("setInt32")) break;
                bl4 = false;
                return new Closure(this, "setInt32");
            }
            case 114240: {
                if (!string.equals("sub")) break;
                bl4 = false;
                return new Closure(this, "sub");
            }
            case 1956185399: {
                if (!string.equals("getInt64")) break;
                bl4 = false;
                return new Closure(this, "getInt64");
            }
            case 950484197: {
                if (!string.equals("compare")) break;
                bl4 = false;
                return new Closure(this, "compare");
            }
            case 1956185304: {
                if (!string.equals("getInt32")) break;
                bl4 = false;
                return new Closure(this, "getInt32");
            }
            case 370056903: {
                if (!string.equals("getDouble")) break;
                bl4 = false;
                return new Closure(this, "getDouble");
            }
            case 606848481: {
                if (!string.equals("setUInt16")) break;
                bl4 = false;
                return new Closure(this, "setUInt16");
            }
            case 1953351846: {
                if (!string.equals("getFloat")) break;
                bl4 = false;
                return new Closure(this, "getFloat");
            }
            case 821465557: {
                if (!string.equals("getUInt16")) break;
                bl4 = false;
                return new Closure(this, "getUInt16");
            }
            case 155439827: {
                if (!string.equals("setDouble")) break;
                bl4 = false;
                return new Closure(this, "setDouble");
            }
            case 1392239386: {
                if (!string.equals("setFloat")) break;
                bl4 = false;
                return new Closure(this, "setFloat");
            }
        }
        if (bl4) {
            return super.__hx_getField(string, bl, bl2, bl3);
        }
        throw null;
    }

    @Override
    public double __hx_getField_f(String string, boolean bl, boolean bl2) {
        boolean bl3 = true;
        switch (string.hashCode()) {
            case -1106363674: {
                if (!string.equals("length")) break;
                bl3 = false;
                return this.length;
            }
        }
        if (bl3) {
            return super.__hx_getField_f(string, bl, bl2);
        }
        throw null;
    }

    @Override
    public Object __hx_invokeField(String string, Array array) {
        boolean bl = true;
        switch (string.hashCode()) {
            case -75605984: {
                if (!string.equals("getData")) break;
                bl = false;
                return this.getData();
            }
            case 102230: {
                if (!string.equals("get")) break;
                bl = false;
                return this.get(Runtime.toInt(array.__get(0)));
            }
            case 110507680: {
                if (!string.equals("toHex")) break;
                bl = false;
                return this.toHex();
            }
            case 113762: {
                if (!string.equals("set")) break;
                bl = false;
                this.set(Runtime.toInt(array.__get(0)), Runtime.toInt(array.__get(1)));
                break;
            }
            case -1776922004: {
                if (!string.equals("toString")) break;
                bl = false;
                return this.toString();
            }
            case 3026677: {
                if (!string.equals("blit")) break;
                bl = false;
                this.blit(Runtime.toInt(array.__get(0)), (Bytes)array.__get(1), Runtime.toInt(array.__get(2)), Runtime.toInt(array.__get(3)));
                break;
            }
            case -500196025: {
                if (!string.equals("readString")) break;
                bl = false;
                return this.readString(Runtime.toInt(array.__get(0)), Runtime.toInt(array.__get(1)));
            }
            case 3143043: {
                if (!string.equals("fill")) break;
                bl = false;
                this.fill(Runtime.toInt(array.__get(0)), Runtime.toInt(array.__get(1)), Runtime.toInt(array.__get(2)));
                break;
            }
            case 804029191: {
                if (!string.equals("getString")) break;
                bl = false;
                return this.getString(Runtime.toInt(array.__get(0)), Runtime.toInt(array.__get(1)));
            }
            case 114240: {
                if (!string.equals("sub")) break;
                bl = false;
                return this.sub(Runtime.toInt(array.__get(0)), Runtime.toInt(array.__get(1)));
            }
            case 1395072939: {
                if (!string.equals("setInt64")) break;
                bl = false;
                this.setInt64(Runtime.toInt(array.__get(0)), (Long)array.__get(1));
                break;
            }
            case 950484197: {
                if (!string.equals("compare")) break;
                bl = false;
                return this.compare((Bytes)array.__get(0));
            }
            case 1395072844: {
                if (!string.equals("setInt32")) break;
                bl = false;
                this.setInt32(Runtime.toInt(array.__get(0)), Runtime.toInt(array.__get(1)));
                break;
            }
            case 370056903: {
                if (!string.equals("getDouble")) break;
                bl = false;
                return this.getDouble(Runtime.toInt(array.__get(0)));
            }
            case 1956185399: {
                if (!string.equals("getInt64")) break;
                bl = false;
                return this.getInt64(Runtime.toInt(array.__get(0)));
            }
            case 1953351846: {
                if (!string.equals("getFloat")) break;
                bl = false;
                return this.getFloat(Runtime.toInt(array.__get(0)));
            }
            case 1956185304: {
                if (!string.equals("getInt32")) break;
                bl = false;
                return this.getInt32(Runtime.toInt(array.__get(0)));
            }
            case 155439827: {
                if (!string.equals("setDouble")) break;
                bl = false;
                this.setDouble(Runtime.toInt(array.__get(0)), Runtime.toDouble(array.__get(1)));
                break;
            }
            case 606848481: {
                if (!string.equals("setUInt16")) break;
                bl = false;
                this.setUInt16(Runtime.toInt(array.__get(0)), Runtime.toInt(array.__get(1)));
                break;
            }
            case 1392239386: {
                if (!string.equals("setFloat")) break;
                bl = false;
                this.setFloat(Runtime.toInt(array.__get(0)), Runtime.toDouble(array.__get(1)));
                break;
            }
            case 821465557: {
                if (!string.equals("getUInt16")) break;
                bl = false;
                return this.getUInt16(Runtime.toInt(array.__get(0)));
            }
        }
        if (bl) {
            return super.__hx_invokeField(string, array);
        }
        return null;
    }

    @Override
    public void __hx_getFields(Array<String> array) {
        array.push("b");
        array.push("length");
        super.__hx_getFields(array);
    }
}

