/*
 * Decompiled with CFR 0.152.
 */
package haxe.io;

import haxe.io.Bytes;
import haxe.io.BytesBuffer;
import haxe.io.Eof;
import haxe.io.Error;
import haxe.io.FPHelper;
import haxe.lang.Closure;
import haxe.lang.EmptyObject;
import haxe.lang.Exceptions;
import haxe.lang.HaxeException;
import haxe.lang.HxObject;
import haxe.lang.Runtime;
import haxe.lang.StringExt;
import haxe.root.Array;
import haxe.root.StringBuf;
import java.nio.ByteBuffer;

public class Input
extends HxObject {
    public boolean bigEndian;
    public ByteBuffer helper;

    public Input(EmptyObject emptyObject) {
    }

    public Input() {
        Input.__hx_ctor_haxe_io_Input(this);
    }

    public static void __hx_ctor_haxe_io_Input(Input input) {
    }

    public static Object __hx_createEmpty() {
        return new Input(EmptyObject.EMPTY);
    }

    public static Object __hx_create(Array array) {
        return new Input();
    }

    public int readByte() {
        throw HaxeException.wrap("Not implemented");
    }

    public int readBytes(Bytes bytes, int n, int n2) {
        byte[] byArray = bytes.b;
        if (n < 0 || n2 < 0 || n + n2 > bytes.length) {
            throw HaxeException.wrap(Error.OutsideBounds);
        }
        for (int i = n2; i > 0; --i) {
            byArray[n] = (byte)this.readByte();
            ++n;
        }
        return n2;
    }

    public void close() {
    }

    public boolean set_bigEndian(boolean bl) {
        this.bigEndian = bl;
        return bl;
    }

    public Bytes readAll(Object object) {
        if (Runtime.eq(object, null)) {
            object = 16384;
        }
        Bytes bytes = Bytes.alloc(Runtime.toInt(object));
        BytesBuffer bytesBuffer = new BytesBuffer();
        try {
            while (true) {
                int n;
                if ((n = this.readBytes(bytes, 0, Runtime.toInt(object))) == 0) {
                    throw HaxeException.wrap(Error.Blocked);
                }
                if (n < 0 || n > bytes.length) {
                    throw HaxeException.wrap(Error.OutsideBounds);
                }
                bytesBuffer.b.write(bytes.b, 0, n);
            }
        }
        catch (Throwable throwable) {
            Exceptions.setException(throwable);
            Object object2 = throwable;
            if (object2 instanceof HaxeException) {
                object2 = ((HaxeException)throwable).obj;
            }
            if (!(object2 instanceof Eof)) {
                throw HaxeException.wrap(throwable);
            }
            Eof eof = (Eof)object2;
            return bytesBuffer.getBytes();
        }
    }

    public void readFullBytes(Bytes bytes, int n, int n2) {
        while (n2 > 0) {
            int n3 = this.readBytes(bytes, n, n2);
            n += n3;
            n2 -= n3;
        }
    }

    public Bytes read(int n) {
        Bytes bytes = Bytes.alloc(n);
        int n2 = 0;
        while (n > 0) {
            int n3 = this.readBytes(bytes, n2, n);
            if (n3 == 0) {
                throw HaxeException.wrap(Error.Blocked);
            }
            n2 += n3;
            n -= n3;
        }
        return bytes;
    }

    public String readUntil(int n) {
        StringBuf stringBuf = new StringBuf();
        int n2 = 0;
        while ((n2 = this.readByte()) != n) {
            stringBuf.addChar(n2);
        }
        return stringBuf.toString();
    }

    public String readLine() {
        StringBuf stringBuf = new StringBuf();
        int n = 0;
        String string = null;
        try {
            while ((n = this.readByte()) != 10) {
                stringBuf.addChar(n);
            }
            string = stringBuf.toString();
            if (Runtime.eq(StringExt.charCodeAt(string, string.length() - 1), 13)) {
                string = StringExt.substr(string, 0, -1);
            }
        }
        catch (Throwable throwable) {
            Exceptions.setException(throwable);
            Object object = throwable;
            if (object instanceof HaxeException) {
                object = ((HaxeException)throwable).obj;
            }
            if (object instanceof Eof) {
                Eof eof = (Eof)object;
                string = stringBuf.toString();
                if (string.length() == 0) {
                    throw HaxeException.wrap(eof);
                }
            }
            throw HaxeException.wrap(throwable);
        }
        return string;
    }

    public final double readFloat() {
        return FPHelper.i32ToFloat(this.readInt32());
    }

    public double readDouble() {
        int n = this.readInt32();
        int n2 = this.readInt32();
        if (this.bigEndian) {
            return FPHelper.i64ToDouble(n2, n);
        }
        return FPHelper.i64ToDouble(n, n2);
    }

    public int readInt8() {
        int n = this.readByte();
        if (n >= 128) {
            return n - 256;
        }
        return n;
    }

    public int readInt16() {
        int n = this.readByte();
        int n2 = this.readByte();
        int n3 = 0;
        n3 = this.bigEndian ? n2 | n << 8 : n | n2 << 8;
        if ((n3 & 0x8000) != 0) {
            return n3 - 65536;
        }
        return n3;
    }

    public int readUInt16() {
        int n = this.readByte();
        int n2 = this.readByte();
        if (this.bigEndian) {
            return n2 | n << 8;
        }
        return n | n2 << 8;
    }

    public int readInt24() {
        int n = this.readByte();
        int n2 = this.readByte();
        int n3 = this.readByte();
        int n4 = 0;
        n4 = this.bigEndian ? n3 | n2 << 8 | n << 16 : n | n2 << 8 | n3 << 16;
        if ((n4 & 0x800000) != 0) {
            return n4 - 0x1000000;
        }
        return n4;
    }

    public int readUInt24() {
        int n = this.readByte();
        int n2 = this.readByte();
        int n3 = this.readByte();
        if (this.bigEndian) {
            return n3 | n2 << 8 | n << 16;
        }
        return n | n2 << 8 | n3 << 16;
    }

    public int readInt32() {
        int n = this.readByte();
        int n2 = this.readByte();
        int n3 = this.readByte();
        int n4 = this.readByte();
        if (this.bigEndian) {
            return n4 | n3 << 8 | n2 << 16 | n << 24;
        }
        return n | n2 << 8 | n3 << 16 | n4 << 24;
    }

    public String readString(int n) {
        Bytes bytes = Bytes.alloc(n);
        this.readFullBytes(bytes, 0, n);
        return bytes.toString();
    }

    @Override
    public Object __hx_setField(String string, Object object, boolean bl) {
        boolean bl2 = true;
        switch (string.hashCode()) {
            case -1220931666: {
                if (!string.equals("helper")) break;
                bl2 = false;
                this.helper = (ByteBuffer)object;
                return object;
            }
            case 0x222B44BB: {
                if (!string.equals("bigEndian")) break;
                bl2 = false;
                if (bl) {
                    this.set_bigEndian(Runtime.toBool(object));
                    return object;
                }
                this.bigEndian = Runtime.toBool(object);
                return object;
            }
        }
        if (bl2) {
            return super.__hx_setField(string, object, bl);
        }
        throw null;
    }

    @Override
    public Object __hx_getField(String string, boolean bl, boolean bl2, boolean bl3) {
        boolean bl4 = true;
        switch (string.hashCode()) {
            case -500196025: {
                if (!string.equals("readString")) break;
                bl4 = false;
                return new Closure(this, "readString");
            }
            case 0x222B44BB: {
                if (!string.equals("bigEndian")) break;
                bl4 = false;
                return this.bigEndian;
            }
            case -1133927784: {
                if (!string.equals("readInt32")) break;
                bl4 = false;
                return new Closure(this, "readInt32");
            }
            case -1220931666: {
                if (!string.equals("helper")) break;
                bl4 = false;
                return this.helper;
            }
            case -482759630: {
                if (!string.equals("readUInt24")) break;
                bl4 = false;
                return new Closure(this, "readUInt24");
            }
            case -868060226: {
                if (!string.equals("readByte")) break;
                bl4 = false;
                return new Closure(this, "readByte");
            }
            case -1133927813: {
                if (!string.equals("readInt24")) break;
                bl4 = false;
                return new Closure(this, "readInt24");
            }
            case -1140063115: {
                if (!string.equals("readBytes")) break;
                bl4 = false;
                return new Closure(this, "readBytes");
            }
            case -482759659: {
                if (!string.equals("readUInt16")) break;
                bl4 = false;
                return new Closure(this, "readUInt16");
            }
            case 94756344: {
                if (!string.equals("close")) break;
                bl4 = false;
                return new Closure(this, "close");
            }
            case -1133927842: {
                if (!string.equals("readInt16")) break;
                bl4 = false;
                return new Closure(this, "readInt16");
            }
            case 1862232350: {
                if (!string.equals("set_bigEndian")) break;
                bl4 = false;
                return new Closure(this, "set_bigEndian");
            }
            case -867862305: {
                if (!string.equals("readInt8")) break;
                bl4 = false;
                return new Closure(this, "readInt8");
            }
            case 1080375339: {
                if (!string.equals("readAll")) break;
                bl4 = false;
                return new Closure(this, "readAll");
            }
            case -934168313: {
                if (!string.equals("readDouble")) break;
                bl4 = false;
                return new Closure(this, "readDouble");
            }
            case 682499622: {
                if (!string.equals("readFullBytes")) break;
                bl4 = false;
                return new Closure(this, "readFullBytes");
            }
            case -1136761242: {
                if (!string.equals("readFloat")) break;
                bl4 = false;
                return new Closure(this, "readFloat");
            }
            case 3496342: {
                if (!string.equals("read")) break;
                bl4 = false;
                return new Closure(this, "read");
            }
            case -867777878: {
                if (!string.equals("readLine")) break;
                bl4 = false;
                return new Closure(this, "readLine");
            }
            case -1122843800: {
                if (!string.equals("readUntil")) break;
                bl4 = false;
                return new Closure(this, "readUntil");
            }
        }
        if (bl4) {
            return super.__hx_getField(string, bl, bl2, bl3);
        }
        throw null;
    }

    @Override
    public Object __hx_invokeField(String string, Array array) {
        boolean bl = true;
        switch (string.hashCode()) {
            case -500196025: {
                if (!string.equals("readString")) break;
                bl = false;
                return this.readString(Runtime.toInt(array.__get(0)));
            }
            case -868060226: {
                if (!string.equals("readByte")) break;
                bl = false;
                return this.readByte();
            }
            case -1133927784: {
                if (!string.equals("readInt32")) break;
                bl = false;
                return this.readInt32();
            }
            case -1140063115: {
                if (!string.equals("readBytes")) break;
                bl = false;
                return this.readBytes((Bytes)array.__get(0), Runtime.toInt(array.__get(1)), Runtime.toInt(array.__get(2)));
            }
            case -482759630: {
                if (!string.equals("readUInt24")) break;
                bl = false;
                return this.readUInt24();
            }
            case 94756344: {
                if (!string.equals("close")) break;
                bl = false;
                this.close();
                break;
            }
            case -1133927813: {
                if (!string.equals("readInt24")) break;
                bl = false;
                return this.readInt24();
            }
            case 1862232350: {
                if (!string.equals("set_bigEndian")) break;
                bl = false;
                return this.set_bigEndian(Runtime.toBool(array.__get(0)));
            }
            case -482759659: {
                if (!string.equals("readUInt16")) break;
                bl = false;
                return this.readUInt16();
            }
            case 1080375339: {
                if (!string.equals("readAll")) break;
                bl = false;
                return this.readAll(array.__get(0));
            }
            case -1133927842: {
                if (!string.equals("readInt16")) break;
                bl = false;
                return this.readInt16();
            }
            case 682499622: {
                if (!string.equals("readFullBytes")) break;
                bl = false;
                this.readFullBytes((Bytes)array.__get(0), Runtime.toInt(array.__get(1)), Runtime.toInt(array.__get(2)));
                break;
            }
            case -867862305: {
                if (!string.equals("readInt8")) break;
                bl = false;
                return this.readInt8();
            }
            case 3496342: {
                if (!string.equals("read")) break;
                bl = false;
                return this.read(Runtime.toInt(array.__get(0)));
            }
            case -934168313: {
                if (!string.equals("readDouble")) break;
                bl = false;
                return this.readDouble();
            }
            case -1122843800: {
                if (!string.equals("readUntil")) break;
                bl = false;
                return this.readUntil(Runtime.toInt(array.__get(0)));
            }
            case -1136761242: {
                if (!string.equals("readFloat")) break;
                bl = false;
                return this.readFloat();
            }
            case -867777878: {
                if (!string.equals("readLine")) break;
                bl = false;
                return this.readLine();
            }
        }
        if (bl) {
            return super.__hx_invokeField(string, array);
        }
        return null;
    }

    @Override
    public void __hx_getFields(Array<String> array) {
        array.push("helper");
        array.push("bigEndian");
        super.__hx_getFields(array);
    }
}

