/*
 * Decompiled with CFR 0.152.
 */
package com.tryfinch.api.services;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.tryfinch.api.core.http.HttpResponse;
import com.tryfinch.api.errors.BadRequestException;
import com.tryfinch.api.errors.FinchError;
import com.tryfinch.api.errors.FinchException;
import com.tryfinch.api.errors.InternalServerException;
import com.tryfinch.api.errors.NotFoundException;
import com.tryfinch.api.errors.PermissionDeniedException;
import com.tryfinch.api.errors.RateLimitException;
import com.tryfinch.api.errors.UnauthorizedException;
import com.tryfinch.api.errors.UnexpectedStatusCodeException;
import com.tryfinch.api.errors.UnprocessableEntityException;
import com.tryfinch.api.services.BinaryHandler;
import com.tryfinch.api.services.EmptyHandler;
import com.tryfinch.api.services.StringHandler;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a\u000e\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001H\u0000\u001a\u0010\u0010\u0003\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0001H\u0000\u001a\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u00012\u0006\u0010\u0007\u001a\u00020\bH\u0000\u001a\u001f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\n0\u0001\"\u0006\b\u0000\u0010\n\u0018\u00012\u0006\u0010\u0007\u001a\u00020\bH\u0080\b\u001a\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0001H\u0000\u001a,\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\n0\u0001\"\u0004\b\u0000\u0010\n*\b\u0012\u0004\u0012\u0002H\n0\u00012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0001H\u0000\u00a8\u0006\u000e"}, d2={"binaryHandler", "Lcom/tryfinch/api/core/http/HttpResponse$Handler;", "Lcom/tryfinch/api/core/http/BinaryResponseContent;", "emptyHandler", "Ljava/lang/Void;", "errorHandler", "Lcom/tryfinch/api/errors/FinchError;", "jsonMapper", "Lcom/fasterxml/jackson/databind/json/JsonMapper;", "jsonHandler", "T", "stringHandler", "", "withErrorHandler", "finch-java-core"})
@JvmName(name="Handlers")
@SourceDebugExtension(value={"SMAP\nHandlers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Handlers.kt\ncom/tryfinch/api/services/Handlers\n*L\n1#1,131:1\n47#1:132\n*S KotlinDebug\n*F\n+ 1 Handlers.kt\ncom/tryfinch/api/services/Handlers\n*L\n60#1:132\n*E\n"})
public final class Handlers {
    public static final /* synthetic */ HttpResponse.Handler emptyHandler() {
        return EmptyHandler.INSTANCE;
    }

    public static final /* synthetic */ HttpResponse.Handler stringHandler() {
        return StringHandler.INSTANCE;
    }

    public static final /* synthetic */ HttpResponse.Handler binaryHandler() {
        return BinaryHandler.INSTANCE;
    }

    public static final /* synthetic */ <T> HttpResponse.Handler<T> jsonHandler(JsonMapper jsonMapper) {
        Intrinsics.checkNotNullParameter((Object)jsonMapper, (String)"jsonMapper");
        boolean $i$f$jsonHandler = false;
        Intrinsics.needClassReification();
        return new HttpResponse.Handler<T>(jsonMapper){
            final /* synthetic */ JsonMapper $jsonMapper;
            {
                this.$jsonMapper = $jsonMapper;
            }

            public T handle(@NotNull HttpResponse response) {
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                try {
                    InputStream inputStream = response.body();
                    boolean $i$f$jacksonTypeRef = false;
                    Intrinsics.needClassReification();
                    return (T)this.$jsonMapper.readValue(inputStream, (TypeReference)new TypeReference<T>(){});
                }
                catch (Exception e) {
                    throw new FinchException("Error reading response", e);
                }
            }
        };
    }

    public static final /* synthetic */ HttpResponse.Handler errorHandler(JsonMapper jsonMapper) {
        Intrinsics.checkNotNullParameter((Object)jsonMapper, (String)"jsonMapper");
        boolean $i$f$jsonHandler = false;
        HttpResponse.Handler handler = new HttpResponse.Handler<FinchError>(jsonMapper){
            final /* synthetic */ JsonMapper $jsonMapper;
            {
                this.$jsonMapper = $jsonMapper;
            }

            public FinchError handle(@NotNull HttpResponse response) {
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                try {
                    boolean $i$f$jacksonTypeRef = false;
                    return this.$jsonMapper.readValue(response.body(), (TypeReference)new TypeReference<FinchError>(){});
                }
                catch (Exception e) {
                    throw new FinchException("Error reading response", e);
                }
            }
        };
        return new HttpResponse.Handler<FinchError>((HttpResponse.Handler<FinchError>)handler){
            final /* synthetic */ HttpResponse.Handler<FinchError> $handler;
            {
                this.$handler = $handler;
            }

            @NotNull
            public FinchError handle(@NotNull HttpResponse response) {
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                try {
                    return this.$handler.handle(response);
                }
                catch (Exception e) {
                    return FinchError.Companion.builder().build();
                }
            }
        };
    }

    public static final /* synthetic */ HttpResponse.Handler withErrorHandler(HttpResponse.Handler $this$withErrorHandler, HttpResponse.Handler errorHandler2) {
        Intrinsics.checkNotNullParameter((Object)$this$withErrorHandler, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)errorHandler2, (String)"errorHandler");
        return new HttpResponse.Handler<T>($this$withErrorHandler, errorHandler2){
            final /* synthetic */ HttpResponse.Handler<T> $this_withErrorHandler;
            final /* synthetic */ HttpResponse.Handler<FinchError> $errorHandler;
            {
                this.$this_withErrorHandler = $receiver;
                this.$errorHandler = $errorHandler;
            }

            public T handle(@NotNull HttpResponse response) {
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                int statusCode = response.statusCode();
                boolean bl = 200 <= statusCode ? statusCode < 300 : false;
                if (bl) {
                    return this.$this_withErrorHandler.handle(response);
                }
                if (statusCode == 400) {
                    throw new BadRequestException(response.headers(), this.$errorHandler.handle(response));
                }
                if (statusCode == 401) {
                    throw new UnauthorizedException(response.headers(), this.$errorHandler.handle(response));
                }
                if (statusCode == 403) {
                    throw new PermissionDeniedException(response.headers(), this.$errorHandler.handle(response));
                }
                if (statusCode == 404) {
                    throw new NotFoundException(response.headers(), this.$errorHandler.handle(response));
                }
                if (statusCode == 422) {
                    throw new UnprocessableEntityException(response.headers(), this.$errorHandler.handle(response));
                }
                if (statusCode == 429) {
                    throw new RateLimitException(response.headers(), this.$errorHandler.handle(response));
                }
                boolean bl2 = 500 <= statusCode ? statusCode < 600 : false;
                if (bl2) {
                    throw new InternalServerException(statusCode, response.headers(), this.$errorHandler.handle(response));
                }
                throw new UnexpectedStatusCodeException(statusCode, response.headers(), StringHandler.INSTANCE.handle(response));
            }
        };
    }
}

