/*
 * Decompiled with CFR 0.152.
 */
package com.tryfinch.api.services.async;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.google.common.collect.Multimap;
import com.tryfinch.api.core.ClientOptions;
import com.tryfinch.api.core.RequestOptions;
import com.tryfinch.api.core.http.HttpMethod;
import com.tryfinch.api.core.http.HttpRequest;
import com.tryfinch.api.core.http.HttpRequestBody;
import com.tryfinch.api.core.http.HttpResponse;
import com.tryfinch.api.errors.FinchError;
import com.tryfinch.api.errors.FinchException;
import com.tryfinch.api.models.AccessTokenCreateParams;
import com.tryfinch.api.models.CreateAccessTokenResponse;
import com.tryfinch.api.services.Handlers;
import com.tryfinch.api.services.async.AccessTokenServiceAsync;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.OutputStream;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/tryfinch/api/services/async/AccessTokenServiceAsyncImpl;", "Lcom/tryfinch/api/services/async/AccessTokenServiceAsync;", "clientOptions", "Lcom/tryfinch/api/core/ClientOptions;", "(Lcom/tryfinch/api/core/ClientOptions;)V", "createHandler", "Lcom/tryfinch/api/core/http/HttpResponse$Handler;", "Lcom/tryfinch/api/models/CreateAccessTokenResponse;", "errorHandler", "Lcom/tryfinch/api/errors/FinchError;", "create", "Ljava/util/concurrent/CompletableFuture;", "params", "Lcom/tryfinch/api/models/AccessTokenCreateParams;", "requestOptions", "Lcom/tryfinch/api/core/RequestOptions;", "finch-java-core"})
@SourceDebugExtension(value={"SMAP\nAccessTokenServiceAsyncImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AccessTokenServiceAsyncImpl.kt\ncom/tryfinch/api/services/async/AccessTokenServiceAsyncImpl\n+ 2 Handlers.kt\ncom/tryfinch/api/services/Handlers\n+ 3 HttpRequestBodies.kt\ncom/tryfinch/api/services/HttpRequestBodies\n*L\n1#1,79:1\n47#2:80\n20#3:81\n*S KotlinDebug\n*F\n+ 1 AccessTokenServiceAsyncImpl.kt\ncom/tryfinch/api/services/async/AccessTokenServiceAsyncImpl\n*L\n28#1:80\n65#1:81\n*E\n"})
public final class AccessTokenServiceAsyncImpl
implements AccessTokenServiceAsync {
    @NotNull
    private final ClientOptions clientOptions;
    @NotNull
    private final HttpResponse.Handler<FinchError> errorHandler;
    @NotNull
    private final HttpResponse.Handler<CreateAccessTokenResponse> createHandler;

    public AccessTokenServiceAsyncImpl(@NotNull ClientOptions clientOptions) {
        Intrinsics.checkNotNullParameter((Object)clientOptions, (String)"clientOptions");
        this.clientOptions = clientOptions;
        this.errorHandler = Handlers.errorHandler(this.clientOptions.jsonMapper());
        JsonMapper jsonMapper$iv = this.clientOptions.jsonMapper();
        boolean $i$f$jsonHandler = false;
        this.createHandler = Handlers.withErrorHandler(new HttpResponse.Handler<CreateAccessTokenResponse>(jsonMapper$iv){
            final /* synthetic */ JsonMapper $jsonMapper;
            {
                this.$jsonMapper = $jsonMapper;
            }

            public CreateAccessTokenResponse handle(@NotNull HttpResponse response) {
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                try {
                    boolean $i$f$jacksonTypeRef = false;
                    return this.$jsonMapper.readValue(response.body(), (TypeReference)new TypeReference<CreateAccessTokenResponse>(){});
                }
                catch (Exception e) {
                    throw new FinchException("Error reading response", e);
                }
            }
        }, this.errorHandler);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CompletableFuture<CreateAccessTokenResponse> create(@NotNull AccessTokenCreateParams params, @NotNull RequestOptions requestOptions) {
        void jsonMapper$iv;
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)requestOptions, (String)"requestOptions");
        AccessTokenCreateParams.Builder builder = params.toBuilder();
        if (!params.clientSecret().isPresent()) {
            if (this.clientOptions.clientSecret() == null || ((CharSequence)this.clientOptions.clientSecret()).length() == 0) {
                throw new FinchException("client_secret must be provided as an argument or with the FINCH_CLIENT_SECRET environment variable", null, 2, null);
            }
            builder.clientSecret(this.clientOptions.clientSecret());
        }
        if (!params.clientId().isPresent()) {
            if (this.clientOptions.clientId() == null || ((CharSequence)this.clientOptions.clientId()).length() == 0) {
                throw new FinchException("client_id must be provided as an argument or with the FINCH_CLIENT_ID environment variable", null, 2, null);
            }
            builder.clientId(this.clientOptions.clientId());
        }
        AccessTokenCreateParams modifiedParams = builder.build();
        String[] stringArray = new String[]{"auth", "token"};
        HttpRequest.Builder builder2 = HttpRequest.Companion.builder().method(HttpMethod.POST).addPathSegments(stringArray).putAllQueryParams(params.getQueryParams$finch_java_core()).putAllHeaders((Multimap<String, String>)((Multimap)this.clientOptions.headers())).putAllHeaders(params.getHeaders$finch_java_core());
        stringArray = this.clientOptions.jsonMapper();
        AccessTokenCreateParams.AccessTokenCreateBody value$iv = modifiedParams.getBody$finch_java_core();
        boolean $i$f$json = false;
        HttpRequest request2 = builder2.body(new HttpRequestBody((JsonMapper)jsonMapper$iv, value$iv){
            @Nullable
            private byte[] cachedBytes;
            final /* synthetic */ JsonMapper $jsonMapper;
            final /* synthetic */ T $value;
            {
                this.$jsonMapper = $jsonMapper;
                this.$value = $value;
            }

            private final byte[] serialize() {
                if (this.cachedBytes != null) {
                    Intrinsics.checkNotNull((Object)this.cachedBytes);
                    return this.cachedBytes;
                }
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                try {
                    this.$jsonMapper.writeValue((OutputStream)buffer, this.$value);
                    this.cachedBytes = buffer.toByteArray();
                    Intrinsics.checkNotNull((Object)this.cachedBytes);
                    return this.cachedBytes;
                }
                catch (Exception e) {
                    throw new FinchException("Error writing request", e);
                }
            }

            public void writeTo(@NotNull OutputStream outputStream) {
                Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
                outputStream.write(this.serialize());
            }

            @NotNull
            public String contentType() {
                return "application/json";
            }

            public long contentLength() {
                return this.serialize().length;
            }

            public boolean repeatable() {
                return true;
            }

            public void close() {
            }
        }).build();
        CompletionStage completionStage = this.clientOptions.httpClient().executeAsync(request2, requestOptions).thenApply(arg_0 -> AccessTokenServiceAsyncImpl.create$lambda$0((Function1)new Function1<HttpResponse, CreateAccessTokenResponse>(this, requestOptions){
            final /* synthetic */ AccessTokenServiceAsyncImpl this$0;
            final /* synthetic */ RequestOptions $requestOptions;
            {
                this.this$0 = $receiver;
                this.$requestOptions = $requestOptions;
                super(1);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final CreateAccessTokenResponse invoke(HttpResponse response) {
                Object object = response;
                Object object2 = this.this$0;
                Object object3 = null;
                try {
                    Object it = (HttpResponse)object;
                    boolean bl = false;
                    HttpResponse.Handler handler = AccessTokenServiceAsyncImpl.access$getCreateHandler$p((AccessTokenServiceAsyncImpl)object2);
                    Intrinsics.checkNotNull((Object)it);
                    it = (CreateAccessTokenResponse)handler.handle((HttpResponse)it);
                }
                catch (Throwable it) {
                    object3 = it;
                    throw it;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)object3);
                }
                object = it;
                object2 = this.$requestOptions;
                object3 = this.this$0;
                Object $this$invoke_u24lambda_u241 = object;
                boolean bl = false;
                Boolean bl2 = ((RequestOptions)object2).getResponseValidation();
                if (bl2 != null ? bl2.booleanValue() : AccessTokenServiceAsyncImpl.access$getClientOptions$p((AccessTokenServiceAsyncImpl)object3).responseValidation()) {
                    ((CreateAccessTokenResponse)$this$invoke_u24lambda_u241).validate();
                }
                return object;
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"thenApply(...)");
        return completionStage;
    }

    private static final CreateAccessTokenResponse create$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (CreateAccessTokenResponse)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ HttpResponse.Handler access$getCreateHandler$p(AccessTokenServiceAsyncImpl $this) {
        return $this.createHandler;
    }

    public static final /* synthetic */ ClientOptions access$getClientOptions$p(AccessTokenServiceAsyncImpl $this) {
        return $this.clientOptions;
    }
}

