/*
 * Decompiled with CFR 0.152.
 */
package com.tryfinch.api.services.async.sandbox;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.google.common.collect.Multimap;
import com.tryfinch.api.core.ClientOptions;
import com.tryfinch.api.core.RequestOptions;
import com.tryfinch.api.core.http.HttpMethod;
import com.tryfinch.api.core.http.HttpRequest;
import com.tryfinch.api.core.http.HttpRequestBody;
import com.tryfinch.api.core.http.HttpResponse;
import com.tryfinch.api.errors.FinchError;
import com.tryfinch.api.errors.FinchException;
import com.tryfinch.api.models.JobCreateResponse;
import com.tryfinch.api.models.SandboxJobCreateParams;
import com.tryfinch.api.services.Handlers;
import com.tryfinch.api.services.async.sandbox.JobServiceAsync;
import com.tryfinch.api.services.async.sandbox.jobs.ConfigurationServiceAsync;
import com.tryfinch.api.services.async.sandbox.jobs.ConfigurationServiceAsyncImpl;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.OutputStream;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u001e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0005\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/tryfinch/api/services/async/sandbox/JobServiceAsyncImpl;", "Lcom/tryfinch/api/services/async/sandbox/JobServiceAsync;", "clientOptions", "Lcom/tryfinch/api/core/ClientOptions;", "(Lcom/tryfinch/api/core/ClientOptions;)V", "configuration", "Lcom/tryfinch/api/services/async/sandbox/jobs/ConfigurationServiceAsync;", "getConfiguration", "()Lcom/tryfinch/api/services/async/sandbox/jobs/ConfigurationServiceAsync;", "configuration$delegate", "Lkotlin/Lazy;", "createHandler", "Lcom/tryfinch/api/core/http/HttpResponse$Handler;", "Lcom/tryfinch/api/models/JobCreateResponse;", "errorHandler", "Lcom/tryfinch/api/errors/FinchError;", "create", "Ljava/util/concurrent/CompletableFuture;", "params", "Lcom/tryfinch/api/models/SandboxJobCreateParams;", "requestOptions", "Lcom/tryfinch/api/core/RequestOptions;", "finch-java-core"})
@SourceDebugExtension(value={"SMAP\nJobServiceAsyncImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JobServiceAsyncImpl.kt\ncom/tryfinch/api/services/async/sandbox/JobServiceAsyncImpl\n+ 2 Handlers.kt\ncom/tryfinch/api/services/Handlers\n+ 3 HttpRequestBodies.kt\ncom/tryfinch/api/services/HttpRequestBodies\n*L\n1#1,63:1\n47#2:64\n20#3:65\n*S KotlinDebug\n*F\n+ 1 JobServiceAsyncImpl.kt\ncom/tryfinch/api/services/async/sandbox/JobServiceAsyncImpl\n*L\n35#1:64\n49#1:65\n*E\n"})
public final class JobServiceAsyncImpl
implements JobServiceAsync {
    @NotNull
    private final ClientOptions clientOptions;
    @NotNull
    private final HttpResponse.Handler<FinchError> errorHandler;
    @NotNull
    private final Lazy configuration$delegate;
    @NotNull
    private final HttpResponse.Handler<JobCreateResponse> createHandler;

    public JobServiceAsyncImpl(@NotNull ClientOptions clientOptions) {
        Intrinsics.checkNotNullParameter((Object)clientOptions, (String)"clientOptions");
        this.clientOptions = clientOptions;
        this.errorHandler = Handlers.errorHandler(this.clientOptions.jsonMapper());
        this.configuration$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ConfigurationServiceAsyncImpl>(this){
            final /* synthetic */ JobServiceAsyncImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final ConfigurationServiceAsyncImpl invoke() {
                return new ConfigurationServiceAsyncImpl(JobServiceAsyncImpl.access$getClientOptions$p(this.this$0));
            }
        }));
        JsonMapper jsonMapper$iv = this.clientOptions.jsonMapper();
        boolean $i$f$jsonHandler = false;
        this.createHandler = Handlers.withErrorHandler(new HttpResponse.Handler<JobCreateResponse>(jsonMapper$iv){
            final /* synthetic */ JsonMapper $jsonMapper;
            {
                this.$jsonMapper = $jsonMapper;
            }

            public JobCreateResponse handle(@NotNull HttpResponse response) {
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                try {
                    boolean $i$f$jacksonTypeRef = false;
                    return this.$jsonMapper.readValue(response.body(), (TypeReference)new TypeReference<JobCreateResponse>(){});
                }
                catch (Exception e) {
                    throw new FinchException("Error reading response", e);
                }
            }
        }, this.errorHandler);
    }

    private final ConfigurationServiceAsync getConfiguration() {
        Lazy lazy = this.configuration$delegate;
        return (ConfigurationServiceAsync)lazy.getValue();
    }

    @Override
    @NotNull
    public ConfigurationServiceAsync configuration() {
        return this.getConfiguration();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CompletableFuture<JobCreateResponse> create(@NotNull SandboxJobCreateParams params, @NotNull RequestOptions requestOptions) {
        void jsonMapper$iv;
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)requestOptions, (String)"requestOptions");
        String[] stringArray = new String[]{"sandbox", "jobs"};
        HttpRequest.Builder builder = HttpRequest.Companion.builder().method(HttpMethod.POST).addPathSegments(stringArray).putAllQueryParams(params.getQueryParams$finch_java_core()).putAllHeaders((Multimap<String, String>)((Multimap)this.clientOptions.headers())).putAllHeaders(params.getHeaders$finch_java_core());
        stringArray = this.clientOptions.jsonMapper();
        SandboxJobCreateParams.SandboxJobCreateBody value$iv = params.getBody$finch_java_core();
        boolean $i$f$json = false;
        HttpRequest request2 = builder.body(new HttpRequestBody((JsonMapper)jsonMapper$iv, value$iv){
            @Nullable
            private byte[] cachedBytes;
            final /* synthetic */ JsonMapper $jsonMapper;
            final /* synthetic */ T $value;
            {
                this.$jsonMapper = $jsonMapper;
                this.$value = $value;
            }

            private final byte[] serialize() {
                if (this.cachedBytes != null) {
                    Intrinsics.checkNotNull((Object)this.cachedBytes);
                    return this.cachedBytes;
                }
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                try {
                    this.$jsonMapper.writeValue((OutputStream)buffer, this.$value);
                    this.cachedBytes = buffer.toByteArray();
                    Intrinsics.checkNotNull((Object)this.cachedBytes);
                    return this.cachedBytes;
                }
                catch (Exception e) {
                    throw new FinchException("Error writing request", e);
                }
            }

            public void writeTo(@NotNull OutputStream outputStream) {
                Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
                outputStream.write(this.serialize());
            }

            @NotNull
            public String contentType() {
                return "application/json";
            }

            public long contentLength() {
                return this.serialize().length;
            }

            public boolean repeatable() {
                return true;
            }

            public void close() {
            }
        }).build();
        CompletionStage completionStage = this.clientOptions.httpClient().executeAsync(request2, requestOptions).thenApply(arg_0 -> JobServiceAsyncImpl.create$lambda$0((Function1)new Function1<HttpResponse, JobCreateResponse>(this, requestOptions){
            final /* synthetic */ JobServiceAsyncImpl this$0;
            final /* synthetic */ RequestOptions $requestOptions;
            {
                this.this$0 = $receiver;
                this.$requestOptions = $requestOptions;
                super(1);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final JobCreateResponse invoke(HttpResponse response) {
                Object object = response;
                Object object2 = this.this$0;
                Object object3 = null;
                try {
                    Object it = (HttpResponse)object;
                    boolean bl = false;
                    HttpResponse.Handler handler = JobServiceAsyncImpl.access$getCreateHandler$p((JobServiceAsyncImpl)object2);
                    Intrinsics.checkNotNull((Object)it);
                    it = (JobCreateResponse)handler.handle((HttpResponse)it);
                }
                catch (Throwable it) {
                    object3 = it;
                    throw it;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)object3);
                }
                object = it;
                object2 = this.$requestOptions;
                object3 = this.this$0;
                Object $this$invoke_u24lambda_u241 = object;
                boolean bl = false;
                Boolean bl2 = ((RequestOptions)object2).getResponseValidation();
                if (bl2 != null ? bl2.booleanValue() : JobServiceAsyncImpl.access$getClientOptions$p((JobServiceAsyncImpl)object3).responseValidation()) {
                    ((JobCreateResponse)$this$invoke_u24lambda_u241).validate();
                }
                return object;
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"thenApply(...)");
        return completionStage;
    }

    private static final JobCreateResponse create$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (JobCreateResponse)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ HttpResponse.Handler access$getCreateHandler$p(JobServiceAsyncImpl $this) {
        return $this.createHandler;
    }

    public static final /* synthetic */ ClientOptions access$getClientOptions$p(JobServiceAsyncImpl $this) {
        return $this.clientOptions;
    }
}

