/*
 * Decompiled with CFR 0.152.
 */
package com.tryfinch.api.core.http;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.tryfinch.api.core.Utils;
import com.tryfinch.api.core.http.HttpMethod;
import com.tryfinch.api.core.http.HttpRequest;
import com.tryfinch.api.core.http.HttpRequestBody;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 \u00152\u00020\u0001:\u0002\u0014\u0015BY\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\t\u0012\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\t\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0002\u0010\rJ\b\u0010\u0013\u001a\u00020\u0005H\u0016R\u0015\u0010\u000b\u001a\u0004\u0018\u00010\f8\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u000eR\u001f\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\t8\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000fR\u0013\u0010\u0002\u001a\u00020\u00038\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0010R\u0019\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00078\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0011R\u001f\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\t8\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u000fR\u0015\u0010\u0004\u001a\u0004\u0018\u00010\u00058\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0012\u00a8\u0006\u0016"}, d2={"Lcom/tryfinch/api/core/http/HttpRequest;", "", "method", "Lcom/tryfinch/api/core/http/HttpMethod;", "url", "", "pathSegments", "", "queryParams", "Lcom/google/common/collect/ListMultimap;", "headers", "body", "Lcom/tryfinch/api/core/http/HttpRequestBody;", "(Lcom/tryfinch/api/core/http/HttpMethod;Ljava/lang/String;Ljava/util/List;Lcom/google/common/collect/ListMultimap;Lcom/google/common/collect/ListMultimap;Lcom/tryfinch/api/core/http/HttpRequestBody;)V", "()Lcom/tryfinch/api/core/http/HttpRequestBody;", "()Lcom/google/common/collect/ListMultimap;", "()Lcom/tryfinch/api/core/http/HttpMethod;", "()Ljava/util/List;", "()Ljava/lang/String;", "toString", "Builder", "Companion", "finch-java-core"})
public final class HttpRequest {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final HttpMethod method;
    @Nullable
    private final String url;
    @NotNull
    private final List<String> pathSegments;
    @NotNull
    private final ListMultimap<String, String> queryParams;
    @NotNull
    private final ListMultimap<String, String> headers;
    @Nullable
    private final HttpRequestBody body;

    private HttpRequest(HttpMethod method, String url, List<String> pathSegments, ListMultimap<String, String> queryParams, ListMultimap<String, String> headers, HttpRequestBody body) {
        this.method = method;
        this.url = url;
        this.pathSegments = pathSegments;
        this.queryParams = queryParams;
        this.headers = headers;
        this.body = body;
    }

    @JvmName(name="method")
    @NotNull
    public final HttpMethod method() {
        return this.method;
    }

    @JvmName(name="url")
    @Nullable
    public final String url() {
        return this.url;
    }

    @JvmName(name="pathSegments")
    @NotNull
    public final List<String> pathSegments() {
        return this.pathSegments;
    }

    @JvmName(name="queryParams")
    @NotNull
    public final ListMultimap<String, String> queryParams() {
        return this.queryParams;
    }

    @JvmName(name="headers")
    @NotNull
    public final ListMultimap<String, String> headers() {
        return this.headers;
    }

    @JvmName(name="body")
    @Nullable
    public final HttpRequestBody body() {
        return this.body;
    }

    @NotNull
    public String toString() {
        return "HttpRequest {method=" + (Object)((Object)this.method) + ", pathSegments=" + this.pathSegments + ", queryParams=" + this.queryParams + ", headers=" + this.headers + ", body=" + this.body + '}';
    }

    @JvmStatic
    @NotNull
    public static final Builder builder() {
        return Companion.builder();
    }

    public /* synthetic */ HttpRequest(HttpMethod method, String url, List pathSegments, ListMultimap queryParams, ListMultimap headers, HttpRequestBody body, DefaultConstructorMarker $constructor_marker) {
        this(method, url, pathSegments, (ListMultimap<String, String>)queryParams, (ListMultimap<String, String>)headers, body);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\u001c\n\u0002\b\t\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0007J\u001f\u0010\u0010\u001a\u00020\u00002\u0012\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0011\"\u00020\u0007\u00a2\u0006\u0002\u0010\u0012J\u000e\u0010\u0003\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0004J\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\b\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\tJ\u001a\u0010\u0015\u001a\u00020\u00002\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0016J \u0010\u0015\u001a\u00020\u00002\u0018\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00180\u0017J\u001a\u0010\u0019\u001a\u00020\u00002\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0016J \u0010\u0019\u001a\u00020\u00002\u0018\u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00180\u0017J\u0016\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u0007J\u001c\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u00072\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00070\u0018J\u0016\u0010\u001f\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u0007J\u001c\u0010 \u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u00072\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00070\u0018J\u000e\u0010\r\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u0007R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/tryfinch/api/core/http/HttpRequest$Builder;", "", "()V", "body", "Lcom/tryfinch/api/core/http/HttpRequestBody;", "headers", "Lcom/google/common/collect/ListMultimap;", "", "method", "Lcom/tryfinch/api/core/http/HttpMethod;", "pathSegments", "", "queryParams", "url", "addPathSegment", "pathSegment", "addPathSegments", "", "([Ljava/lang/String;)Lcom/tryfinch/api/core/http/HttpRequest$Builder;", "build", "Lcom/tryfinch/api/core/http/HttpRequest;", "putAllHeaders", "Lcom/google/common/collect/Multimap;", "", "", "putAllQueryParams", "putHeader", "name", "value", "putHeaders", "values", "putQueryParam", "putQueryParams", "finch-java-core"})
    @SourceDebugExtension(value={"SMAP\nHttpRequest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpRequest.kt\ncom/tryfinch/api/core/http/HttpRequest$Builder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,93:1\n1#2:94\n*E\n"})
    public static final class Builder {
        @Nullable
        private HttpMethod method;
        @Nullable
        private String url;
        @NotNull
        private List<String> pathSegments = new ArrayList();
        @NotNull
        private ListMultimap<String, String> queryParams;
        @Nullable
        private HttpRequestBody body;
        @NotNull
        private ListMultimap<String, String> headers;

        public Builder() {
            ArrayListMultimap arrayListMultimap = ArrayListMultimap.create();
            Intrinsics.checkNotNullExpressionValue((Object)arrayListMultimap, (String)"create()");
            this.queryParams = (ListMultimap)arrayListMultimap;
            ListMultimap listMultimap = MultimapBuilder.treeKeys((Comparator)StringsKt.getCASE_INSENSITIVE_ORDER((StringCompanionObject)StringCompanionObject.INSTANCE)).arrayListValues().build();
            Intrinsics.checkNotNullExpressionValue((Object)listMultimap, (String)"treeKeys(String.CASE_INS\u2026arrayListValues().build()");
            this.headers = listMultimap;
        }

        @NotNull
        public final Builder method(@NotNull HttpMethod method) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)((Object)method), (String)"method");
            Builder $this$method_u24lambda_u240 = builder = this;
            boolean bl = false;
            $this$method_u24lambda_u240.method = method;
            return builder;
        }

        @NotNull
        public final Builder url(@NotNull String url) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Builder $this$url_u24lambda_u241 = builder = this;
            boolean bl = false;
            $this$url_u24lambda_u241.url = url;
            return builder;
        }

        @NotNull
        public final Builder addPathSegment(@NotNull String pathSegment) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)pathSegment, (String)"pathSegment");
            Builder $this$addPathSegment_u24lambda_u242 = builder = this;
            boolean bl = false;
            $this$addPathSegment_u24lambda_u242.pathSegments.add(pathSegment);
            return builder;
        }

        @NotNull
        public final Builder addPathSegments(String ... pathSegments) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)pathSegments, (String)"pathSegments");
            Builder $this$addPathSegments_u24lambda_u243 = builder = this;
            boolean bl = false;
            for (String pathSegment : pathSegments) {
                $this$addPathSegments_u24lambda_u243.pathSegments.add(pathSegment);
            }
            return builder;
        }

        @NotNull
        public final Builder putQueryParam(@NotNull String name, @NotNull String value) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Builder $this$putQueryParam_u24lambda_u244 = builder = this;
            boolean bl = false;
            $this$putQueryParam_u24lambda_u244.queryParams.replaceValues((Object)name, (Iterable)CollectionsKt.listOf((Object)value));
            return builder;
        }

        @NotNull
        public final Builder putQueryParams(@NotNull String name, @NotNull Iterable<String> values) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(values, (String)"values");
            Builder $this$putQueryParams_u24lambda_u245 = builder = this;
            boolean bl = false;
            $this$putQueryParams_u24lambda_u245.queryParams.replaceValues((Object)name, values);
            return builder;
        }

        @NotNull
        public final Builder putAllQueryParams(@NotNull Map<String, ? extends Iterable<String>> queryParams) {
            Builder builder;
            Intrinsics.checkNotNullParameter(queryParams, (String)"queryParams");
            Builder $this$putAllQueryParams_u24lambda_u247 = builder = this;
            boolean bl = false;
            queryParams.forEach((arg_0, arg_1) -> Builder.putAllQueryParams$lambda$7$lambda$6((Function2)new Function2<String, Iterable<? extends String>, Unit>((Object)$this$putAllQueryParams_u24lambda_u247){

                public final void invoke(@NotNull String p0, @NotNull Iterable<String> p1) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    Intrinsics.checkNotNullParameter(p1, (String)"p1");
                    ((Builder)putAllQueryParams.1.1.access$getReceiver$p(this)).putQueryParams(p0, p1);
                }

                public static final /* synthetic */ Object access$getReceiver$p(putAllQueryParams.1.1 $this) {
                    return $this.receiver;
                }
            }, arg_0, arg_1));
            return builder;
        }

        @NotNull
        public final Builder putAllQueryParams(@NotNull Multimap<String, String> queryParams) {
            Builder builder;
            Intrinsics.checkNotNullParameter(queryParams, (String)"queryParams");
            Builder $this$putAllQueryParams_u24lambda_u2410 = builder = this;
            boolean bl = false;
            queryParams.asMap().forEach((arg_0, arg_1) -> Builder.putAllQueryParams$lambda$10$lambda$9((Function2)new Function2<String, Iterable<? extends String>, Unit>((Object)$this$putAllQueryParams_u24lambda_u2410){

                public final void invoke(@NotNull String p0, @NotNull Iterable<String> p1) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    Intrinsics.checkNotNullParameter(p1, (String)"p1");
                    ((Builder)putAllQueryParams.2.1.access$getReceiver$p(this)).putQueryParams(p0, p1);
                }

                public static final /* synthetic */ Object access$getReceiver$p(putAllQueryParams.2.1 $this) {
                    return $this.receiver;
                }
            }, arg_0, arg_1));
            return builder;
        }

        @NotNull
        public final Builder putHeader(@NotNull String name, @NotNull String value) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Builder $this$putHeader_u24lambda_u2411 = builder = this;
            boolean bl = false;
            $this$putHeader_u24lambda_u2411.headers.replaceValues((Object)name, (Iterable)CollectionsKt.listOf((Object)value));
            return builder;
        }

        @NotNull
        public final Builder putHeaders(@NotNull String name, @NotNull Iterable<String> values) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(values, (String)"values");
            Builder $this$putHeaders_u24lambda_u2412 = builder = this;
            boolean bl = false;
            $this$putHeaders_u24lambda_u2412.headers.replaceValues((Object)name, values);
            return builder;
        }

        @NotNull
        public final Builder putAllHeaders(@NotNull Map<String, ? extends Iterable<String>> headers) {
            Builder builder;
            Intrinsics.checkNotNullParameter(headers, (String)"headers");
            Builder $this$putAllHeaders_u24lambda_u2414 = builder = this;
            boolean bl = false;
            headers.forEach((arg_0, arg_1) -> Builder.putAllHeaders$lambda$14$lambda$13((Function2)new Function2<String, Iterable<? extends String>, Unit>((Object)$this$putAllHeaders_u24lambda_u2414){

                public final void invoke(@NotNull String p0, @NotNull Iterable<String> p1) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    Intrinsics.checkNotNullParameter(p1, (String)"p1");
                    ((Builder)putAllHeaders.1.1.access$getReceiver$p(this)).putHeaders(p0, p1);
                }

                public static final /* synthetic */ Object access$getReceiver$p(putAllHeaders.1.1 $this) {
                    return $this.receiver;
                }
            }, arg_0, arg_1));
            return builder;
        }

        @NotNull
        public final Builder putAllHeaders(@NotNull Multimap<String, String> headers) {
            Builder builder;
            Intrinsics.checkNotNullParameter(headers, (String)"headers");
            Builder $this$putAllHeaders_u24lambda_u2417 = builder = this;
            boolean bl = false;
            headers.asMap().forEach((arg_0, arg_1) -> Builder.putAllHeaders$lambda$17$lambda$16((Function2)new Function2<String, Iterable<? extends String>, Unit>((Object)$this$putAllHeaders_u24lambda_u2417){

                public final void invoke(@NotNull String p0, @NotNull Iterable<String> p1) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    Intrinsics.checkNotNullParameter(p1, (String)"p1");
                    ((Builder)putAllHeaders.2.1.access$getReceiver$p(this)).putHeaders(p0, p1);
                }

                public static final /* synthetic */ Object access$getReceiver$p(putAllHeaders.2.1 $this) {
                    return $this.receiver;
                }
            }, arg_0, arg_1));
            return builder;
        }

        @NotNull
        public final Builder body(@NotNull HttpRequestBody body) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)body, (String)"body");
            Builder $this$body_u24lambda_u2418 = builder = this;
            boolean bl = false;
            $this$body_u24lambda_u2418.body = body;
            return builder;
        }

        @NotNull
        public final HttpRequest build() {
            HttpMethod httpMethod = this.method;
            if (httpMethod == null) {
                boolean bl = false;
                String string = "`method` is required but was not set";
                throw new IllegalStateException(string.toString());
            }
            DefaultConstructorMarker defaultConstructorMarker = null;
            HttpRequestBody httpRequestBody = this.body;
            ListMultimap<String, String> listMultimap = this.headers;
            ListMultimap listMultimap2 = Utils.toUnmodifiable(this.queryParams);
            List list2 = Utils.toUnmodifiable(this.pathSegments);
            String string = this.url;
            HttpMethod httpMethod2 = httpMethod;
            return new HttpRequest(httpMethod2, string, list2, listMultimap2, listMultimap, httpRequestBody, defaultConstructorMarker);
        }

        private static final void putAllQueryParams$lambda$7$lambda$6(Function2 $tmp0, Object p0, Object p1) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            $tmp0.invoke(p0, p1);
        }

        private static final void putAllQueryParams$lambda$10$lambda$9(Function2 $tmp0, Object p0, Object p1) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            $tmp0.invoke(p0, p1);
        }

        private static final void putAllHeaders$lambda$14$lambda$13(Function2 $tmp0, Object p0, Object p1) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            $tmp0.invoke(p0, p1);
        }

        private static final void putAllHeaders$lambda$17$lambda$16(Function2 $tmp0, Object p0, Object p1) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            $tmp0.invoke(p0, p1);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007\u00a8\u0006\u0005"}, d2={"Lcom/tryfinch/api/core/http/HttpRequest$Companion;", "", "()V", "builder", "Lcom/tryfinch/api/core/http/HttpRequest$Builder;", "finch-java-core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Builder builder() {
            return new Builder();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

