/*
 * Decompiled with CFR 0.152.
 */
package com.tryfinch.api.services.blocking;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.collect.ListMultimap;
import com.tryfinch.api.core.ClientOptions;
import com.tryfinch.api.core.JsonValue;
import com.tryfinch.api.core.http.HttpResponse;
import com.tryfinch.api.errors.FinchError;
import com.tryfinch.api.errors.FinchException;
import com.tryfinch.api.services.Handlers;
import com.tryfinch.api.services.blocking.WebhookService;
import java.security.MessageDigest;
import java.time.Duration;
import java.time.Instant;
import java.util.Base64;
import java.util.List;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J.\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000bH\u0016J.\u0010\u000f\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u000b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/tryfinch/api/services/blocking/WebhookServiceImpl;", "Lcom/tryfinch/api/services/blocking/WebhookService;", "clientOptions", "Lcom/tryfinch/api/core/ClientOptions;", "(Lcom/tryfinch/api/core/ClientOptions;)V", "errorHandler", "Lcom/tryfinch/api/core/http/HttpResponse$Handler;", "Lcom/tryfinch/api/errors/FinchError;", "unwrap", "Lcom/tryfinch/api/core/JsonValue;", "payload", "", "headers", "Lcom/google/common/collect/ListMultimap;", "secret", "verifySignature", "", "finch-java-core"})
@SourceDebugExtension(value={"SMAP\nWebhookServiceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebhookServiceImpl.kt\ncom/tryfinch/api/services/blocking/WebhookServiceImpl\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,105:1\n1295#2,2:106\n*S KotlinDebug\n*F\n+ 1 WebhookServiceImpl.kt\ncom/tryfinch/api/services/blocking/WebhookServiceImpl\n*L\n87#1:106,2\n*E\n"})
public final class WebhookServiceImpl
implements WebhookService {
    @NotNull
    private final ClientOptions clientOptions;
    @NotNull
    private final HttpResponse.Handler<FinchError> errorHandler;

    public WebhookServiceImpl(@NotNull ClientOptions clientOptions) {
        Intrinsics.checkNotNullParameter((Object)clientOptions, (String)"clientOptions");
        this.clientOptions = clientOptions;
        this.errorHandler = Handlers.errorHandler(this.clientOptions.jsonMapper());
    }

    @Override
    @NotNull
    public JsonValue unwrap(@NotNull String payload, @NotNull ListMultimap<String, String> headers, @Nullable String secret) {
        JsonValue jsonValue;
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        this.verifySignature(payload, headers, secret);
        try {
            Object object = this.clientOptions.jsonMapper().readValue(payload, JsonValue.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"{\n            clientOpti\u2026ue::class.java)\n        }");
            jsonValue = (JsonValue)object;
        }
        catch (JsonProcessingException e) {
            throw new FinchException("Invalid event payload", e);
        }
        return jsonValue;
    }

    @Override
    public void verifySignature(@NotNull String payload, @NotNull ListMultimap<String, String> headers, @Nullable String secret) {
        Instant instant;
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        String string = secret;
        if (string == null && (string = this.clientOptions.webhookSecret()) == null) {
            throw new FinchException("The webhook secret must either be set using the env var, FINCH_WEBHOOK_SECRET, on the client class, or passed to this method", null, 2, null);
        }
        String webhookSecret = string;
        try {
            byArray = Base64.getDecoder().decode(webhookSecret);
        }
        catch (RuntimeException e) {
            throw new FinchException("Invalid webhook secret", null, 2, null);
        }
        byte[] parsedSecret = byArray;
        List list2 = headers.get((Object)"finch-event-id");
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"headers.get(\"finch-event-id\")");
        String string2 = (String)CollectionsKt.getOrNull((List)list2, (int)0);
        if (string2 == null) {
            throw new FinchException("Could not find finch-event-id header", null, 2, null);
        }
        String eventId = string2;
        List list3 = headers.get((Object)"finch-signature");
        Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"headers.get(\"finch-signature\")");
        String string3 = (String)CollectionsKt.getOrNull((List)list3, (int)0);
        if (string3 == null) {
            throw new FinchException("Could not find finch-signature header", null, 2, null);
        }
        String msgSignture = string3;
        List list4 = headers.get((Object)"finch-timestamp");
        Intrinsics.checkNotNullExpressionValue((Object)list4, (String)"headers.get(\"finch-timestamp\")");
        String string4 = (String)CollectionsKt.getOrNull((List)list4, (int)0);
        if (string4 == null) {
            throw new FinchException("Could not find finch-timestamp header", null, 2, null);
        }
        String msgTimestamp = string4;
        try {
            instant = Instant.ofEpochSecond(Long.parseLong(msgTimestamp));
        }
        catch (RuntimeException e) {
            throw new FinchException("Invalid timestamp header: " + msgTimestamp, e);
        }
        Instant timestamp = instant;
        Instant now = Instant.now(this.clientOptions.clock());
        if (timestamp.isBefore(now.minus(Duration.ofMinutes(5L)))) {
            throw new FinchException("Webhook timestamp too old", null, 2, null);
        }
        if (timestamp.isAfter(now.plus(Duration.ofMinutes(5L)))) {
            throw new FinchException("Webhook timestamp too new", null, 2, null);
        }
        Mac mac = Mac.getInstance("HmacSHA256");
        mac.init(new SecretKeySpec(parsedSecret, "HmacSHA256"));
        String[] stringArray = eventId + '.' + timestamp.getEpochSecond() + '.' + payload;
        byte[] byArray2 = stringArray.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"this as java.lang.String).getBytes(charset)");
        byte[] expectedSignature = mac.doFinal(byArray2);
        stringArray = new String[]{" "};
        Sequence $this$forEach$iv = StringsKt.splitToSequence$default((CharSequence)msgSignture, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            String[] stringArray2 = new String[]{","};
            List parts = StringsKt.split$default((CharSequence)it, (String[])stringArray2, (boolean)false, (int)0, (int)6, null);
            if (parts.size() != 2 || !Intrinsics.areEqual(parts.get(0), (Object)"v1") || !MessageDigest.isEqual(Base64.getDecoder().decode((String)parts.get(1)), expectedSignature)) continue;
            return;
        }
        throw new FinchException("None of the given webhook signatures match the expected signature", null, 2, null);
    }
}

