/*
 * Decompiled with CFR 0.152.
 */
package com.tryfinch.api.client;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.tryfinch.api.client.FinchClient;
import com.tryfinch.api.client.FinchClientAsync;
import com.tryfinch.api.client.FinchClientImpl;
import com.tryfinch.api.core.ClientOptions;
import com.tryfinch.api.core.http.HttpClient;
import com.tryfinch.api.core.http.HttpMethod;
import com.tryfinch.api.core.http.HttpRequest;
import com.tryfinch.api.core.http.HttpRequestBody;
import com.tryfinch.api.core.http.HttpResponse;
import com.tryfinch.api.errors.FinchError;
import com.tryfinch.api.errors.FinchException;
import com.tryfinch.api.services.Handlers;
import com.tryfinch.api.services.async.AccountServiceAsync;
import com.tryfinch.api.services.async.AccountServiceAsyncImpl;
import com.tryfinch.api.services.async.HrisServiceAsync;
import com.tryfinch.api.services.async.HrisServiceAsyncImpl;
import com.tryfinch.api.services.async.ProviderServiceAsync;
import com.tryfinch.api.services.async.ProviderServiceAsyncImpl;
import com.tryfinch.api.services.async.WebhookServiceAsync;
import com.tryfinch.api.services.async.WebhookServiceAsyncImpl;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002/0B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J.\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%2\u0006\u0010'\u001a\u00020&2\u0006\u0010(\u001a\u00020&2\u0006\u0010)\u001a\u00020&2\u0006\u0010*\u001a\u00020&H\u0016J \u0010+\u001a\u00020&2\u0006\u0010,\u001a\u00020&2\u0006\u0010*\u001a\u00020&2\u0006\u0010-\u001a\u00020.H\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001f\u001a\u00020 H\u0016R\u001b\u0010\u0005\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0010\u001a\u00020\u00118BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\n\u001a\u0004\b\u0012\u0010\u0013R\u001b\u0010\u0015\u001a\u00020\u00168BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\n\u001a\u0004\b\u0017\u0010\u0018R\u001b\u0010\u001a\u001a\u00020\u001b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001e\u0010\n\u001a\u0004\b\u001c\u0010\u001dR\u001b\u0010\u001f\u001a\u00020 8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b#\u0010\n\u001a\u0004\b!\u0010\"\u00a8\u00061"}, d2={"Lcom/tryfinch/api/client/FinchClientAsyncImpl;", "Lcom/tryfinch/api/client/FinchClientAsync;", "clientOptions", "Lcom/tryfinch/api/core/ClientOptions;", "(Lcom/tryfinch/api/core/ClientOptions;)V", "account", "Lcom/tryfinch/api/services/async/AccountServiceAsync;", "getAccount", "()Lcom/tryfinch/api/services/async/AccountServiceAsync;", "account$delegate", "Lkotlin/Lazy;", "errorHandler", "Lcom/tryfinch/api/core/http/HttpResponse$Handler;", "Lcom/tryfinch/api/errors/FinchError;", "getAccessTokenHandler", "Lcom/tryfinch/api/client/FinchClientAsyncImpl$GetAccessTokenResponse;", "hris", "Lcom/tryfinch/api/services/async/HrisServiceAsync;", "getHris", "()Lcom/tryfinch/api/services/async/HrisServiceAsync;", "hris$delegate", "providers", "Lcom/tryfinch/api/services/async/ProviderServiceAsync;", "getProviders", "()Lcom/tryfinch/api/services/async/ProviderServiceAsync;", "providers$delegate", "sync", "Lcom/tryfinch/api/client/FinchClient;", "getSync", "()Lcom/tryfinch/api/client/FinchClient;", "sync$delegate", "webhooks", "Lcom/tryfinch/api/services/async/WebhookServiceAsync;", "getWebhooks", "()Lcom/tryfinch/api/services/async/WebhookServiceAsync;", "webhooks$delegate", "getAccessToken", "Ljava/util/concurrent/CompletableFuture;", "", "clientId", "clientSecret", "code", "redirectUri", "getAuthUrl", "products", "sandbox", "", "GetAccessTokenParams", "GetAccessTokenResponse", "finch-java-core"})
@SourceDebugExtension(value={"SMAP\nFinchClientAsyncImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FinchClientAsyncImpl.kt\ncom/tryfinch/api/client/FinchClientAsyncImpl\n+ 2 Handlers.kt\ncom/tryfinch/api/services/Handlers\n+ 3 HttpRequestBodies.kt\ncom/tryfinch/api/services/HttpRequestBodies\n*L\n1#1,104:1\n36#2:105\n16#3:106\n*S KotlinDebug\n*F\n+ 1 FinchClientAsyncImpl.kt\ncom/tryfinch/api/client/FinchClientAsyncImpl\n*L\n37#1:105\n66#1:106\n*E\n"})
public final class FinchClientAsyncImpl
implements FinchClientAsync {
    @NotNull
    private final ClientOptions clientOptions;
    @NotNull
    private final HttpResponse.Handler<FinchError> errorHandler;
    @NotNull
    private final Lazy sync$delegate;
    @NotNull
    private final Lazy hris$delegate;
    @NotNull
    private final Lazy providers$delegate;
    @NotNull
    private final Lazy account$delegate;
    @NotNull
    private final Lazy webhooks$delegate;
    @NotNull
    private final HttpResponse.Handler<GetAccessTokenResponse> getAccessTokenHandler;

    public FinchClientAsyncImpl(@NotNull ClientOptions clientOptions) {
        Intrinsics.checkNotNullParameter((Object)clientOptions, (String)"clientOptions");
        this.clientOptions = clientOptions;
        this.errorHandler = Handlers.errorHandler(this.clientOptions.jsonMapper());
        this.sync$delegate = LazyKt.lazy((Function0)((Function0)new Function0<FinchClientImpl>(this){
            final /* synthetic */ FinchClientAsyncImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final FinchClientImpl invoke() {
                return new FinchClientImpl(FinchClientAsyncImpl.access$getClientOptions$p(this.this$0));
            }
        }));
        this.hris$delegate = LazyKt.lazy((Function0)((Function0)new Function0<HrisServiceAsyncImpl>(this){
            final /* synthetic */ FinchClientAsyncImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final HrisServiceAsyncImpl invoke() {
                return new HrisServiceAsyncImpl(FinchClientAsyncImpl.access$getClientOptions$p(this.this$0));
            }
        }));
        this.providers$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ProviderServiceAsyncImpl>(this){
            final /* synthetic */ FinchClientAsyncImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final ProviderServiceAsyncImpl invoke() {
                return new ProviderServiceAsyncImpl(FinchClientAsyncImpl.access$getClientOptions$p(this.this$0));
            }
        }));
        this.account$delegate = LazyKt.lazy((Function0)((Function0)new Function0<AccountServiceAsyncImpl>(this){
            final /* synthetic */ FinchClientAsyncImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final AccountServiceAsyncImpl invoke() {
                return new AccountServiceAsyncImpl(FinchClientAsyncImpl.access$getClientOptions$p(this.this$0));
            }
        }));
        this.webhooks$delegate = LazyKt.lazy((Function0)((Function0)new Function0<WebhookServiceAsyncImpl>(this){
            final /* synthetic */ FinchClientAsyncImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final WebhookServiceAsyncImpl invoke() {
                return new WebhookServiceAsyncImpl(FinchClientAsyncImpl.access$getClientOptions$p(this.this$0));
            }
        }));
        JsonMapper jsonMapper$iv = this.clientOptions.jsonMapper();
        boolean $i$f$jsonHandler = false;
        this.getAccessTokenHandler = Handlers.withErrorHandler(new HttpResponse.Handler<GetAccessTokenResponse>(jsonMapper$iv){
            final /* synthetic */ JsonMapper $jsonMapper;
            {
                this.$jsonMapper = $jsonMapper;
            }

            public GetAccessTokenResponse handle(@NotNull HttpResponse response) {
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                try {
                    boolean $i$f$jacksonTypeRef = false;
                    return this.$jsonMapper.readValue(response.body(), (TypeReference)new TypeReference<GetAccessTokenResponse>(){});
                }
                catch (Exception e) {
                    throw new FinchException("Error reading response", e);
                }
            }
        }, this.errorHandler);
    }

    private final FinchClient getSync() {
        Lazy lazy = this.sync$delegate;
        return (FinchClient)lazy.getValue();
    }

    private final HrisServiceAsync getHris() {
        Lazy lazy = this.hris$delegate;
        return (HrisServiceAsync)lazy.getValue();
    }

    private final ProviderServiceAsync getProviders() {
        Lazy lazy = this.providers$delegate;
        return (ProviderServiceAsync)lazy.getValue();
    }

    private final AccountServiceAsync getAccount() {
        Lazy lazy = this.account$delegate;
        return (AccountServiceAsync)lazy.getValue();
    }

    private final WebhookServiceAsync getWebhooks() {
        Lazy lazy = this.webhooks$delegate;
        return (WebhookServiceAsync)lazy.getValue();
    }

    @Override
    @NotNull
    public FinchClient sync() {
        return this.getSync();
    }

    @Override
    @NotNull
    public HrisServiceAsync hris() {
        return this.getHris();
    }

    @Override
    @NotNull
    public ProviderServiceAsync providers() {
        return this.getProviders();
    }

    @Override
    @NotNull
    public AccountServiceAsync account() {
        return this.getAccount();
    }

    @Override
    @NotNull
    public WebhookServiceAsync webhooks() {
        return this.getWebhooks();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CompletableFuture<String> getAccessToken(@NotNull String clientId, @NotNull String clientSecret, @NotNull String code, @NotNull String redirectUri) {
        void value$iv;
        void jsonMapper$iv;
        Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
        Intrinsics.checkNotNullParameter((Object)clientSecret, (String)"clientSecret");
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        Intrinsics.checkNotNullParameter((Object)redirectUri, (String)"redirectUri");
        if (this.clientOptions.clientId() == null) {
            throw new FinchException("clientId must be set in order to call getAccessToken", null, 2, null);
        }
        if (this.clientOptions.clientSecret() == null) {
            throw new FinchException("clientSecret must be set in order to call getAccessToken", null, 2, null);
        }
        String[] stringArray = new String[]{"auth", "token"};
        HttpRequest.Builder builder = HttpRequest.Companion.builder().method(HttpMethod.POST).addPathSegments(stringArray);
        stringArray = this.clientOptions.jsonMapper();
        GetAccessTokenParams getAccessTokenParams = new GetAccessTokenParams(clientId, clientSecret, code, redirectUri);
        boolean $i$f$json = false;
        HttpRequest request2 = builder.body(new HttpRequestBody((JsonMapper)jsonMapper$iv, value$iv){
            final /* synthetic */ JsonMapper $jsonMapper;
            final /* synthetic */ T $value;
            {
                this.$jsonMapper = $jsonMapper;
                this.$value = $value;
            }

            public void writeTo(@NotNull OutputStream outputStream) {
                Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
                try {
                    this.$jsonMapper.writeValue(outputStream, this.$value);
                    return;
                }
                catch (Exception e) {
                    throw new FinchException("Error writing request", e);
                }
            }

            @NotNull
            public String contentType() {
                return "application/json";
            }

            public boolean repeatable() {
                return true;
            }

            public void close() {
            }
        }).build();
        CompletionStage completionStage = HttpClient.executeAsync$default(this.clientOptions.httpClient(), request2, null, 2, null).thenApply(arg_0 -> FinchClientAsyncImpl.getAccessToken$lambda$0((Function1)new Function1<HttpResponse, String>(this){
            final /* synthetic */ FinchClientAsyncImpl this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final String invoke(HttpResponse it) {
                HttpResponse.Handler handler = FinchClientAsyncImpl.access$getGetAccessTokenHandler$p(this.this$0);
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                return ((GetAccessTokenResponse)handler.handle(it)).getAccessToken();
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"override fun getAccessTo\u2026cessToken\n        }\n    }");
        return completionStage;
    }

    @Override
    @NotNull
    public String getAuthUrl(@NotNull String products, @NotNull String redirectUri, boolean sandbox) {
        Intrinsics.checkNotNullParameter((Object)products, (String)"products");
        Intrinsics.checkNotNullParameter((Object)redirectUri, (String)"redirectUri");
        if (this.clientOptions.clientId() == null) {
            throw new FinchException("Expected the clientId to be set in order to call getAuthUrl", null, 2, null);
        }
        return "https://connect.tryfinch.com/authorize?client_id=" + URLEncoder.encode(this.clientOptions.clientId(), Charsets.UTF_8.name()) + "&products=" + URLEncoder.encode(products, Charsets.UTF_8.name()) + "&redirect_uri=" + URLEncoder.encode(redirectUri, Charsets.UTF_8.name()) + "&sandbox=" + (sandbox ? "true" : "false");
    }

    private static final String getAccessToken$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (String)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ HttpResponse.Handler access$getGetAccessTokenHandler$p(FinchClientAsyncImpl $this) {
        return $this.getAccessTokenHandler;
    }

    public static final /* synthetic */ ClientOptions access$getClientOptions$p(FinchClientAsyncImpl $this) {
        return $this.clientOptions;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B-\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J1\u0010\u0011\u001a\u00020\u00002\b\b\u0003\u0010\u0002\u001a\u00020\u00032\b\b\u0003\u0010\u0004\u001a\u00020\u00032\b\b\u0003\u0010\u0005\u001a\u00020\u00032\b\b\u0003\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\u0018"}, d2={"Lcom/tryfinch/api/client/FinchClientAsyncImpl$GetAccessTokenParams;", "", "clientId", "", "clientSecret", "code", "redirectUri", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getClientId", "()Ljava/lang/String;", "getClientSecret", "getCode", "getRedirectUri", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "finch-java-core"})
    private static final class GetAccessTokenParams {
        @NotNull
        private final String clientId;
        @NotNull
        private final String clientSecret;
        @NotNull
        private final String code;
        @NotNull
        private final String redirectUri;

        public GetAccessTokenParams(@JsonProperty(value="client_id") @NotNull String clientId, @JsonProperty(value="client_secret") @NotNull String clientSecret, @JsonProperty(value="code") @NotNull String code, @JsonProperty(value="redirect_uri") @NotNull String redirectUri) {
            Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
            Intrinsics.checkNotNullParameter((Object)clientSecret, (String)"clientSecret");
            Intrinsics.checkNotNullParameter((Object)code, (String)"code");
            Intrinsics.checkNotNullParameter((Object)redirectUri, (String)"redirectUri");
            this.clientId = clientId;
            this.clientSecret = clientSecret;
            this.code = code;
            this.redirectUri = redirectUri;
        }

        @NotNull
        public final String getClientId() {
            return this.clientId;
        }

        @NotNull
        public final String getClientSecret() {
            return this.clientSecret;
        }

        @NotNull
        public final String getCode() {
            return this.code;
        }

        @NotNull
        public final String getRedirectUri() {
            return this.redirectUri;
        }

        @NotNull
        public final String component1() {
            return this.clientId;
        }

        @NotNull
        public final String component2() {
            return this.clientSecret;
        }

        @NotNull
        public final String component3() {
            return this.code;
        }

        @NotNull
        public final String component4() {
            return this.redirectUri;
        }

        @NotNull
        public final GetAccessTokenParams copy(@JsonProperty(value="client_id") @NotNull String clientId, @JsonProperty(value="client_secret") @NotNull String clientSecret, @JsonProperty(value="code") @NotNull String code, @JsonProperty(value="redirect_uri") @NotNull String redirectUri) {
            Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
            Intrinsics.checkNotNullParameter((Object)clientSecret, (String)"clientSecret");
            Intrinsics.checkNotNullParameter((Object)code, (String)"code");
            Intrinsics.checkNotNullParameter((Object)redirectUri, (String)"redirectUri");
            return new GetAccessTokenParams(clientId, clientSecret, code, redirectUri);
        }

        public static /* synthetic */ GetAccessTokenParams copy$default(GetAccessTokenParams getAccessTokenParams, String string, String string2, String string3, String string4, int n, Object object) {
            if ((n & 1) != 0) {
                string = getAccessTokenParams.clientId;
            }
            if ((n & 2) != 0) {
                string2 = getAccessTokenParams.clientSecret;
            }
            if ((n & 4) != 0) {
                string3 = getAccessTokenParams.code;
            }
            if ((n & 8) != 0) {
                string4 = getAccessTokenParams.redirectUri;
            }
            return getAccessTokenParams.copy(string, string2, string3, string4);
        }

        @NotNull
        public String toString() {
            return "GetAccessTokenParams(clientId=" + this.clientId + ", clientSecret=" + this.clientSecret + ", code=" + this.code + ", redirectUri=" + this.redirectUri + ')';
        }

        public int hashCode() {
            int result = this.clientId.hashCode();
            result = result * 31 + this.clientSecret.hashCode();
            result = result * 31 + this.code.hashCode();
            result = result * 31 + this.redirectUri.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof GetAccessTokenParams)) {
                return false;
            }
            GetAccessTokenParams getAccessTokenParams = (GetAccessTokenParams)other;
            if (!Intrinsics.areEqual((Object)this.clientId, (Object)getAccessTokenParams.clientId)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.clientSecret, (Object)getAccessTokenParams.clientSecret)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.code, (Object)getAccessTokenParams.code)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.redirectUri, (Object)getAccessTokenParams.redirectUri);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0003\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\f\u001a\u00020\rH\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lcom/tryfinch/api/client/FinchClientAsyncImpl$GetAccessTokenResponse;", "", "accessToken", "", "(Ljava/lang/String;)V", "getAccessToken", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "finch-java-core"})
    private static final class GetAccessTokenResponse {
        @NotNull
        private final String accessToken;

        public GetAccessTokenResponse(@JsonProperty(value="accessToken") @NotNull String accessToken) {
            Intrinsics.checkNotNullParameter((Object)accessToken, (String)"accessToken");
            this.accessToken = accessToken;
        }

        @NotNull
        public final String getAccessToken() {
            return this.accessToken;
        }

        @NotNull
        public final String component1() {
            return this.accessToken;
        }

        @NotNull
        public final GetAccessTokenResponse copy(@JsonProperty(value="accessToken") @NotNull String accessToken) {
            Intrinsics.checkNotNullParameter((Object)accessToken, (String)"accessToken");
            return new GetAccessTokenResponse(accessToken);
        }

        public static /* synthetic */ GetAccessTokenResponse copy$default(GetAccessTokenResponse getAccessTokenResponse, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = getAccessTokenResponse.accessToken;
            }
            return getAccessTokenResponse.copy(string);
        }

        @NotNull
        public String toString() {
            return "GetAccessTokenResponse(accessToken=" + this.accessToken + ')';
        }

        public int hashCode() {
            return this.accessToken.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof GetAccessTokenResponse)) {
                return false;
            }
            GetAccessTokenResponse getAccessTokenResponse = (GetAccessTokenResponse)other;
            return Intrinsics.areEqual((Object)this.accessToken, (Object)getAccessTokenResponse.accessToken);
        }
    }
}

