/*
 * Decompiled with CFR 0.152.
 */
package com.tryfinch.api.core;

import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.tryfinch.api.core.BaseDeserializer;
import com.tryfinch.api.core.JsonArray;
import com.tryfinch.api.core.JsonBoolean;
import com.tryfinch.api.core.JsonField;
import com.tryfinch.api.core.JsonMissing;
import com.tryfinch.api.core.JsonNull;
import com.tryfinch.api.core.JsonNumber;
import com.tryfinch.api.core.JsonObject;
import com.tryfinch.api.core.JsonString;
import com.tryfinch.api.core.JsonValue;
import com.tryfinch.api.core.ObjectMappers;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@JsonDeserialize(using=Deserializer.class)
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b7\u0018\u0000 \u00102\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0003\u0010\u0011\u0012B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0003J\u001f\u0010\u0004\u001a\u0002H\u0005\"\u0004\b\u0000\u0010\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0007\u00a2\u0006\u0002\u0010\bJ%\u0010\t\u001a\u0004\u0018\u0001H\u0005\"\b\b\u0000\u0010\u0005*\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\u00050\f\u00a2\u0006\u0002\u0010\rJ%\u0010\t\u001a\u0004\u0018\u0001H\u0005\"\b\b\u0000\u0010\u0005*\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\u00050\u000e\u00a2\u0006\u0002\u0010\u000f\u0082\u0001\u0007\u0013\u0014\u0015\u0016\u0017\u0018\u0019\u00a8\u0006\u001a"}, d2={"Lcom/tryfinch/api/core/JsonValue;", "Lcom/tryfinch/api/core/JsonField;", "", "()V", "accept", "R", "visitor", "Lcom/tryfinch/api/core/JsonValue$Visitor;", "(Lcom/tryfinch/api/core/JsonValue$Visitor;)Ljava/lang/Object;", "convert", "", "type", "Lcom/fasterxml/jackson/core/type/TypeReference;", "(Lcom/fasterxml/jackson/core/type/TypeReference;)Ljava/lang/Object;", "Ljava/lang/Class;", "(Ljava/lang/Class;)Ljava/lang/Object;", "Companion", "Deserializer", "Visitor", "Lcom/tryfinch/api/core/JsonArray;", "Lcom/tryfinch/api/core/JsonBoolean;", "Lcom/tryfinch/api/core/JsonMissing;", "Lcom/tryfinch/api/core/JsonNull;", "Lcom/tryfinch/api/core/JsonNumber;", "Lcom/tryfinch/api/core/JsonObject;", "Lcom/tryfinch/api/core/JsonString;", "finch-java-core"})
public abstract class JsonValue
extends JsonField {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final JsonMapper JSON_MAPPER = ObjectMappers.jsonMapper();

    private JsonValue() {
        super(null);
    }

    @Nullable
    public final <R> R convert(@NotNull TypeReference<R> type) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        return (R)JSON_MAPPER.convertValue((Object)this, type);
    }

    @Nullable
    public final <R> R convert(@NotNull Class<R> type) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        return (R)JSON_MAPPER.convertValue((Object)this, type);
    }

    public final <R> R accept(@NotNull Visitor<? extends R> visitor) {
        R r;
        Intrinsics.checkNotNullParameter(visitor, (String)"visitor");
        JsonValue jsonValue = this;
        if (jsonValue instanceof JsonMissing) {
            r = visitor.visitMissing();
        } else if (jsonValue instanceof JsonNull) {
            r = visitor.visitNull();
        } else if (jsonValue instanceof JsonBoolean) {
            r = visitor.visitBoolean(((JsonBoolean)this).value());
        } else if (jsonValue instanceof JsonNumber) {
            r = visitor.visitNumber(((JsonNumber)this).value());
        } else if (jsonValue instanceof JsonString) {
            r = visitor.visitString(((JsonString)this).value());
        } else if (jsonValue instanceof JsonArray) {
            r = visitor.visitArray(((JsonArray)this).values());
        } else if (jsonValue instanceof JsonObject) {
            r = visitor.visitObject(((JsonObject)this).values());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return r;
    }

    @JvmStatic
    @NotNull
    public static final JsonValue from(@Nullable Object value2) {
        return Companion.from(value2);
    }

    @JvmStatic
    @NotNull
    public static final JsonValue fromJsonNode(@NotNull JsonNode node) {
        return Companion.fromJsonNode(node);
    }

    public /* synthetic */ JsonValue(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u0001H\u0007J\u0010\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/tryfinch/api/core/JsonValue$Companion;", "", "()V", "JSON_MAPPER", "Lcom/fasterxml/jackson/databind/json/JsonMapper;", "from", "Lcom/tryfinch/api/core/JsonValue;", "value", "fromJsonNode", "node", "Lcom/fasterxml/jackson/databind/JsonNode;", "finch-java-core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final JsonValue from(@Nullable Object value2) {
            JsonValue jsonValue;
            Object object = value2;
            if (object == null) {
                jsonValue = JsonNull.Companion.of();
            } else if (object instanceof JsonValue) {
                jsonValue = (JsonValue)value2;
            } else {
                Object object2 = JSON_MAPPER.convertValue(value2, JsonValue.class);
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"JSON_MAPPER.convertValue\u2026e, JsonValue::class.java)");
                jsonValue = (JsonValue)object2;
            }
            return jsonValue;
        }

        @JvmStatic
        @NotNull
        public final JsonValue fromJsonNode(@NotNull JsonNode node) {
            JsonValue jsonValue;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            JsonNodeType jsonNodeType = node.getNodeType();
            switch (jsonNodeType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[jsonNodeType.ordinal()]) {
                case 1: {
                    jsonValue = JsonMissing.Companion.of();
                    break;
                }
                case 2: {
                    jsonValue = JsonNull.Companion.of();
                    break;
                }
                case 3: {
                    jsonValue = JsonBoolean.Companion.of(node.booleanValue());
                    break;
                }
                case 4: {
                    Number number = node.numberValue();
                    Intrinsics.checkNotNullExpressionValue((Object)number, (String)"node.numberValue()");
                    jsonValue = JsonNumber.Companion.of(number);
                    break;
                }
                case 5: {
                    String string = node.textValue();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"node.textValue()");
                    jsonValue = JsonString.Companion.of(string);
                    break;
                }
                case 6: {
                    Iterator iterator2 = node.elements();
                    Intrinsics.checkNotNullExpressionValue((Object)iterator2, (String)"node.elements()");
                    jsonValue = JsonArray.Companion.of(SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.asSequence((Iterator)iterator2), (Function1)fromJsonNode.1.INSTANCE)));
                    break;
                }
                case 7: {
                    Iterator iterator3 = node.fields();
                    Intrinsics.checkNotNullExpressionValue((Object)iterator3, (String)"node.fields()");
                    jsonValue = JsonObject.Companion.of(MapsKt.toMap((Sequence)SequencesKt.map((Sequence)SequencesKt.asSequence((Iterator)iterator3), (Function1)fromJsonNode.2.INSTANCE)));
                    break;
                }
                case -1: 
                case 8: 
                case 9: {
                    throw new IllegalStateException("Unexpected JsonNode type: " + node.getNodeType());
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return jsonValue;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 8, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[JsonNodeType.values().length];
                try {
                    nArray[JsonNodeType.MISSING.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[JsonNodeType.NULL.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[JsonNodeType.BOOLEAN.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[JsonNodeType.NUMBER.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[JsonNodeType.STRING.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[JsonNodeType.ARRAY.ordinal()] = 6;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[JsonNodeType.OBJECT.ordinal()] = 7;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[JsonNodeType.BINARY.ordinal()] = 8;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[JsonNodeType.POJO.ordinal()] = 9;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u00020\u00022\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016J\u0014\u0010\u0007\u001a\u00020\u0002*\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014\u00a8\u0006\u000b"}, d2={"Lcom/tryfinch/api/core/JsonValue$Deserializer;", "Lcom/tryfinch/api/core/BaseDeserializer;", "Lcom/tryfinch/api/core/JsonValue;", "()V", "getNullValue", "context", "Lcom/fasterxml/jackson/databind/DeserializationContext;", "deserialize", "Lcom/fasterxml/jackson/core/ObjectCodec;", "node", "Lcom/fasterxml/jackson/databind/JsonNode;", "finch-java-core"})
    public static final class Deserializer
    extends BaseDeserializer<JsonValue> {
        public Deserializer() {
            super(Reflection.getOrCreateKotlinClass(JsonValue.class));
        }

        @Override
        @NotNull
        protected JsonValue deserialize(@NotNull ObjectCodec $this$deserialize, @NotNull JsonNode node) {
            Intrinsics.checkNotNullParameter((Object)$this$deserialize, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            return Companion.fromJsonNode(node);
        }

        @NotNull
        public JsonValue getNullValue(@Nullable DeserializationContext context) {
            return JsonNull.Companion.of();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0004\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0004\bf\u0018\u0000*\u0006\b\u0000\u0010\u0001 \u00012\u00020\u0002J\u001b\u0010\u0003\u001a\u00028\u00002\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016\u00a2\u0006\u0002\u0010\u0007J\u0015\u0010\b\u001a\u00028\u00002\u0006\u0010\t\u001a\u00020\nH\u0016\u00a2\u0006\u0002\u0010\u000bJ\r\u0010\f\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\rJ\r\u0010\u000e\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\rJ\r\u0010\u000f\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\rJ\u0015\u0010\u0010\u001a\u00028\u00002\u0006\u0010\t\u001a\u00020\u0011H\u0016\u00a2\u0006\u0002\u0010\u0012J!\u0010\u0013\u001a\u00028\u00002\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00060\u0014H\u0016\u00a2\u0006\u0002\u0010\u0016J\u0015\u0010\u0017\u001a\u00028\u00002\u0006\u0010\t\u001a\u00020\u0015H\u0016\u00a2\u0006\u0002\u0010\u0018\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0019\u00c0\u0006\u0001"}, d2={"Lcom/tryfinch/api/core/JsonValue$Visitor;", "R", "", "visitArray", "values", "", "Lcom/tryfinch/api/core/JsonValue;", "(Ljava/util/List;)Ljava/lang/Object;", "visitBoolean", "value", "", "(Z)Ljava/lang/Object;", "visitDefault", "()Ljava/lang/Object;", "visitMissing", "visitNull", "visitNumber", "", "(Ljava/lang/Number;)Ljava/lang/Object;", "visitObject", "", "", "(Ljava/util/Map;)Ljava/lang/Object;", "visitString", "(Ljava/lang/String;)Ljava/lang/Object;", "finch-java-core"})
    public static interface Visitor<R> {
        default public R visitNull() {
            return this.visitDefault();
        }

        default public R visitMissing() {
            return this.visitDefault();
        }

        default public R visitBoolean(boolean value2) {
            return this.visitDefault();
        }

        default public R visitNumber(@NotNull Number value2) {
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            return this.visitDefault();
        }

        default public R visitString(@NotNull String value2) {
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            return this.visitDefault();
        }

        default public R visitArray(@NotNull List<? extends JsonValue> values) {
            Intrinsics.checkNotNullParameter(values, (String)"values");
            return this.visitDefault();
        }

        default public R visitObject(@NotNull Map<String, ? extends JsonValue> values) {
            Intrinsics.checkNotNullParameter(values, (String)"values");
            return this.visitDefault();
        }

        default public R visitDefault() {
            throw new RuntimeException("Unexpected value");
        }
    }
}

