/*
 * Decompiled with CFR 0.152.
 */
package com.tryfinch.api.core.http;

import com.google.common.util.concurrent.MoreExecutors;
import com.tryfinch.api.core.RequestOptions;
import com.tryfinch.api.core.http.HttpClient;
import com.tryfinch.api.core.http.HttpRequest;
import com.tryfinch.api.core.http.HttpRequestBody;
import com.tryfinch.api.core.http.HttpResponse;
import com.tryfinch.api.core.http.RetryingHttpClient;
import com.tryfinch.api.errors.FinchIoException;
import java.io.IOException;
import java.time.Clock;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 #2\u00020\u0001:\u0002\"#B)\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u001e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\r0\u00132\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u001a\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00062\b\u0010\u0017\u001a\u0004\u0018\u00010\rH\u0002J\b\u0010\u0018\u001a\u00020\bH\u0002J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u0017\u001a\u00020\rH\u0002J\u0010\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0016\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u00132\u0006\u0010!\u001a\u00020\u0015H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/tryfinch/api/core/http/RetryingHttpClient;", "Lcom/tryfinch/api/core/http/HttpClient;", "httpClient", "clock", "Ljava/time/Clock;", "maxRetries", "", "idempotencyHeader", "", "(Lcom/tryfinch/api/core/http/HttpClient;Ljava/time/Clock;ILjava/lang/String;)V", "close", "", "execute", "Lcom/tryfinch/api/core/http/HttpResponse;", "request", "Lcom/tryfinch/api/core/http/HttpRequest;", "requestOptions", "Lcom/tryfinch/api/core/RequestOptions;", "executeAsync", "Ljava/util/concurrent/CompletableFuture;", "getRetryBackoffMillis", "", "retries", "response", "idempotencyKey", "isRetryable", "", "maybeAddIdempotencyHeader", "shouldRetry", "throwable", "", "sleepAsync", "Ljava/lang/Void;", "millis", "Builder", "Companion", "finch-java-core"})
public final class RetryingHttpClient
implements HttpClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final HttpClient httpClient;
    @NotNull
    private final Clock clock;
    private final int maxRetries;
    @Nullable
    private final String idempotencyHeader;
    @NotNull
    private static final Timer TIMER = new Timer("RetryingHttpClient", true);

    private RetryingHttpClient(HttpClient httpClient, Clock clock, int maxRetries, String idempotencyHeader) {
        this.httpClient = httpClient;
        this.clock = clock;
        this.maxRetries = maxRetries;
        this.idempotencyHeader = idempotencyHeader;
    }

    @Override
    @NotNull
    public HttpResponse execute(@NotNull HttpRequest request2, @NotNull RequestOptions requestOptions) {
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        Intrinsics.checkNotNullParameter((Object)requestOptions, (String)"requestOptions");
        if (!this.isRetryable(request2) || this.maxRetries <= 0) {
            return this.httpClient.execute(request2, requestOptions);
        }
        this.maybeAddIdempotencyHeader(request2);
        int retries = 0;
        while (true) {
            HttpResponse response;
            try {
                response = this.httpClient.execute(request2, requestOptions);
                if (++retries > this.maxRetries || !this.shouldRetry(response)) {
                    return response;
                }
            }
            catch (Throwable t) {
                if (++retries > this.maxRetries || !this.shouldRetry(t)) {
                    throw t;
                }
                response = null;
            }
            HttpResponse response2 = response;
            long backoffMillis = this.getRetryBackoffMillis(retries, response2);
            Thread.sleep(backoffMillis);
        }
    }

    @Override
    @NotNull
    public CompletableFuture<HttpResponse> executeAsync(@NotNull HttpRequest request2, @NotNull RequestOptions requestOptions) {
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        Intrinsics.checkNotNullParameter((Object)requestOptions, (String)"requestOptions");
        if (!this.isRetryable(request2) || this.maxRetries <= 0) {
            return this.httpClient.executeAsync(request2, requestOptions);
        }
        this.maybeAddIdempotencyHeader(request2);
        Ref.IntRef retries = new Ref.IntRef();
        return RetryingHttpClient.executeAsync$wrap(retries, this, request2, requestOptions, this.httpClient.executeAsync(request2, requestOptions));
    }

    @Override
    public void close() {
        this.httpClient.close();
    }

    private final boolean isRetryable(HttpRequest request2) {
        HttpRequestBody httpRequestBody = request2.body();
        return httpRequestBody != null ? httpRequestBody.repeatable() : true;
    }

    private final String idempotencyKey() {
        return "stainless-java-retry-" + UUID.randomUUID();
    }

    private final void maybeAddIdempotencyHeader(HttpRequest request2) {
        if (this.idempotencyHeader != null && !request2.headers().containsKey((Object)this.idempotencyHeader)) {
            request2.headers().put((Object)this.idempotencyHeader, (Object)this.idempotencyKey());
        }
    }

    private final boolean shouldRetry(HttpResponse response) {
        List list2 = response.headers().get((Object)"x-should-retry");
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"response.headers().get(\"x-should-retry\")");
        String shouldRetryHeader = (String)CollectionsKt.getOrNull((List)list2, (int)0);
        int statusCode = response.statusCode();
        return Intrinsics.areEqual((Object)shouldRetryHeader, (Object)"true") ? true : (Intrinsics.areEqual((Object)shouldRetryHeader, (Object)"false") ? false : (statusCode == 408 ? true : (statusCode == 409 ? true : (statusCode == 429 ? true : statusCode >= 500))));
    }

    private final boolean shouldRetry(Throwable throwable) {
        return throwable instanceof IOException || throwable instanceof FinchIoException;
    }

    private final long getRetryBackoffMillis(int retries, HttpResponse response) {
        long l;
        IntRange intRange;
        Long retryAfter;
        Long l2;
        Object object = response;
        if (object != null && (object = object.headers()) != null && (object = object.get((Object)"Retry-After")) != null && (object = (String)CollectionsKt.getOrNull(object, (int)0)) != null) {
            Object retryAfter2 = object;
            boolean bl = false;
            l2 = StringsKt.toLongOrNull(retryAfter2);
            if (l2 == null) {
                Long l3;
                try {
                    l3 = ChronoUnit.SECONDS.between(OffsetDateTime.now(this.clock), OffsetDateTime.parse((CharSequence)retryAfter2, DateTimeFormatter.RFC_1123_DATE_TIME));
                }
                catch (DateTimeParseException e) {
                    l3 = null;
                }
                l2 = l3;
            }
        } else {
            l2 = retryAfter = null;
        }
        if (retryAfter != null && RangesKt.intRangeContains((ClosedRange)((ClosedRange)(intRange = new IntRange(1, 60))), (long)(l = retryAfter.longValue()))) {
            return TimeUnit.SECONDS.toMillis(retryAfter);
        }
        double backoffSeconds = Math.min(0.5 * Math.pow(2.0, retries - 1), 8.0);
        double jitter = 1.0 - 0.25 * ThreadLocalRandom.current().nextDouble();
        return (long)((double)TimeUnit.SECONDS.toMillis(1L) * backoffSeconds * jitter);
    }

    private final CompletableFuture<Void> sleepAsync(long millis) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        TIMER.schedule(new TimerTask(future){
            final /* synthetic */ CompletableFuture<Void> $future;
            {
                this.$future = $future;
            }

            public void run() {
                this.$future.complete(null);
            }
        }, millis);
        return future;
    }

    private static final CompletableFuture executeAsync$wrap$lambda$0(Function2 $tmp0, Object p0, Throwable p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (CompletableFuture)$tmp0.invoke(p0, (Object)p1);
    }

    private static final CompletableFuture<HttpResponse> executeAsync$wrap(Ref.IntRef retries, RetryingHttpClient this$0, HttpRequest $request, RequestOptions $requestOptions, CompletableFuture<HttpResponse> future) {
        CompletionStage completionStage = ((CompletableFuture)future.handleAsync((arg_0, arg_1) -> RetryingHttpClient.executeAsync$wrap$lambda$0((Function2)new Function2<HttpResponse, Throwable, CompletableFuture<HttpResponse>>(retries, this$0, $request, $requestOptions){
            final /* synthetic */ Ref.IntRef $retries;
            final /* synthetic */ RetryingHttpClient this$0;
            final /* synthetic */ HttpRequest $request;
            final /* synthetic */ RequestOptions $requestOptions;
            {
                this.$retries = $retries;
                this.this$0 = $receiver;
                this.$request = $request;
                this.$requestOptions = $requestOptions;
                super(2);
            }

            @NotNull
            public final CompletableFuture<HttpResponse> invoke(@Nullable HttpResponse response, @Nullable Throwable throwable) {
                block6: {
                    block7: {
                        block5: {
                            if (response == null) break block5;
                            ++this.$retries.element;
                            if (this.$retries.element > RetryingHttpClient.access$getMaxRetries$p(this.this$0) || !RetryingHttpClient.access$shouldRetry(this.this$0, response)) {
                                CompletableFuture<HttpResponse> completableFuture = CompletableFuture.completedFuture(response);
                                Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(response)");
                                return completableFuture;
                            }
                            break block6;
                        }
                        ++this.$retries.element;
                        if (this.$retries.element > RetryingHttpClient.access$getMaxRetries$p(this.this$0)) break block7;
                        Throwable throwable2 = throwable;
                        Intrinsics.checkNotNull((Object)throwable2);
                        if (RetryingHttpClient.access$shouldRetry(this.this$0, throwable2)) break block6;
                    }
                    CompletableFuture<HttpResponse> failedFuture = new CompletableFuture<HttpResponse>();
                    failedFuture.completeExceptionally(throwable);
                    return failedFuture;
                }
                long backoffMillis = RetryingHttpClient.access$getRetryBackoffMillis(this.this$0, this.$retries.element, response);
                CompletionStage completionStage = RetryingHttpClient.access$sleepAsync(this.this$0, backoffMillis).thenCompose(arg_0 -> executeAsync.wrap.1.invoke$lambda$0((Function1)new Function1<Void, CompletionStage<HttpResponse>>(this.this$0, this.$request, this.$requestOptions, this.$retries){
                    final /* synthetic */ RetryingHttpClient this$0;
                    final /* synthetic */ HttpRequest $request;
                    final /* synthetic */ RequestOptions $requestOptions;
                    final /* synthetic */ Ref.IntRef $retries;
                    {
                        this.this$0 = $receiver;
                        this.$request = $request;
                        this.$requestOptions = $requestOptions;
                        this.$retries = $retries;
                        super(1);
                    }

                    public final CompletionStage<HttpResponse> invoke(Void it) {
                        return RetryingHttpClient.access$executeAsync$wrap(this.$retries, this.this$0, this.$request, this.$requestOptions, RetryingHttpClient.access$getHttpClient$p(this.this$0).executeAsync(this.$request, this.$requestOptions));
                    }
                }, arg_0));
                Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"override fun executeAsyn\u2026t, requestOptions))\n    }");
                return completionStage;
            }

            private static final CompletionStage invoke$lambda$0(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                return (CompletionStage)$tmp0.invoke(p0);
            }
        }, arg_0, arg_1), MoreExecutors.directExecutor())).thenCompose(Function.identity());
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"override fun executeAsyn\u2026t, requestOptions))\n    }");
        return completionStage;
    }

    @JvmStatic
    @NotNull
    public static final Builder builder() {
        return Companion.builder();
    }

    public /* synthetic */ RetryingHttpClient(HttpClient httpClient, Clock clock, int maxRetries, String idempotencyHeader, DefaultConstructorMarker $constructor_marker) {
        this(httpClient, clock, maxRetries, idempotencyHeader);
    }

    public static final /* synthetic */ int access$getMaxRetries$p(RetryingHttpClient $this) {
        return $this.maxRetries;
    }

    public static final /* synthetic */ boolean access$shouldRetry(RetryingHttpClient $this, HttpResponse response) {
        return $this.shouldRetry(response);
    }

    public static final /* synthetic */ boolean access$shouldRetry(RetryingHttpClient $this, Throwable throwable) {
        return $this.shouldRetry(throwable);
    }

    public static final /* synthetic */ long access$getRetryBackoffMillis(RetryingHttpClient $this, int retries, HttpResponse response) {
        return $this.getRetryBackoffMillis(retries, response);
    }

    public static final /* synthetic */ CompletableFuture access$sleepAsync(RetryingHttpClient $this, long millis) {
        return $this.sleepAsync(millis);
    }

    public static final /* synthetic */ CompletableFuture access$executeAsync$wrap(Ref.IntRef retries, RetryingHttpClient this$0, HttpRequest $request, RequestOptions $requestOptions, CompletableFuture future) {
        return RetryingHttpClient.executeAsync$wrap(retries, this$0, $request, $requestOptions, future);
    }

    public static final /* synthetic */ HttpClient access$getHttpClient$p(RetryingHttpClient $this) {
        return $this.httpClient;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u000b\u001a\u00020\u0006J\u000e\u0010\u0003\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0004J\u000e\u0010\u0005\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/tryfinch/api/core/http/RetryingHttpClient$Builder;", "", "()V", "clock", "Ljava/time/Clock;", "httpClient", "Lcom/tryfinch/api/core/http/HttpClient;", "idempotencyHeader", "", "maxRetries", "", "build", "header", "finch-java-core"})
    @SourceDebugExtension(value={"SMAP\nRetryingHttpClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RetryingHttpClient.kt\ncom/tryfinch/api/core/http/RetryingHttpClient$Builder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,233:1\n1#2:234\n*E\n"})
    public static final class Builder {
        @Nullable
        private HttpClient httpClient;
        @NotNull
        private Clock clock;
        private int maxRetries;
        @Nullable
        private String idempotencyHeader;

        public Builder() {
            Clock clock = Clock.systemUTC();
            Intrinsics.checkNotNullExpressionValue((Object)clock, (String)"systemUTC()");
            this.clock = clock;
            this.maxRetries = 2;
        }

        @NotNull
        public final Builder httpClient(@NotNull HttpClient httpClient) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)httpClient, (String)"httpClient");
            Builder $this$httpClient_u24lambda_u240 = builder = this;
            boolean bl = false;
            $this$httpClient_u24lambda_u240.httpClient = httpClient;
            return builder;
        }

        @NotNull
        public final Builder clock(@NotNull Clock clock) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
            Builder $this$clock_u24lambda_u241 = builder = this;
            boolean bl = false;
            $this$clock_u24lambda_u241.clock = clock;
            return builder;
        }

        @NotNull
        public final Builder maxRetries(int maxRetries) {
            Builder builder;
            Builder $this$maxRetries_u24lambda_u242 = builder = this;
            boolean bl = false;
            $this$maxRetries_u24lambda_u242.maxRetries = maxRetries;
            return builder;
        }

        @NotNull
        public final Builder idempotencyHeader(@NotNull String header) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)header, (String)"header");
            Builder $this$idempotencyHeader_u24lambda_u243 = builder = this;
            boolean bl = false;
            $this$idempotencyHeader_u24lambda_u243.idempotencyHeader = header;
            return builder;
        }

        @NotNull
        public final HttpClient build() {
            HttpClient httpClient = this.httpClient;
            if (httpClient == null) {
                boolean bl = false;
                String string = "`httpClient` is required but was not set";
                throw new IllegalStateException(string.toString());
            }
            DefaultConstructorMarker defaultConstructorMarker = null;
            String string = this.idempotencyHeader;
            int n = this.maxRetries;
            Clock clock = this.clock;
            HttpClient httpClient2 = httpClient;
            return new RetryingHttpClient(httpClient2, clock, n, string, defaultConstructorMarker);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0005\u001a\u00020\u0006H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/tryfinch/api/core/http/RetryingHttpClient$Companion;", "", "()V", "TIMER", "Ljava/util/Timer;", "builder", "Lcom/tryfinch/api/core/http/RetryingHttpClient$Builder;", "finch-java-core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Builder builder() {
            return new Builder();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

