/*
 * Decompiled with CFR 0.152.
 */
package com.tryfinch.api.services.blocking;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.google.common.collect.Multimap;
import com.tryfinch.api.core.ClientOptions;
import com.tryfinch.api.core.JsonValue;
import com.tryfinch.api.core.RequestOptions;
import com.tryfinch.api.core.http.HttpMethod;
import com.tryfinch.api.core.http.HttpRequest;
import com.tryfinch.api.core.http.HttpRequestBody;
import com.tryfinch.api.core.http.HttpResponse;
import com.tryfinch.api.errors.FinchError;
import com.tryfinch.api.errors.FinchException;
import com.tryfinch.api.models.AccountDisconnectParams;
import com.tryfinch.api.models.AccountIntrospectParams;
import com.tryfinch.api.models.DisconnectResponse;
import com.tryfinch.api.models.Introspection;
import com.tryfinch.api.services.Handlers;
import com.tryfinch.api.services.blocking.AccountService;
import java.io.Closeable;
import java.io.OutputStream;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/tryfinch/api/services/blocking/AccountServiceImpl;", "Lcom/tryfinch/api/services/blocking/AccountService;", "clientOptions", "Lcom/tryfinch/api/core/ClientOptions;", "(Lcom/tryfinch/api/core/ClientOptions;)V", "disconnectHandler", "Lcom/tryfinch/api/core/http/HttpResponse$Handler;", "Lcom/tryfinch/api/models/DisconnectResponse;", "errorHandler", "Lcom/tryfinch/api/errors/FinchError;", "introspectHandler", "Lcom/tryfinch/api/models/Introspection;", "disconnect", "params", "Lcom/tryfinch/api/models/AccountDisconnectParams;", "requestOptions", "Lcom/tryfinch/api/core/RequestOptions;", "introspect", "Lcom/tryfinch/api/models/AccountIntrospectParams;", "finch-java-core"})
@SourceDebugExtension(value={"SMAP\nAccountServiceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AccountServiceImpl.kt\ncom/tryfinch/api/services/blocking/AccountServiceImpl\n+ 2 Handlers.kt\ncom/tryfinch/api/services/Handlers\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,86:1\n47#2:87\n47#2:88\n1#3:89\n*S KotlinDebug\n*F\n+ 1 AccountServiceImpl.kt\ncom/tryfinch/api/services/blocking/AccountServiceImpl\n*L\n28#1:87\n60#1:88\n*E\n"})
public final class AccountServiceImpl
implements AccountService {
    @NotNull
    private final ClientOptions clientOptions;
    @NotNull
    private final HttpResponse.Handler<FinchError> errorHandler;
    @NotNull
    private final HttpResponse.Handler<DisconnectResponse> disconnectHandler;
    @NotNull
    private final HttpResponse.Handler<Introspection> introspectHandler;

    public AccountServiceImpl(@NotNull ClientOptions clientOptions) {
        Intrinsics.checkNotNullParameter((Object)clientOptions, (String)"clientOptions");
        this.clientOptions = clientOptions;
        this.errorHandler = Handlers.errorHandler(this.clientOptions.jsonMapper());
        JsonMapper jsonMapper$iv = this.clientOptions.jsonMapper();
        boolean $i$f$jsonHandler = false;
        this.disconnectHandler = Handlers.withErrorHandler(new HttpResponse.Handler<DisconnectResponse>(jsonMapper$iv){
            final /* synthetic */ JsonMapper $jsonMapper;
            {
                this.$jsonMapper = $jsonMapper;
            }

            public DisconnectResponse handle(@NotNull HttpResponse response) {
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                try {
                    boolean $i$f$jacksonTypeRef = false;
                    return this.$jsonMapper.readValue(response.body(), (TypeReference)new TypeReference<DisconnectResponse>(){});
                }
                catch (Exception e) {
                    throw new FinchException("Error reading response", e);
                }
            }
        }, this.errorHandler);
        jsonMapper$iv = this.clientOptions.jsonMapper();
        $i$f$jsonHandler = false;
        this.introspectHandler = Handlers.withErrorHandler(new HttpResponse.Handler<Introspection>(jsonMapper$iv){
            final /* synthetic */ JsonMapper $jsonMapper;
            {
                this.$jsonMapper = $jsonMapper;
            }

            public Introspection handle(@NotNull HttpResponse response) {
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                try {
                    boolean $i$f$jacksonTypeRef = false;
                    return this.$jsonMapper.readValue(response.body(), (TypeReference)new TypeReference<Introspection>(){});
                }
                catch (Exception e) {
                    throw new FinchException("Error reading response", e);
                }
            }
        }, this.errorHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public DisconnectResponse disconnect(@NotNull AccountDisconnectParams params, @NotNull RequestOptions requestOptions) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)requestOptions, (String)"requestOptions");
        Object object = new String[]{"disconnect"};
        Object $this$disconnect_u24lambda_u241 = object = HttpRequest.Companion.builder().method(HttpMethod.POST).addPathSegments((String[])object).putAllQueryParams(params.getQueryParams$finch_java_core()).putAllHeaders((Multimap<String, String>)((Multimap)this.clientOptions.headers())).putAllHeaders(params.getHeaders$finch_java_core());
        boolean bl = false;
        params.getBody$finch_java_core().ifPresent(arg_0 -> AccountServiceImpl.disconnect$lambda$1$lambda$0((Function1)new Function1<Map<String, ? extends JsonValue>, Unit>((HttpRequest.Builder)$this$disconnect_u24lambda_u241, this){
            final /* synthetic */ HttpRequest.Builder $this_apply;
            final /* synthetic */ AccountServiceImpl this$0;
            {
                this.$this_apply = $receiver;
                this.this$0 = $receiver2;
                super(1);
            }

            public final void invoke(@NotNull Map<String, ? extends JsonValue> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                JsonMapper jsonMapper$iv = AccountServiceImpl.access$getClientOptions$p(this.this$0).jsonMapper();
                boolean $i$f$json = false;
                this.$this_apply.body(new HttpRequestBody(jsonMapper$iv, it){
                    final /* synthetic */ JsonMapper $jsonMapper;
                    final /* synthetic */ T $value;
                    {
                        this.$jsonMapper = $jsonMapper;
                        this.$value = $value;
                    }

                    public void writeTo(@NotNull OutputStream outputStream) {
                        Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
                        try {
                            this.$jsonMapper.writeValue(outputStream, this.$value);
                            return;
                        }
                        catch (Exception e) {
                            throw new FinchException("Error writing request", e);
                        }
                    }

                    @NotNull
                    public String contentType() {
                        return "application/json";
                    }

                    public boolean repeatable() {
                        return true;
                    }

                    public void close() {
                    }
                });
            }
        }, arg_0));
        HttpRequest request2 = ((HttpRequest.Builder)object).build();
        HttpResponse response = this.clientOptions.httpClient().execute(request2, requestOptions);
        boolean bl2 = false;
        Object object2 = response;
        Throwable throwable = null;
        try {
            Object it = (HttpResponse)object2;
            boolean bl3 = false;
            it = this.disconnectHandler.handle((HttpResponse)it);
        }
        catch (Throwable it) {
            throwable = it;
            throw it;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object2, (Throwable)throwable);
        }
        Object $this$disconnect_u24lambda_u244_u24lambda_u243 = object2 = it;
        boolean bl4 = false;
        Boolean bl5 = requestOptions.getResponseValidation();
        if (bl5 != null ? bl5.booleanValue() : this.clientOptions.responseValidation()) {
            ((DisconnectResponse)$this$disconnect_u24lambda_u244_u24lambda_u243).validate();
        }
        return object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Introspection introspect(@NotNull AccountIntrospectParams params, @NotNull RequestOptions requestOptions) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)requestOptions, (String)"requestOptions");
        String[] stringArray = new String[]{"introspect"};
        HttpRequest request2 = HttpRequest.Companion.builder().method(HttpMethod.GET).addPathSegments(stringArray).putAllQueryParams(params.getQueryParams$finch_java_core()).putAllHeaders((Multimap<String, String>)((Multimap)this.clientOptions.headers())).putAllHeaders(params.getHeaders$finch_java_core()).build();
        HttpResponse response = this.clientOptions.httpClient().execute(request2, requestOptions);
        boolean bl = false;
        Object object = response;
        Throwable throwable = null;
        try {
            Object it = (HttpResponse)object;
            boolean bl2 = false;
            it = this.introspectHandler.handle((HttpResponse)it);
        }
        catch (Throwable it) {
            throwable = it;
            throw it;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
        Object $this$introspect_u24lambda_u247_u24lambda_u246 = object = it;
        boolean bl3 = false;
        Boolean bl4 = requestOptions.getResponseValidation();
        if (bl4 != null ? bl4.booleanValue() : this.clientOptions.responseValidation()) {
            ((Introspection)$this$introspect_u24lambda_u247_u24lambda_u246).validate();
        }
        return object;
    }

    private static final void disconnect$lambda$1$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ ClientOptions access$getClientOptions$p(AccountServiceImpl $this) {
        return $this.clientOptions;
    }
}

