/*
 * Decompiled with CFR 0.152.
 */
package com.tryfinch.api.services.async.sandbox;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.google.common.collect.Multimap;
import com.tryfinch.api.core.ClientOptions;
import com.tryfinch.api.core.RequestOptions;
import com.tryfinch.api.core.http.HttpMethod;
import com.tryfinch.api.core.http.HttpRequest;
import com.tryfinch.api.core.http.HttpRequestBody;
import com.tryfinch.api.core.http.HttpResponse;
import com.tryfinch.api.errors.FinchError;
import com.tryfinch.api.errors.FinchException;
import com.tryfinch.api.models.ConnectionCreateResponse;
import com.tryfinch.api.models.SandboxConnectionCreateParams;
import com.tryfinch.api.services.Handlers;
import com.tryfinch.api.services.async.sandbox.ConnectionServiceAsync;
import com.tryfinch.api.services.async.sandbox.connections.AccountServiceAsync;
import com.tryfinch.api.services.async.sandbox.connections.AccountServiceAsyncImpl;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u001e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u001b\u0010\u0005\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/tryfinch/api/services/async/sandbox/ConnectionServiceAsyncImpl;", "Lcom/tryfinch/api/services/async/sandbox/ConnectionServiceAsync;", "clientOptions", "Lcom/tryfinch/api/core/ClientOptions;", "(Lcom/tryfinch/api/core/ClientOptions;)V", "accounts", "Lcom/tryfinch/api/services/async/sandbox/connections/AccountServiceAsync;", "getAccounts", "()Lcom/tryfinch/api/services/async/sandbox/connections/AccountServiceAsync;", "accounts$delegate", "Lkotlin/Lazy;", "createHandler", "Lcom/tryfinch/api/core/http/HttpResponse$Handler;", "Lcom/tryfinch/api/models/ConnectionCreateResponse;", "errorHandler", "Lcom/tryfinch/api/errors/FinchError;", "create", "Ljava/util/concurrent/CompletableFuture;", "params", "Lcom/tryfinch/api/models/SandboxConnectionCreateParams;", "requestOptions", "Lcom/tryfinch/api/core/RequestOptions;", "finch-java-core"})
@SourceDebugExtension(value={"SMAP\nConnectionServiceAsyncImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConnectionServiceAsyncImpl.kt\ncom/tryfinch/api/services/async/sandbox/ConnectionServiceAsyncImpl\n+ 2 Handlers.kt\ncom/tryfinch/api/services/Handlers\n+ 3 HttpRequestBodies.kt\ncom/tryfinch/api/services/HttpRequestBodies\n*L\n1#1,63:1\n59#2:64\n20#3:65\n*S KotlinDebug\n*F\n+ 1 ConnectionServiceAsyncImpl.kt\ncom/tryfinch/api/services/async/sandbox/ConnectionServiceAsyncImpl\n*L\n33#1:64\n49#1:65\n*E\n"})
public final class ConnectionServiceAsyncImpl
implements ConnectionServiceAsync {
    @NotNull
    private final ClientOptions clientOptions;
    @NotNull
    private final HttpResponse.Handler<FinchError> errorHandler;
    @NotNull
    private final Lazy accounts$delegate;
    @NotNull
    private final HttpResponse.Handler<ConnectionCreateResponse> createHandler;

    public ConnectionServiceAsyncImpl(@NotNull ClientOptions clientOptions) {
        Intrinsics.checkNotNullParameter((Object)clientOptions, (String)"clientOptions");
        this.clientOptions = clientOptions;
        this.errorHandler = Handlers.errorHandler(this.clientOptions.jsonMapper());
        this.accounts$delegate = LazyKt.lazy((Function0)((Function0)new Function0<AccountServiceAsyncImpl>(this){
            final /* synthetic */ ConnectionServiceAsyncImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final AccountServiceAsyncImpl invoke() {
                return new AccountServiceAsyncImpl(ConnectionServiceAsyncImpl.access$getClientOptions$p(this.this$0));
            }
        }));
        JsonMapper jsonMapper$iv = this.clientOptions.jsonMapper();
        boolean $i$f$jsonHandler = false;
        this.createHandler = Handlers.withErrorHandler(new HttpResponse.Handler<ConnectionCreateResponse>(jsonMapper$iv){
            final /* synthetic */ JsonMapper $jsonMapper;
            {
                this.$jsonMapper = $jsonMapper;
            }

            public ConnectionCreateResponse handle(@NotNull HttpResponse response) {
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                try {
                    boolean $i$f$jacksonTypeRef = false;
                    return this.$jsonMapper.readValue(response.body(), (TypeReference)new TypeReference<ConnectionCreateResponse>(){});
                }
                catch (Exception e) {
                    throw new FinchException("Error reading response", e);
                }
            }
        }, this.errorHandler);
    }

    private final AccountServiceAsync getAccounts() {
        Lazy lazy = this.accounts$delegate;
        return (AccountServiceAsync)lazy.getValue();
    }

    @Override
    @NotNull
    public AccountServiceAsync accounts() {
        return this.getAccounts();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CompletableFuture<ConnectionCreateResponse> create(@NotNull SandboxConnectionCreateParams params, @NotNull RequestOptions requestOptions) {
        void jsonMapper$iv;
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)requestOptions, (String)"requestOptions");
        String[] stringArray = new String[]{"sandbox", "connections"};
        HttpRequest.Builder builder = HttpRequest.Companion.builder().method(HttpMethod.POST).addPathSegments(stringArray).putAllQueryParams((Multimap<String, String>)((Multimap)this.clientOptions.queryParams())).putAllQueryParams(params.getQueryParams$finch_java_core()).putAllHeaders((Multimap<String, String>)((Multimap)this.clientOptions.headers())).putAllHeaders(params.getHeaders$finch_java_core());
        stringArray = this.clientOptions.jsonMapper();
        SandboxConnectionCreateParams.SandboxConnectionCreateBody value$iv = params.getBody$finch_java_core();
        boolean $i$f$json = false;
        HttpRequest request2 = builder.body(new HttpRequestBody((JsonMapper)jsonMapper$iv, value$iv){
            @Nullable
            private byte[] cachedBytes;
            final /* synthetic */ JsonMapper $jsonMapper;
            final /* synthetic */ T $value;
            {
                this.$jsonMapper = $jsonMapper;
                this.$value = $value;
            }

            private final byte[] serialize() {
                if (this.cachedBytes != null) {
                    Intrinsics.checkNotNull((Object)this.cachedBytes);
                    return this.cachedBytes;
                }
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                try {
                    this.$jsonMapper.writeValue((OutputStream)buffer, this.$value);
                    this.cachedBytes = buffer.toByteArray();
                    Intrinsics.checkNotNull((Object)this.cachedBytes);
                    return this.cachedBytes;
                }
                catch (Exception e) {
                    throw new FinchException("Error writing request", e);
                }
            }

            public void writeTo(@NotNull OutputStream outputStream) {
                Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
                outputStream.write(this.serialize());
            }

            @NotNull
            public String contentType() {
                return "application/json";
            }

            public long contentLength() {
                return this.serialize().length;
            }

            public boolean repeatable() {
                return true;
            }

            public void close() {
            }
        }).build();
        CompletionStage completionStage = this.clientOptions.httpClient().executeAsync(request2, requestOptions).thenApply(arg_0 -> ConnectionServiceAsyncImpl.create$lambda$0((Function1)new Function1<HttpResponse, ConnectionCreateResponse>(this, requestOptions){
            final /* synthetic */ ConnectionServiceAsyncImpl this$0;
            final /* synthetic */ RequestOptions $requestOptions;
            {
                this.this$0 = $receiver;
                this.$requestOptions = $requestOptions;
                super(1);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final ConnectionCreateResponse invoke(HttpResponse response) {
                Object object = response;
                Object object2 = this.this$0;
                Object object3 = null;
                try {
                    Object it = (HttpResponse)object;
                    boolean bl = false;
                    HttpResponse.Handler handler = ConnectionServiceAsyncImpl.access$getCreateHandler$p((ConnectionServiceAsyncImpl)object2);
                    Intrinsics.checkNotNull((Object)it);
                    it = (ConnectionCreateResponse)handler.handle((HttpResponse)it);
                }
                catch (Throwable it) {
                    object3 = it;
                    throw it;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)object, (Throwable)object3);
                }
                object = it;
                object2 = this.$requestOptions;
                object3 = this.this$0;
                Object $this$invoke_u24lambda_u241 = object;
                boolean bl = false;
                Boolean bl2 = ((RequestOptions)object2).getResponseValidation();
                if (bl2 != null ? bl2.booleanValue() : ConnectionServiceAsyncImpl.access$getClientOptions$p((ConnectionServiceAsyncImpl)object3).responseValidation()) {
                    ((ConnectionCreateResponse)$this$invoke_u24lambda_u241).validate();
                }
                return object;
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"thenApply(...)");
        return completionStage;
    }

    private static final ConnectionCreateResponse create$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (ConnectionCreateResponse)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ HttpResponse.Handler access$getCreateHandler$p(ConnectionServiceAsyncImpl $this) {
        return $this.createHandler;
    }

    public static final /* synthetic */ ClientOptions access$getClientOptions$p(ConnectionServiceAsyncImpl $this) {
        return $this.clientOptions;
    }
}

