/*
 * Decompiled with CFR 0.152.
 */
package com.tryfinch.api.core;

import com.fasterxml.jackson.databind.json.JsonMapper;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.tryfinch.api.core.ObjectMappers;
import com.tryfinch.api.core.Properties;
import com.tryfinch.api.core.Utils;
import com.tryfinch.api.core.http.HttpClient;
import com.tryfinch.api.core.http.RetryingHttpClient;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\n\u0018\u0000 \u001d2\u00020\u0001:\u0002\u001c\u001dB\u0093\u0001\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\t\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\t\u0012\b\u0010\f\u001a\u0004\u0018\u00010\t\u0012\b\u0010\r\u001a\u0004\u0018\u00010\t\u0012\b\u0010\u000e\u001a\u0004\u0018\u00010\t\u0012\b\u0010\u000f\u001a\u0004\u0018\u00010\t\u0012\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u0011\u0012\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u0011\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\u0002\u0010\u0015R\u0015\u0010\n\u001a\u0004\u0018\u00010\t8\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0016R\u0013\u0010\b\u001a\u00020\t8\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0016R\u0015\u0010\u000b\u001a\u0004\u0018\u00010\t8\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0016R\u0015\u0010\f\u001a\u0004\u0018\u00010\t8\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0016R\u0013\u0010\u0006\u001a\u00020\u00078\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0017R\u001f\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u00118\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0018R\u0013\u0010\u0002\u001a\u00020\u00038\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0019R\u0013\u0010\u0004\u001a\u00020\u00058\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u001aR\u001f\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u00118\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0018R\u0013\u0010\u0013\u001a\u00020\u00148\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u001bR\u0015\u0010\r\u001a\u0004\u0018\u00010\t8\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0016R\u0015\u0010\u000e\u001a\u0004\u0018\u00010\t8\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0016R\u0015\u0010\u000f\u001a\u0004\u0018\u00010\t8\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0016\u00a8\u0006\u001e"}, d2={"Lcom/tryfinch/api/core/ClientOptions;", "", "httpClient", "Lcom/tryfinch/api/core/http/HttpClient;", "jsonMapper", "Lcom/fasterxml/jackson/databind/json/JsonMapper;", "clock", "Ljava/time/Clock;", "baseUrl", "", "accessToken", "clientId", "clientSecret", "sandboxClientId", "sandboxClientSecret", "webhookSecret", "headers", "Lcom/google/common/collect/ListMultimap;", "queryParams", "responseValidation", "", "(Lcom/tryfinch/api/core/http/HttpClient;Lcom/fasterxml/jackson/databind/json/JsonMapper;Ljava/time/Clock;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/google/common/collect/ListMultimap;Lcom/google/common/collect/ListMultimap;Z)V", "()Ljava/lang/String;", "()Ljava/time/Clock;", "()Lcom/google/common/collect/ListMultimap;", "()Lcom/tryfinch/api/core/http/HttpClient;", "()Lcom/fasterxml/jackson/databind/json/JsonMapper;", "()Z", "Builder", "Companion", "finch-java-core"})
public final class ClientOptions {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final HttpClient httpClient;
    @NotNull
    private final JsonMapper jsonMapper;
    @NotNull
    private final Clock clock;
    @NotNull
    private final String baseUrl;
    @Nullable
    private final String accessToken;
    @Nullable
    private final String clientId;
    @Nullable
    private final String clientSecret;
    @Nullable
    private final String sandboxClientId;
    @Nullable
    private final String sandboxClientSecret;
    @Nullable
    private final String webhookSecret;
    @NotNull
    private final ListMultimap<String, String> headers;
    @NotNull
    private final ListMultimap<String, String> queryParams;
    private final boolean responseValidation;
    @NotNull
    public static final String PRODUCTION_URL = "https://api.tryfinch.com";

    private ClientOptions(HttpClient httpClient, JsonMapper jsonMapper, Clock clock, String baseUrl, String accessToken, String clientId, String clientSecret, String sandboxClientId, String sandboxClientSecret, String webhookSecret, ListMultimap<String, String> headers, ListMultimap<String, String> queryParams, boolean responseValidation) {
        this.httpClient = httpClient;
        this.jsonMapper = jsonMapper;
        this.clock = clock;
        this.baseUrl = baseUrl;
        this.accessToken = accessToken;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.sandboxClientId = sandboxClientId;
        this.sandboxClientSecret = sandboxClientSecret;
        this.webhookSecret = webhookSecret;
        this.headers = headers;
        this.queryParams = queryParams;
        this.responseValidation = responseValidation;
    }

    @JvmName(name="httpClient")
    @NotNull
    public final HttpClient httpClient() {
        return this.httpClient;
    }

    @JvmName(name="jsonMapper")
    @NotNull
    public final JsonMapper jsonMapper() {
        return this.jsonMapper;
    }

    @JvmName(name="clock")
    @NotNull
    public final Clock clock() {
        return this.clock;
    }

    @JvmName(name="baseUrl")
    @NotNull
    public final String baseUrl() {
        return this.baseUrl;
    }

    @JvmName(name="accessToken")
    @Nullable
    public final String accessToken() {
        return this.accessToken;
    }

    @JvmName(name="clientId")
    @Nullable
    public final String clientId() {
        return this.clientId;
    }

    @JvmName(name="clientSecret")
    @Nullable
    public final String clientSecret() {
        return this.clientSecret;
    }

    @JvmName(name="sandboxClientId")
    @Nullable
    public final String sandboxClientId() {
        return this.sandboxClientId;
    }

    @JvmName(name="sandboxClientSecret")
    @Nullable
    public final String sandboxClientSecret() {
        return this.sandboxClientSecret;
    }

    @JvmName(name="webhookSecret")
    @Nullable
    public final String webhookSecret() {
        return this.webhookSecret;
    }

    @JvmName(name="headers")
    @NotNull
    public final ListMultimap<String, String> headers() {
        return this.headers;
    }

    @JvmName(name="queryParams")
    @NotNull
    public final ListMultimap<String, String> queryParams() {
        return this.queryParams;
    }

    @JvmName(name="responseValidation")
    public final boolean responseValidation() {
        return this.responseValidation;
    }

    @JvmStatic
    @NotNull
    public static final Builder builder() {
        return Companion.builder();
    }

    @JvmStatic
    @NotNull
    public static final ClientOptions fromEnv() {
        return Companion.fromEnv();
    }

    public /* synthetic */ ClientOptions(HttpClient httpClient, JsonMapper jsonMapper, Clock clock, String baseUrl, String accessToken, String clientId, String clientSecret, String sandboxClientId, String sandboxClientSecret, String webhookSecret, ListMultimap headers, ListMultimap queryParams, boolean responseValidation, DefaultConstructorMarker $constructor_marker) {
        this(httpClient, jsonMapper, clock, baseUrl, accessToken, clientId, clientSecret, sandboxClientId, sandboxClientSecret, webhookSecret, (ListMultimap<String, String>)headers, (ListMultimap<String, String>)queryParams, responseValidation);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u001c\n\u0002\b\f\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00002\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004J\u000e\u0010\u0005\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0004J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u0006\u001a\u00020\u00002\b\u0010\u0006\u001a\u0004\u0018\u00010\u0004J\u0010\u0010\u0007\u001a\u00020\u00002\b\u0010\u0007\u001a\u0004\u0018\u00010\u0004J\u000e\u0010\b\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\tJ\u0006\u0010\u001b\u001a\u00020\u0000J \u0010\n\u001a\u00020\u00002\u0018\u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u001d0\u001cJ\u000e\u0010\r\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0012J \u0010\u001e\u001a\u00020\u00002\u0018\u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u001d0\u001cJ \u0010\u001f\u001a\u00020\u00002\u0018\u0010\u0013\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u001d0\u001cJ\u0016\u0010 \u001a\u00020\u00002\u0006\u0010!\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020\u0004J\u001c\u0010#\u001a\u00020\u00002\u0006\u0010!\u001a\u00020\u00042\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00040\u001dJ\u0016\u0010%\u001a\u00020\u00002\u0006\u0010!\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020\u0004J\u001c\u0010&\u001a\u00020\u00002\u0006\u0010!\u001a\u00020\u00042\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00040\u001dJ \u0010\u0013\u001a\u00020\u00002\u0018\u0010\u0013\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u001d0\u001cJ\u000e\u0010'\u001a\u00020\u00002\u0006\u0010!\u001a\u00020\u0004J\u000e\u0010(\u001a\u00020\u00002\u0006\u0010!\u001a\u00020\u0004J\u000e\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u0015J\u0010\u0010\u0016\u001a\u00020\u00002\b\u0010\u0016\u001a\u0004\u0018\u00010\u0004J\u0010\u0010\u0017\u001a\u00020\u00002\b\u0010\u0017\u001a\u0004\u0018\u00010\u0004J\u0010\u0010\u0018\u001a\u00020\u00002\b\u0010\u0018\u001a\u0004\u0018\u00010\u0004R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\f0\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u0013\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\f0\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/tryfinch/api/core/ClientOptions$Builder;", "", "()V", "accessToken", "", "baseUrl", "clientId", "clientSecret", "clock", "Ljava/time/Clock;", "headers", "", "", "httpClient", "Lcom/tryfinch/api/core/http/HttpClient;", "jsonMapper", "Lcom/fasterxml/jackson/databind/json/JsonMapper;", "maxRetries", "", "queryParams", "responseValidation", "", "sandboxClientId", "sandboxClientSecret", "webhookSecret", "build", "Lcom/tryfinch/api/core/ClientOptions;", "fromEnv", "", "", "putAllHeaders", "putAllQueryParams", "putHeader", "name", "value", "putHeaders", "values", "putQueryParam", "putQueryParams", "removeHeader", "removeQueryParam", "finch-java-core"})
    @SourceDebugExtension(value={"SMAP\nClientOptions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClientOptions.kt\ncom/tryfinch/api/core/ClientOptions$Builder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,178:1\n1#2:179\n372#3,7:180\n372#3,7:187\n372#3,7:194\n372#3,7:201\n*S KotlinDebug\n*F\n+ 1 ClientOptions.kt\ncom/tryfinch/api/core/ClientOptions$Builder\n*L\n70#1:180,7\n74#1:187,7\n89#1:194,7\n93#1:201,7\n*E\n"})
    public static final class Builder {
        @Nullable
        private HttpClient httpClient;
        @Nullable
        private JsonMapper jsonMapper;
        @NotNull
        private Clock clock;
        @NotNull
        private String baseUrl;
        @NotNull
        private Map<String, List<String>> headers;
        @NotNull
        private Map<String, List<String>> queryParams;
        private boolean responseValidation;
        private int maxRetries;
        @Nullable
        private String accessToken;
        @Nullable
        private String clientId;
        @Nullable
        private String clientSecret;
        @Nullable
        private String sandboxClientId;
        @Nullable
        private String sandboxClientSecret;
        @Nullable
        private String webhookSecret;

        public Builder() {
            Clock clock = Clock.systemUTC();
            Intrinsics.checkNotNullExpressionValue((Object)clock, (String)"systemUTC(...)");
            this.clock = clock;
            this.baseUrl = ClientOptions.PRODUCTION_URL;
            this.headers = new LinkedHashMap();
            this.queryParams = new LinkedHashMap();
            this.maxRetries = 2;
        }

        @NotNull
        public final Builder httpClient(@NotNull HttpClient httpClient) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)httpClient, (String)"httpClient");
            Builder $this$httpClient_u24lambda_u240 = builder = this;
            boolean bl = false;
            $this$httpClient_u24lambda_u240.httpClient = httpClient;
            return builder;
        }

        @NotNull
        public final Builder jsonMapper(@NotNull JsonMapper jsonMapper) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)jsonMapper, (String)"jsonMapper");
            Builder $this$jsonMapper_u24lambda_u241 = builder = this;
            boolean bl = false;
            $this$jsonMapper_u24lambda_u241.jsonMapper = jsonMapper;
            return builder;
        }

        @NotNull
        public final Builder baseUrl(@NotNull String baseUrl) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)baseUrl, (String)"baseUrl");
            Builder $this$baseUrl_u24lambda_u242 = builder = this;
            boolean bl = false;
            $this$baseUrl_u24lambda_u242.baseUrl = baseUrl;
            return builder;
        }

        @NotNull
        public final Builder clock(@NotNull Clock clock) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
            Builder $this$clock_u24lambda_u243 = builder = this;
            boolean bl = false;
            $this$clock_u24lambda_u243.clock = clock;
            return builder;
        }

        @NotNull
        public final Builder headers(@NotNull Map<String, ? extends Iterable<String>> headers) {
            Builder builder;
            Intrinsics.checkNotNullParameter(headers, (String)"headers");
            Builder $this$headers_u24lambda_u244 = builder = this;
            boolean bl = false;
            $this$headers_u24lambda_u244.headers.clear();
            $this$headers_u24lambda_u244.putAllHeaders(headers);
            return builder;
        }

        @NotNull
        public final Builder putHeader(@NotNull String name, @NotNull String value2) {
            List list2;
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            Builder $this$putHeader_u24lambda_u246 = builder = this;
            boolean bl = false;
            Map<String, List<String>> $this$getOrPut$iv = $this$putHeader_u24lambda_u246.headers;
            boolean $i$f$getOrPut = false;
            List value$iv = $this$getOrPut$iv.get(name);
            if (value$iv == null) {
                boolean bl2 = false;
                List answer$iv = new ArrayList();
                $this$getOrPut$iv.put(name, answer$iv);
                list2 = answer$iv;
            } else {
                list2 = value$iv;
            }
            list2.add((String)value2);
            return builder;
        }

        @NotNull
        public final Builder putHeaders(@NotNull String name, @NotNull Iterable<String> values) {
            List list2;
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(values, (String)"values");
            Builder $this$putHeaders_u24lambda_u248 = builder = this;
            boolean bl = false;
            Map<String, List<String>> $this$getOrPut$iv = $this$putHeaders_u24lambda_u248.headers;
            boolean $i$f$getOrPut = false;
            List value$iv = $this$getOrPut$iv.get(name);
            if (value$iv == null) {
                boolean bl2 = false;
                List answer$iv = new ArrayList();
                $this$getOrPut$iv.put(name, answer$iv);
                list2 = answer$iv;
            } else {
                list2 = value$iv;
            }
            CollectionsKt.addAll((Collection)list2, values);
            return builder;
        }

        @NotNull
        public final Builder putAllHeaders(@NotNull Map<String, ? extends Iterable<String>> headers) {
            Builder builder;
            Intrinsics.checkNotNullParameter(headers, (String)"headers");
            Builder $this$putAllHeaders_u24lambda_u2410 = builder = this;
            boolean bl = false;
            headers.forEach((arg_0, arg_1) -> Builder.putAllHeaders$lambda$10$lambda$9((Function2)new Function2<String, Iterable<? extends String>, Unit>((Object)$this$putAllHeaders_u24lambda_u2410){

                public final void invoke(@NotNull String p0, @NotNull Iterable<String> p1) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    Intrinsics.checkNotNullParameter(p1, (String)"p1");
                    ((Builder)this.receiver).putHeaders(p0, p1);
                }
            }, arg_0, arg_1));
            return builder;
        }

        @NotNull
        public final Builder removeHeader(@NotNull String name) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Builder $this$removeHeader_u24lambda_u2411 = builder = this;
            boolean bl = false;
            $this$removeHeader_u24lambda_u2411.headers.put(name, new ArrayList());
            return builder;
        }

        @NotNull
        public final Builder queryParams(@NotNull Map<String, ? extends Iterable<String>> queryParams) {
            Builder builder;
            Intrinsics.checkNotNullParameter(queryParams, (String)"queryParams");
            Builder $this$queryParams_u24lambda_u2412 = builder = this;
            boolean bl = false;
            $this$queryParams_u24lambda_u2412.queryParams.clear();
            $this$queryParams_u24lambda_u2412.putAllQueryParams(queryParams);
            return builder;
        }

        @NotNull
        public final Builder putQueryParam(@NotNull String name, @NotNull String value2) {
            List list2;
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            Builder $this$putQueryParam_u24lambda_u2414 = builder = this;
            boolean bl = false;
            Map<String, List<String>> $this$getOrPut$iv = $this$putQueryParam_u24lambda_u2414.queryParams;
            boolean $i$f$getOrPut = false;
            List value$iv = $this$getOrPut$iv.get(name);
            if (value$iv == null) {
                boolean bl2 = false;
                List answer$iv = new ArrayList();
                $this$getOrPut$iv.put(name, answer$iv);
                list2 = answer$iv;
            } else {
                list2 = value$iv;
            }
            list2.add((String)value2);
            return builder;
        }

        @NotNull
        public final Builder putQueryParams(@NotNull String name, @NotNull Iterable<String> values) {
            List list2;
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(values, (String)"values");
            Builder $this$putQueryParams_u24lambda_u2416 = builder = this;
            boolean bl = false;
            Map<String, List<String>> $this$getOrPut$iv = $this$putQueryParams_u24lambda_u2416.queryParams;
            boolean $i$f$getOrPut = false;
            List value$iv = $this$getOrPut$iv.get(name);
            if (value$iv == null) {
                boolean bl2 = false;
                List answer$iv = new ArrayList();
                $this$getOrPut$iv.put(name, answer$iv);
                list2 = answer$iv;
            } else {
                list2 = value$iv;
            }
            CollectionsKt.addAll((Collection)list2, values);
            return builder;
        }

        @NotNull
        public final Builder putAllQueryParams(@NotNull Map<String, ? extends Iterable<String>> queryParams) {
            Builder builder;
            Intrinsics.checkNotNullParameter(queryParams, (String)"queryParams");
            Builder $this$putAllQueryParams_u24lambda_u2418 = builder = this;
            boolean bl = false;
            queryParams.forEach((arg_0, arg_1) -> Builder.putAllQueryParams$lambda$18$lambda$17((Function2)new Function2<String, Iterable<? extends String>, Unit>((Object)$this$putAllQueryParams_u24lambda_u2418){

                public final void invoke(@NotNull String p0, @NotNull Iterable<String> p1) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    Intrinsics.checkNotNullParameter(p1, (String)"p1");
                    ((Builder)this.receiver).putQueryParams(p0, p1);
                }
            }, arg_0, arg_1));
            return builder;
        }

        @NotNull
        public final Builder removeQueryParam(@NotNull String name) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Builder $this$removeQueryParam_u24lambda_u2419 = builder = this;
            boolean bl = false;
            $this$removeQueryParam_u24lambda_u2419.queryParams.put(name, new ArrayList());
            return builder;
        }

        @NotNull
        public final Builder responseValidation(boolean responseValidation) {
            Builder builder;
            Builder $this$responseValidation_u24lambda_u2420 = builder = this;
            boolean bl = false;
            $this$responseValidation_u24lambda_u2420.responseValidation = responseValidation;
            return builder;
        }

        @NotNull
        public final Builder maxRetries(int maxRetries) {
            Builder builder;
            Builder $this$maxRetries_u24lambda_u2421 = builder = this;
            boolean bl = false;
            $this$maxRetries_u24lambda_u2421.maxRetries = maxRetries;
            return builder;
        }

        @NotNull
        public final Builder accessToken(@Nullable String accessToken) {
            Builder builder;
            Builder $this$accessToken_u24lambda_u2422 = builder = this;
            boolean bl = false;
            $this$accessToken_u24lambda_u2422.accessToken = accessToken;
            return builder;
        }

        @NotNull
        public final Builder clientId(@Nullable String clientId) {
            Builder builder;
            Builder $this$clientId_u24lambda_u2423 = builder = this;
            boolean bl = false;
            $this$clientId_u24lambda_u2423.clientId = clientId;
            return builder;
        }

        @NotNull
        public final Builder clientSecret(@Nullable String clientSecret) {
            Builder builder;
            Builder $this$clientSecret_u24lambda_u2424 = builder = this;
            boolean bl = false;
            $this$clientSecret_u24lambda_u2424.clientSecret = clientSecret;
            return builder;
        }

        @NotNull
        public final Builder sandboxClientId(@Nullable String sandboxClientId) {
            Builder builder;
            Builder $this$sandboxClientId_u24lambda_u2425 = builder = this;
            boolean bl = false;
            $this$sandboxClientId_u24lambda_u2425.sandboxClientId = sandboxClientId;
            return builder;
        }

        @NotNull
        public final Builder sandboxClientSecret(@Nullable String sandboxClientSecret) {
            Builder builder;
            Builder $this$sandboxClientSecret_u24lambda_u2426 = builder = this;
            boolean bl = false;
            $this$sandboxClientSecret_u24lambda_u2426.sandboxClientSecret = sandboxClientSecret;
            return builder;
        }

        @NotNull
        public final Builder webhookSecret(@Nullable String webhookSecret) {
            Builder builder;
            Builder $this$webhookSecret_u24lambda_u2427 = builder = this;
            boolean bl = false;
            $this$webhookSecret_u24lambda_u2427.webhookSecret = webhookSecret;
            return builder;
        }

        @NotNull
        public final Builder fromEnv() {
            Builder builder;
            block4: {
                String it;
                String string;
                Builder $this$fromEnv_u24lambda_u2433 = builder = this;
                boolean bl = false;
                String string2 = string = System.getenv("FINCH_CLIENT_ID");
                if (string2 != null) {
                    Intrinsics.checkNotNull((Object)string2);
                    it = string;
                    boolean bl2 = false;
                    $this$fromEnv_u24lambda_u2433.clientId(it);
                }
                String string3 = string = System.getenv("FINCH_CLIENT_SECRET");
                if (string3 != null) {
                    Intrinsics.checkNotNull((Object)string3);
                    it = string;
                    boolean bl3 = false;
                    $this$fromEnv_u24lambda_u2433.clientSecret(it);
                }
                String string4 = string = System.getenv("FINCH_SANDBOX_CLIENT_ID");
                if (string4 != null) {
                    Intrinsics.checkNotNull((Object)string4);
                    it = string;
                    boolean bl4 = false;
                    $this$fromEnv_u24lambda_u2433.sandboxClientId(it);
                }
                String string5 = string = System.getenv("FINCH_SANDBOX_CLIENT_SECRET");
                if (string5 != null) {
                    Intrinsics.checkNotNull((Object)string5);
                    it = string;
                    boolean bl5 = false;
                    $this$fromEnv_u24lambda_u2433.sandboxClientSecret(it);
                }
                String string6 = string = System.getenv("FINCH_WEBHOOK_SECRET");
                if (string6 == null) break block4;
                Intrinsics.checkNotNull((Object)string6);
                it = string;
                boolean bl6 = false;
                $this$fromEnv_u24lambda_u2433.webhookSecret(it);
            }
            return builder;
        }

        @NotNull
        public final ClientOptions build() {
            if (this.httpClient == null) {
                boolean $i$a$-checkNotNull-ClientOptions$Builder$build$22 = false;
                String $i$a$-checkNotNull-ClientOptions$Builder$build$22 = "`httpClient` is required but was not set";
                throw new IllegalStateException($i$a$-checkNotNull-ClientOptions$Builder$build$22.toString());
            }
            ArrayListMultimap headers = ArrayListMultimap.create();
            ArrayListMultimap queryParams = ArrayListMultimap.create();
            headers.put((Object)"X-Stainless-Lang", (Object)"java");
            headers.put((Object)"X-Stainless-Arch", (Object)Properties.getOsArch());
            headers.put((Object)"X-Stainless-OS", (Object)Properties.getOsName());
            headers.put((Object)"X-Stainless-OS-Version", (Object)Properties.getOsVersion());
            headers.put((Object)"X-Stainless-Package-Version", (Object)Properties.getPackageVersion());
            headers.put((Object)"X-Stainless-Runtime-Version", (Object)Properties.getJavaVersion());
            headers.put((Object)"Finch-API-Version", (Object)"2020-09-17");
            CharSequence charSequence = this.accessToken;
            if (!(charSequence == null || charSequence.length() == 0)) {
                headers.put((Object)"Authorization", (Object)("Bearer " + this.accessToken));
            }
            if (!((charSequence = (CharSequence)this.sandboxClientId) == null || charSequence.length() == 0) && !((charSequence = (CharSequence)this.sandboxClientSecret) == null || charSequence.length() == 0)) {
                StringBuilder stringBuilder = new StringBuilder().append("Basic ");
                Base64.Encoder encoder = Base64.getEncoder();
                charSequence = this.sandboxClientId + ':' + this.sandboxClientSecret;
                byte[] byArray = ((String)charSequence).getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                headers.put((Object)"Authorization", (Object)stringBuilder.append(encoder.encodeToString(byArray)).toString());
            }
            this.headers.forEach((arg_0, arg_1) -> Builder.build$lambda$35((Function2)new Function2<String, Iterable<? extends String>, Unit>((Object)headers){

                public final void invoke(String p0, Iterable<String> p1) {
                    ((ArrayListMultimap)this.receiver).replaceValues((Object)p0, p1);
                }
            }, arg_0, arg_1));
            this.queryParams.forEach((arg_0, arg_1) -> Builder.build$lambda$37((Function2)new Function2<String, Iterable<? extends String>, Unit>((Object)queryParams){

                public final void invoke(String p0, Iterable<String> p1) {
                    ((ArrayListMultimap)this.receiver).replaceValues((Object)p0, p1);
                }
            }, arg_0, arg_1));
            RetryingHttpClient.Builder builder = RetryingHttpClient.Companion.builder();
            HttpClient httpClient = this.httpClient;
            Intrinsics.checkNotNull((Object)httpClient);
            HttpClient httpClient2 = builder.httpClient(httpClient).clock(this.clock).maxRetries(this.maxRetries).build();
            JsonMapper jsonMapper = this.jsonMapper;
            if (jsonMapper == null) {
                jsonMapper = ObjectMappers.jsonMapper();
            }
            Intrinsics.checkNotNull((Object)headers);
            ListMultimap listMultimap = Utils.toUnmodifiable((ListMultimap)headers);
            Intrinsics.checkNotNull((Object)queryParams);
            return new ClientOptions(httpClient2, jsonMapper, this.clock, this.baseUrl, this.accessToken, this.clientId, this.clientSecret, this.sandboxClientId, this.sandboxClientSecret, this.webhookSecret, listMultimap, Utils.toUnmodifiable((ListMultimap)queryParams), this.responseValidation, null);
        }

        private static final void putAllHeaders$lambda$10$lambda$9(Function2 $tmp0, Object p0, Object p1) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            $tmp0.invoke(p0, p1);
        }

        private static final void putAllQueryParams$lambda$18$lambda$17(Function2 $tmp0, Object p0, Object p1) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            $tmp0.invoke(p0, p1);
        }

        private static final void build$lambda$35(Function2 $tmp0, Object p0, Object p1) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            $tmp0.invoke(p0, p1);
        }

        private static final void build$lambda$37(Function2 $tmp0, Object p0, Object p1) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            $tmp0.invoke(p0, p1);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0005\u001a\u00020\u0006H\u0007J\b\u0010\u0007\u001a\u00020\bH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/tryfinch/api/core/ClientOptions$Companion;", "", "()V", "PRODUCTION_URL", "", "builder", "Lcom/tryfinch/api/core/ClientOptions$Builder;", "fromEnv", "Lcom/tryfinch/api/core/ClientOptions;", "finch-java-core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Builder builder() {
            return new Builder();
        }

        @JvmStatic
        @NotNull
        public final ClientOptions fromEnv() {
            return this.builder().fromEnv().build();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

