/*
 * Decompiled with CFR 0.152.
 */
package com.tryfinch.api.services.async.payroll;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.google.common.collect.Multimap;
import com.tryfinch.api.core.ClientOptions;
import com.tryfinch.api.core.RequestOptions;
import com.tryfinch.api.core.http.HttpMethod;
import com.tryfinch.api.core.http.HttpRequest;
import com.tryfinch.api.core.http.HttpResponse;
import com.tryfinch.api.errors.FinchError;
import com.tryfinch.api.errors.FinchException;
import com.tryfinch.api.models.PayGroupListResponse;
import com.tryfinch.api.models.PayGroupRetrieveResponse;
import com.tryfinch.api.models.PayrollPayGroupListPageAsync;
import com.tryfinch.api.models.PayrollPayGroupListParams;
import com.tryfinch.api.models.PayrollPayGroupRetrieveParams;
import com.tryfinch.api.services.Handlers;
import com.tryfinch.api.services.async.payroll.PayGroupServiceAsync;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import kotlin.Metadata;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u001e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\f0\u000e2\u0006\u0010\u0010\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/tryfinch/api/services/async/payroll/PayGroupServiceAsyncImpl;", "Lcom/tryfinch/api/services/async/payroll/PayGroupServiceAsync;", "clientOptions", "Lcom/tryfinch/api/core/ClientOptions;", "(Lcom/tryfinch/api/core/ClientOptions;)V", "errorHandler", "Lcom/tryfinch/api/core/http/HttpResponse$Handler;", "Lcom/tryfinch/api/errors/FinchError;", "listHandler", "", "Lcom/tryfinch/api/models/PayGroupListResponse;", "retrieveHandler", "Lcom/tryfinch/api/models/PayGroupRetrieveResponse;", "list", "Ljava/util/concurrent/CompletableFuture;", "Lcom/tryfinch/api/models/PayrollPayGroupListPageAsync;", "params", "Lcom/tryfinch/api/models/PayrollPayGroupListParams;", "requestOptions", "Lcom/tryfinch/api/core/RequestOptions;", "retrieve", "Lcom/tryfinch/api/models/PayrollPayGroupRetrieveParams;", "finch-java-core"})
@SourceDebugExtension(value={"SMAP\nPayGroupServiceAsyncImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PayGroupServiceAsyncImpl.kt\ncom/tryfinch/api/services/async/payroll/PayGroupServiceAsyncImpl\n+ 2 Handlers.kt\ncom/tryfinch/api/services/Handlers\n*L\n1#1,90:1\n59#2:91\n59#2:92\n*S KotlinDebug\n*F\n+ 1 PayGroupServiceAsyncImpl.kt\ncom/tryfinch/api/services/async/payroll/PayGroupServiceAsyncImpl\n*L\n29#1:91\n59#1:92\n*E\n"})
public final class PayGroupServiceAsyncImpl
implements PayGroupServiceAsync {
    @NotNull
    private final ClientOptions clientOptions;
    @NotNull
    private final HttpResponse.Handler<FinchError> errorHandler;
    @NotNull
    private final HttpResponse.Handler<PayGroupRetrieveResponse> retrieveHandler;
    @NotNull
    private final HttpResponse.Handler<List<PayGroupListResponse>> listHandler;

    public PayGroupServiceAsyncImpl(@NotNull ClientOptions clientOptions) {
        Intrinsics.checkNotNullParameter((Object)clientOptions, (String)"clientOptions");
        this.clientOptions = clientOptions;
        this.errorHandler = Handlers.errorHandler(this.clientOptions.jsonMapper());
        JsonMapper jsonMapper$iv = this.clientOptions.jsonMapper();
        boolean $i$f$jsonHandler = false;
        this.retrieveHandler = Handlers.withErrorHandler(new HttpResponse.Handler<PayGroupRetrieveResponse>(jsonMapper$iv){
            final /* synthetic */ JsonMapper $jsonMapper;
            {
                this.$jsonMapper = $jsonMapper;
            }

            public PayGroupRetrieveResponse handle(@NotNull HttpResponse response) {
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                try {
                    boolean $i$f$jacksonTypeRef = false;
                    return this.$jsonMapper.readValue(response.body(), (TypeReference)new TypeReference<PayGroupRetrieveResponse>(){});
                }
                catch (Exception e) {
                    throw new FinchException("Error reading response", e);
                }
            }
        }, this.errorHandler);
        jsonMapper$iv = this.clientOptions.jsonMapper();
        $i$f$jsonHandler = false;
        this.listHandler = Handlers.withErrorHandler(new HttpResponse.Handler<List<? extends PayGroupListResponse>>(jsonMapper$iv){
            final /* synthetic */ JsonMapper $jsonMapper;
            {
                this.$jsonMapper = $jsonMapper;
            }

            public List<? extends PayGroupListResponse> handle(@NotNull HttpResponse response) {
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                try {
                    boolean $i$f$jacksonTypeRef = false;
                    return this.$jsonMapper.readValue(response.body(), (TypeReference)new TypeReference<List<? extends PayGroupListResponse>>(){});
                }
                catch (Exception e) {
                    throw new FinchException("Error reading response", e);
                }
            }
        }, this.errorHandler);
    }

    @Override
    @NotNull
    public CompletableFuture<PayGroupRetrieveResponse> retrieve(@NotNull PayrollPayGroupRetrieveParams params, @NotNull RequestOptions requestOptions) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)requestOptions, (String)"requestOptions");
        String[] stringArray = new String[]{"employer", "pay-groups", params.getPathParam(0)};
        HttpRequest request2 = HttpRequest.Companion.builder().method(HttpMethod.GET).addPathSegments(stringArray).putAllQueryParams((Multimap<String, String>)((Multimap)this.clientOptions.queryParams())).putAllQueryParams(params.getQueryParams$finch_java_core()).putAllHeaders((Multimap<String, String>)((Multimap)this.clientOptions.headers())).putAllHeaders(params.getHeaders$finch_java_core()).build();
        CompletionStage completionStage = this.clientOptions.httpClient().executeAsync(request2, requestOptions).thenApply(arg_0 -> PayGroupServiceAsyncImpl.retrieve$lambda$0((Function1)new Function1<HttpResponse, PayGroupRetrieveResponse>(this, requestOptions){
            final /* synthetic */ PayGroupServiceAsyncImpl this$0;
            final /* synthetic */ RequestOptions $requestOptions;
            {
                this.this$0 = $receiver;
                this.$requestOptions = $requestOptions;
                super(1);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final PayGroupRetrieveResponse invoke(HttpResponse response) {
                Object object = response;
                Object object2 = this.this$0;
                Object object3 = null;
                try {
                    Object it = (HttpResponse)object;
                    boolean bl = false;
                    HttpResponse.Handler handler = PayGroupServiceAsyncImpl.access$getRetrieveHandler$p((PayGroupServiceAsyncImpl)object2);
                    Intrinsics.checkNotNull((Object)it);
                    it = (PayGroupRetrieveResponse)handler.handle((HttpResponse)it);
                }
                catch (Throwable it) {
                    object3 = it;
                    throw it;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)object, (Throwable)object3);
                }
                object = it;
                object2 = this.$requestOptions;
                object3 = this.this$0;
                Object $this$invoke_u24lambda_u241 = object;
                boolean bl = false;
                Boolean bl2 = ((RequestOptions)object2).getResponseValidation();
                if (bl2 != null ? bl2.booleanValue() : PayGroupServiceAsyncImpl.access$getClientOptions$p((PayGroupServiceAsyncImpl)object3).responseValidation()) {
                    ((PayGroupRetrieveResponse)$this$invoke_u24lambda_u241).validate();
                }
                return object;
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"thenApply(...)");
        return completionStage;
    }

    @Override
    @NotNull
    public CompletableFuture<PayrollPayGroupListPageAsync> list(@NotNull PayrollPayGroupListParams params, @NotNull RequestOptions requestOptions) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)requestOptions, (String)"requestOptions");
        String[] stringArray = new String[]{"employer", "pay-groups"};
        HttpRequest request2 = HttpRequest.Companion.builder().method(HttpMethod.GET).addPathSegments(stringArray).putAllQueryParams((Multimap<String, String>)((Multimap)this.clientOptions.queryParams())).putAllQueryParams(params.getQueryParams$finch_java_core()).putAllHeaders((Multimap<String, String>)((Multimap)this.clientOptions.headers())).putAllHeaders(params.getHeaders$finch_java_core()).build();
        CompletionStage completionStage = this.clientOptions.httpClient().executeAsync(request2, requestOptions).thenApply(arg_0 -> PayGroupServiceAsyncImpl.list$lambda$1((Function1)new Function1<HttpResponse, PayrollPayGroupListPageAsync>(this, requestOptions, params){
            final /* synthetic */ PayGroupServiceAsyncImpl this$0;
            final /* synthetic */ RequestOptions $requestOptions;
            final /* synthetic */ PayrollPayGroupListParams $params;
            {
                this.this$0 = $receiver;
                this.$requestOptions = $requestOptions;
                this.$params = $params;
                super(1);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final PayrollPayGroupListPageAsync invoke(HttpResponse response) {
                Object it2;
                Object object = response;
                Object object2 = this.this$0;
                Object object3 = null;
                try {
                    it2 = (HttpResponse)object;
                    boolean bl = false;
                    HttpResponse.Handler handler = PayGroupServiceAsyncImpl.access$getListHandler$p((PayGroupServiceAsyncImpl)object2);
                    Intrinsics.checkNotNull((Object)it2);
                    it2 = (List)handler.handle((HttpResponse)it2);
                }
                catch (Throwable it2) {
                    object3 = it2;
                    throw it2;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)object, (Throwable)object3);
                }
                object = it2;
                object2 = this.$requestOptions;
                object3 = this.this$0;
                Object $this$invoke_u24lambda_u242 = object;
                boolean bl = false;
                Boolean bl2 = ((RequestOptions)object2).getResponseValidation();
                if (bl2 != null ? bl2.booleanValue() : PayGroupServiceAsyncImpl.access$getClientOptions$p((PayGroupServiceAsyncImpl)object3).responseValidation()) {
                    Iterable $this$forEach$iv = (Iterable)$this$invoke_u24lambda_u242;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        PayGroupListResponse it3 = (PayGroupListResponse)element$iv;
                        boolean bl3 = false;
                        it3.validate();
                    }
                }
                Object it4 = object;
                boolean bl4 = false;
                object = new PayrollPayGroupListPageAsync.Response.Builder().items((List<PayGroupListResponse>)it4).build();
                object2 = this.this$0;
                PayrollPayGroupListParams payrollPayGroupListParams = this.$params;
                it2 = object;
                boolean bl5 = false;
                return PayrollPayGroupListPageAsync.Companion.of((PayGroupServiceAsync)object2, payrollPayGroupListParams, (PayrollPayGroupListPageAsync.Response)it2);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"thenApply(...)");
        return completionStage;
    }

    private static final PayGroupRetrieveResponse retrieve$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (PayGroupRetrieveResponse)$tmp0.invoke(p0);
    }

    private static final PayrollPayGroupListPageAsync list$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (PayrollPayGroupListPageAsync)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ HttpResponse.Handler access$getRetrieveHandler$p(PayGroupServiceAsyncImpl $this) {
        return $this.retrieveHandler;
    }

    public static final /* synthetic */ ClientOptions access$getClientOptions$p(PayGroupServiceAsyncImpl $this) {
        return $this.clientOptions;
    }

    public static final /* synthetic */ HttpResponse.Handler access$getListHandler$p(PayGroupServiceAsyncImpl $this) {
        return $this.listHandler;
    }
}

