/*
 * Decompiled with CFR 0.152.
 */
package com.tryfinch.api.services.blocking.payroll;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.google.common.collect.Multimap;
import com.tryfinch.api.core.ClientOptions;
import com.tryfinch.api.core.RequestOptions;
import com.tryfinch.api.core.http.HttpMethod;
import com.tryfinch.api.core.http.HttpRequest;
import com.tryfinch.api.core.http.HttpResponse;
import com.tryfinch.api.errors.FinchError;
import com.tryfinch.api.errors.FinchException;
import com.tryfinch.api.models.PayGroupListResponse;
import com.tryfinch.api.models.PayGroupRetrieveResponse;
import com.tryfinch.api.models.PayrollPayGroupListPage;
import com.tryfinch.api.models.PayrollPayGroupListParams;
import com.tryfinch.api.models.PayrollPayGroupRetrieveParams;
import com.tryfinch.api.services.Handlers;
import com.tryfinch.api.services.blocking.payroll.PayGroupService;
import java.util.List;
import kotlin.Metadata;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/tryfinch/api/services/blocking/payroll/PayGroupServiceImpl;", "Lcom/tryfinch/api/services/blocking/payroll/PayGroupService;", "clientOptions", "Lcom/tryfinch/api/core/ClientOptions;", "(Lcom/tryfinch/api/core/ClientOptions;)V", "errorHandler", "Lcom/tryfinch/api/core/http/HttpResponse$Handler;", "Lcom/tryfinch/api/errors/FinchError;", "listHandler", "", "Lcom/tryfinch/api/models/PayGroupListResponse;", "retrieveHandler", "Lcom/tryfinch/api/models/PayGroupRetrieveResponse;", "list", "Lcom/tryfinch/api/models/PayrollPayGroupListPage;", "params", "Lcom/tryfinch/api/models/PayrollPayGroupListParams;", "requestOptions", "Lcom/tryfinch/api/core/RequestOptions;", "retrieve", "Lcom/tryfinch/api/models/PayrollPayGroupRetrieveParams;", "finch-java-core"})
@SourceDebugExtension(value={"SMAP\nPayGroupServiceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PayGroupServiceImpl.kt\ncom/tryfinch/api/services/blocking/payroll/PayGroupServiceImpl\n+ 2 Handlers.kt\ncom/tryfinch/api/services/Handlers\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,87:1\n59#2:88\n59#2:89\n1#3:90\n1855#4,2:91\n*S KotlinDebug\n*F\n+ 1 PayGroupServiceImpl.kt\ncom/tryfinch/api/services/blocking/payroll/PayGroupServiceImpl\n*L\n28#1:88\n57#1:89\n79#1:91,2\n*E\n"})
public final class PayGroupServiceImpl
implements PayGroupService {
    @NotNull
    private final ClientOptions clientOptions;
    @NotNull
    private final HttpResponse.Handler<FinchError> errorHandler;
    @NotNull
    private final HttpResponse.Handler<PayGroupRetrieveResponse> retrieveHandler;
    @NotNull
    private final HttpResponse.Handler<List<PayGroupListResponse>> listHandler;

    public PayGroupServiceImpl(@NotNull ClientOptions clientOptions) {
        Intrinsics.checkNotNullParameter((Object)clientOptions, (String)"clientOptions");
        this.clientOptions = clientOptions;
        this.errorHandler = Handlers.errorHandler(this.clientOptions.jsonMapper());
        JsonMapper jsonMapper$iv = this.clientOptions.jsonMapper();
        boolean $i$f$jsonHandler = false;
        this.retrieveHandler = Handlers.withErrorHandler(new HttpResponse.Handler<PayGroupRetrieveResponse>(jsonMapper$iv){
            final /* synthetic */ JsonMapper $jsonMapper;
            {
                this.$jsonMapper = $jsonMapper;
            }

            public PayGroupRetrieveResponse handle(@NotNull HttpResponse response) {
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                try {
                    boolean $i$f$jacksonTypeRef = false;
                    return this.$jsonMapper.readValue(response.body(), (TypeReference)new TypeReference<PayGroupRetrieveResponse>(){});
                }
                catch (Exception e) {
                    throw new FinchException("Error reading response", e);
                }
            }
        }, this.errorHandler);
        jsonMapper$iv = this.clientOptions.jsonMapper();
        $i$f$jsonHandler = false;
        this.listHandler = Handlers.withErrorHandler(new HttpResponse.Handler<List<? extends PayGroupListResponse>>(jsonMapper$iv){
            final /* synthetic */ JsonMapper $jsonMapper;
            {
                this.$jsonMapper = $jsonMapper;
            }

            public List<? extends PayGroupListResponse> handle(@NotNull HttpResponse response) {
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                try {
                    boolean $i$f$jacksonTypeRef = false;
                    return this.$jsonMapper.readValue(response.body(), (TypeReference)new TypeReference<List<? extends PayGroupListResponse>>(){});
                }
                catch (Exception e) {
                    throw new FinchException("Error reading response", e);
                }
            }
        }, this.errorHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public PayGroupRetrieveResponse retrieve(@NotNull PayrollPayGroupRetrieveParams params, @NotNull RequestOptions requestOptions) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)requestOptions, (String)"requestOptions");
        String[] stringArray = new String[]{"employer", "pay-groups", params.getPathParam(0)};
        HttpRequest request2 = HttpRequest.Companion.builder().method(HttpMethod.GET).addPathSegments(stringArray).putAllQueryParams((Multimap<String, String>)((Multimap)this.clientOptions.queryParams())).putAllQueryParams(params.getQueryParams$finch_java_core()).putAllHeaders((Multimap<String, String>)((Multimap)this.clientOptions.headers())).putAllHeaders(params.getHeaders$finch_java_core()).build();
        HttpResponse response = this.clientOptions.httpClient().execute(request2, requestOptions);
        boolean bl = false;
        Object object = response;
        Throwable throwable = null;
        try {
            Object it = (HttpResponse)object;
            boolean bl2 = false;
            it = this.retrieveHandler.handle((HttpResponse)it);
        }
        catch (Throwable it) {
            throwable = it;
            throw it;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)object, (Throwable)throwable);
        }
        Object $this$retrieve_u24lambda_u242_u24lambda_u241 = object = it;
        boolean bl3 = false;
        Boolean bl4 = requestOptions.getResponseValidation();
        if (bl4 != null ? bl4.booleanValue() : this.clientOptions.responseValidation()) {
            ((PayGroupRetrieveResponse)$this$retrieve_u24lambda_u242_u24lambda_u241).validate();
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public PayrollPayGroupListPage list(@NotNull PayrollPayGroupListParams params, @NotNull RequestOptions requestOptions) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)requestOptions, (String)"requestOptions");
        String[] stringArray = new String[]{"employer", "pay-groups"};
        HttpRequest request2 = HttpRequest.Companion.builder().method(HttpMethod.GET).addPathSegments(stringArray).putAllQueryParams((Multimap<String, String>)((Multimap)this.clientOptions.queryParams())).putAllQueryParams(params.getQueryParams$finch_java_core()).putAllHeaders((Multimap<String, String>)((Multimap)this.clientOptions.headers())).putAllHeaders(params.getHeaders$finch_java_core()).build();
        HttpResponse response = this.clientOptions.httpClient().execute(request2, requestOptions);
        boolean bl = false;
        Object object = response;
        Throwable throwable = null;
        try {
            Object it = (HttpResponse)object;
            boolean bl2 = false;
            it = this.listHandler.handle((HttpResponse)it);
        }
        catch (Throwable it) {
            throwable = it;
            throw it;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)object, (Throwable)throwable);
        }
        Object $this$list_u24lambda_u248_u24lambda_u245 = object = it;
        boolean bl3 = false;
        Boolean bl4 = requestOptions.getResponseValidation();
        if (bl4 != null ? bl4.booleanValue() : this.clientOptions.responseValidation()) {
            Iterable $this$forEach$iv = (Iterable)$this$list_u24lambda_u248_u24lambda_u245;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PayGroupListResponse it = (PayGroupListResponse)element$iv;
                boolean bl5 = false;
                it.validate();
            }
        }
        Object it = object;
        boolean bl6 = false;
        it = new PayrollPayGroupListPage.Response.Builder().items((List<PayGroupListResponse>)it).build();
        boolean bl7 = false;
        return PayrollPayGroupListPage.Companion.of(this, params, (PayrollPayGroupListPage.Response)it);
    }
}

