package com.tryfinch.api.core.http

import java.io.InputStream
import java.lang.AutoCloseable

interface HttpResponse : AutoCloseable {

    fun statusCode(): Int

    fun headers(): Headers

    fun body(): InputStream

    interface Handler<T> {

        fun handle(response: HttpResponse): T
    }
}
