/*
 * Decompiled with CFR 0.152.
 */
package com.versionone.om;

import com.versionone.apiclient.APIException;
import com.versionone.apiclient.Asset;
import com.versionone.apiclient.ConnectionException;
import com.versionone.apiclient.IAttributeDefinition;
import com.versionone.apiclient.OidException;
import com.versionone.apiclient.RequiredFieldValidator;
import com.versionone.om.Entity;
import com.versionone.om.V1Instance;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityValidator {
    private final V1Instance v1Instance;
    private final RequiredFieldValidator validator;

    public EntityValidator(V1Instance instance) {
        this.v1Instance = instance;
        this.validator = this.v1Instance.getRequiredFieldValidator();
    }

    public boolean validate(Entity entity, String attribute) throws APIException, ConnectionException, OidException {
        Asset asset = this.v1Instance.getAsset(entity.getInstanceKey()) != null ? this.v1Instance.getAsset(entity.getInstanceKey()) : this.v1Instance.getAsset(entity.getID());
        IAttributeDefinition attributeDefinition = asset.getAssetType().getAttributeDefinition(attribute);
        return this.validator.validate(asset, attributeDefinition);
    }

    public List<String> validate(Entity entity) throws APIException, ConnectionException, OidException {
        Asset asset = this.v1Instance.getAsset(entity.getInstanceKey()) != null ? this.v1Instance.getAsset(entity.getInstanceKey()) : this.v1Instance.getAsset(entity.getID());
        return this.validate(asset);
    }

    public Map<Entity, List<String>> validate(Entity[] entities) throws APIException, ConnectionException, OidException {
        HashMap<Entity, List<String>> results = new HashMap<Entity, List<String>>();
        for (Entity entity : entities) {
            results.put(entity, this.validate(entity));
        }
        return results;
    }

    List<String> validate(Asset asset) throws APIException, ConnectionException, OidException {
        List result = this.validator.validate(asset);
        return EntityValidator.getAttributeNames(result);
    }

    private static List<String> getAttributeNames(List<IAttributeDefinition> attributeDefinitions) {
        ArrayList<String> attributeNames = new ArrayList<String>(attributeDefinitions.size());
        for (IAttributeDefinition attributeDefinition : attributeDefinitions) {
            attributeNames.add(attributeDefinition.getName());
        }
        return attributeNames;
    }
}

