/*
 * Decompiled with CFR 0.152.
 */
package com.versionone.om;

import com.versionone.om.AssetID;
import com.versionone.om.Defect;
import com.versionone.om.Goal;
import com.versionone.om.IListValueProperty;
import com.versionone.om.Issue;
import com.versionone.om.Member;
import com.versionone.om.MetaDataAttribute;
import com.versionone.om.MetaRenamedAttribute;
import com.versionone.om.PrimaryWorkitem;
import com.versionone.om.Rank;
import com.versionone.om.Request;
import com.versionone.om.Story;
import com.versionone.om.Test;
import com.versionone.om.TestSet;
import com.versionone.om.V1Instance;
import com.versionone.om.Workitem;
import com.versionone.om.filters.DefectFilter;
import com.versionone.om.filters.EpicFilter;
import com.versionone.om.filters.PrimaryWorkitemFilter;
import com.versionone.om.filters.StoryFilter;
import com.versionone.om.filters.TestFilter;
import com.versionone.om.filters.TestSetFilter;
import com.versionone.om.listvalue.EpicPriority;
import com.versionone.om.listvalue.EpicStatus;
import com.versionone.om.listvalue.EpicType;
import com.versionone.om.listvalue.WorkitemSource;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@MetaDataAttribute(value="Epic")
public class Epic
extends Workitem {
    Epic(AssetID id, V1Instance instance) {
        super(id, instance);
    }

    Epic(V1Instance instance) {
        super(instance);
    }

    public Epic getSuper() {
        return this.getRelation(Epic.class, "Super");
    }

    public void setSuper(Epic value) {
        this.setRelation("Super", value);
    }

    public Workitem getParent() {
        return this.getRelation(Workitem.class, "Parent");
    }

    public Double getSwag() {
        return (Double)this.get("Swag");
    }

    public void setSwag(Double value) {
        this.set("Swag", value);
    }

    public Double getValue() {
        return (Double)this.get("Value");
    }

    public void setValue(Double value) {
        this.set("Value", value);
    }

    public IListValueProperty getStatus() {
        return this.getListValue(EpicStatus.class, "Status");
    }

    public IListValueProperty getPriority() {
        return this.getListValue(EpicPriority.class, "Priority");
    }

    public IListValueProperty getSource() {
        return this.getListValue(WorkitemSource.class, "Source");
    }

    public Double getRisk() {
        return (Double)this.get("Risk");
    }

    public void setRisk(Double value) {
        this.set("Risk", value);
    }

    @MetaRenamedAttribute(value="Category")
    public IListValueProperty getType() {
        return this.getListValue(EpicType.class, "Category");
    }

    @MetaRenamedAttribute(value="Order")
    public Rank<Epic> getRankOrder() {
        return this.getRank("Order");
    }

    public Collection<Epic> getChildEpics(EpicFilter filter) {
        filter = filter != null ? filter : new EpicFilter();
        filter.parent.clear();
        filter.parent.add(this);
        return this.getInstance().get().epics(filter);
    }

    public Collection<Story> getChildStories(StoryFilter filter) {
        filter = filter != null ? filter : new StoryFilter();
        filter.epic.clear();
        filter.epic.add(this);
        return this.getInstance().get().story(filter);
    }

    public Collection<Test> getChildTests(TestFilter filter) {
        filter = filter != null ? filter : new TestFilter();
        filter.epic.clear();
        filter.epic.add(this);
        return this.getInstance().get().tests(filter);
    }

    public Collection<Defect> getChildDefects(DefectFilter filter) {
        filter = filter != null ? filter : new DefectFilter();
        filter.epic.clear();
        filter.epic.add(this);
        return this.getInstance().get().defects(filter);
    }

    public Collection<TestSet> getChildTestSets(TestSetFilter filter) {
        filter = filter != null ? filter : new TestSetFilter();
        filter.epic.clear();
        filter.epic.add(this);
        return this.getInstance().get().testSets(filter);
    }

    public Collection<PrimaryWorkitem> getChildPrimaryWorkitems(PrimaryWorkitemFilter filter) {
        filter = filter != null ? filter : new PrimaryWorkitemFilter();
        filter.epic.clear();
        filter.epic.add(this);
        return this.getInstance().get().primaryWorkitems(filter);
    }

    @Override
    public Collection<Member> getOwners() {
        return this.getMultiRelation("Owners");
    }

    public Collection<Goal> getGoals() {
        return this.getMultiRelation("Goals");
    }

    public Collection<Request> getRequests() {
        return this.getMultiRelation("Requests");
    }

    public Collection<Issue> getIssues() {
        return this.getMultiRelation("Issues");
    }

    public Collection<Issue> getBlockingIssues() {
        return this.getMultiRelation("BlockingIssues");
    }

    public String getRequestedBy() {
        return (String)this.get("RequestedBy");
    }

    public void setRequestedBy(String value) {
        this.set("RequestedBy", value);
    }

    @Override
    void closeImpl() throws UnsupportedOperationException {
        this.getInstance().executeOperation(this, "Inactivate");
    }

    @Override
    void reactivateImpl() throws UnsupportedOperationException {
        this.getInstance().executeOperation(this, "Reactivate");
    }

    public boolean canGenerateChildStory() {
        return (Boolean)this.get("CheckGenerateSubStory");
    }

    public Story generateChildStory() throws UnsupportedOperationException {
        this.save();
        return this.getInstance().executeOperation(Story.class, this, "GenerateSubStory");
    }

    public boolean canGenerateChildEpic() {
        return (Boolean)this.get("CheckGenerateSubEpic");
    }

    public Epic generateChildEpic() throws UnsupportedOperationException {
        this.save();
        return this.getInstance().executeOperation(Epic.class, this, "GenerateSubEpic");
    }
}

