/*
 * Decompiled with CFR 0.152.
 */
package com.versionone.om;

import com.versionone.DB;
import com.versionone.om.AssetID;
import com.versionone.om.Defect;
import com.versionone.om.Epic;
import com.versionone.om.IListValueProperty;
import com.versionone.om.Member;
import com.versionone.om.MetaDataAttribute;
import com.versionone.om.MetaRenamedAttribute;
import com.versionone.om.PrimaryWorkitem;
import com.versionone.om.ProjectAsset;
import com.versionone.om.Rank;
import com.versionone.om.Request;
import com.versionone.om.Retrospective;
import com.versionone.om.Story;
import com.versionone.om.Team;
import com.versionone.om.V1Instance;
import com.versionone.om.filters.EpicFilter;
import com.versionone.om.filters.PrimaryWorkitemFilter;
import com.versionone.om.filters.RequestFilter;
import com.versionone.om.listvalue.IssuePriority;
import com.versionone.om.listvalue.IssueResolutionReason;
import com.versionone.om.listvalue.IssueType;
import com.versionone.om.listvalue.WorkitemSource;
import java.util.Collection;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@MetaDataAttribute(value="Issue")
public class Issue
extends ProjectAsset {
    private static final String TARGET_DATE = "TargetDate";

    Issue(AssetID id, V1Instance instance) {
        super(id, instance);
    }

    Issue(V1Instance instance) {
        super(instance);
    }

    @MetaRenamedAttribute(value="Order")
    public Rank<Issue> getRankOrder() {
        return this.getRank("Order");
    }

    public Collection<PrimaryWorkitem> getPrimaryWorkitems(PrimaryWorkitemFilter filter) {
        filter = filter != null ? filter : new PrimaryWorkitemFilter();
        filter.issues.clear();
        filter.issues.add(this);
        return this.getInstance().get().primaryWorkitems(filter);
    }

    public Collection<Request> getRequests(RequestFilter filter) {
        filter = filter != null ? filter : new RequestFilter();
        filter.issues.clear();
        filter.issues.add(this);
        return this.getInstance().get().requests(filter);
    }

    public Collection<PrimaryWorkitem> getBlockedPrimaryWorkitems(PrimaryWorkitemFilter filter) {
        filter = filter != null ? filter : new PrimaryWorkitemFilter();
        filter.issues.clear();
        filter.issues.add(this);
        return this.getInstance().get().primaryWorkitems(filter);
    }

    public Collection<Epic> getBlockedEpics(EpicFilter filter) {
        filter = filter != null ? filter : new EpicFilter();
        filter.blockingIssues.clear();
        filter.blockingIssues.add(this);
        return this.getInstance().get().epics(filter);
    }

    public Collection<Epic> getEpics(EpicFilter filter) {
        filter = filter != null ? filter : new EpicFilter();
        filter.issues.clear();
        filter.issues.add(this);
        return this.getInstance().get().epics(filter);
    }

    public IListValueProperty getSource() {
        return this.getListValue(WorkitemSource.class, "Source");
    }

    public IListValueProperty getType() {
        return this.getListValue(IssueType.class, "Category");
    }

    public IListValueProperty getPriority() {
        return this.getListValue(IssuePriority.class, "Priority");
    }

    public IListValueProperty getResolutionReason() {
        return this.getListValue(IssueResolutionReason.class, "ResolutionReason");
    }

    public String getResolutionDetails() {
        return (String)this.get("Resolution");
    }

    public void setResolutionDetails(String value) {
        this.set("Resolution", value);
    }

    public String getIdentifiedBy() {
        return (String)this.get("IdentifiedBy");
    }

    public void setIdentifiedBy(String value) {
        this.set("IdentifiedBy", value);
    }

    public String getReference() {
        return (String)this.get("Reference");
    }

    public void setReference(String value) {
        this.set("Reference", value);
    }

    public DB.DateTime getTargetDate() {
        return new DB.DateTime(this.get(TARGET_DATE));
    }

    public void setTargetDate(DB.DateTime value) {
        this.set(TARGET_DATE, value.getDate());
    }

    public Team getTeam() {
        return this.getRelation(Team.class, "Team");
    }

    public void setTeam(Team value) {
        this.setRelation("Team", value);
    }

    public Member getOwner() {
        return this.getRelation(Member.class, "Owner");
    }

    public void setOwner(Member value) {
        this.setRelation("Owner", value);
    }

    public Collection<Retrospective> getRetrospectives() {
        return this.getMultiRelation("Retrospectives");
    }

    @Override
    void closeImpl() throws UnsupportedOperationException {
        this.getInstance().executeOperation(this, "Inactivate");
    }

    @Override
    void reactivateImpl() throws UnsupportedOperationException {
        this.getInstance().executeOperation(this, "Reactivate");
    }

    public Story generateStory() {
        return this.generateStory(null);
    }

    public Story generateStory(Map<String, Object> attributes) {
        Story result = this.getInstance().createNew(Story.class, this);
        this.getInstance().create().addAttributes(result, attributes);
        result.save();
        return result;
    }

    public Defect generateDefect() {
        return this.generateDefect(null);
    }

    public Defect generateDefect(Map<String, Object> attributes) {
        Defect result = this.getInstance().createNew(Defect.class, this);
        this.getInstance().create().addAttributes(result, attributes);
        result.save();
        return result;
    }
}

