/*
 * Decompiled with CFR 0.152.
 */
package com.versionone.om;

import com.versionone.DB;
import com.versionone.om.ApplicationUnavailableException;
import com.versionone.om.AssetID;
import com.versionone.om.BaseAsset;
import com.versionone.om.Effort;
import com.versionone.om.MetaDataAttribute;
import com.versionone.om.PrimaryWorkitem;
import com.versionone.om.Schedule;
import com.versionone.om.State;
import com.versionone.om.V1Instance;
import com.versionone.om.filters.EffortFilter;
import com.versionone.om.filters.PrimaryWorkitemFilter;
import com.versionone.om.filters.WorkitemFilter;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@MetaDataAttribute(value="Timebox")
public class Iteration
extends BaseAsset {
    Iteration(AssetID id, V1Instance instance) {
        super(id, instance);
    }

    Iteration(V1Instance instance) {
        super(instance);
        this.setRelation("State", State.FUTURE);
    }

    public Schedule getSchedule() {
        return this.getRelation(Schedule.class, "Schedule");
    }

    public void setSchedule(Schedule value) {
        this.setRelation("Schedule", value);
    }

    public DB.DateTime getBeginDate() {
        return new DB.DateTime(this.get("BeginDate"));
    }

    public void setBeginDate(DB.DateTime value) {
        this.set("BeginDate", value.getDate());
    }

    public DB.DateTime getEndDate() {
        return new DB.DateTime(this.get("EndDate"));
    }

    public void setEndDate(DB.DateTime value) {
        this.set("EndDate", value.getDate());
    }

    public Collection<PrimaryWorkitem> getPrimaryWorkitems(PrimaryWorkitemFilter filter) {
        filter = filter != null ? filter : new PrimaryWorkitemFilter();
        filter.iteration.clear();
        filter.iteration.add(this);
        return this.getInstance().get().primaryWorkitems(filter);
    }

    public Collection<Effort> getEffortRecords(EffortFilter filter) {
        filter = filter == null ? new EffortFilter() : filter;
        filter.iteration.clear();
        filter.iteration.add(this);
        return this.getInstance().get().effortRecords(filter);
    }

    public boolean canActivate() {
        return this.getInstance().canExecuteOperation(this, "Activate");
    }

    public void activate() throws UnsupportedOperationException {
        this.save();
        this.getInstance().executeOperation(this, "Activate");
    }

    public boolean isFuture() {
        return Byte.valueOf(this.get("AssetState").toString()) == 0;
    }

    public boolean canMakeFuture() {
        return this.getInstance().canExecuteOperation(this, "MakeFuture");
    }

    public void makeFuture() throws UnsupportedOperationException {
        this.save();
        this.getInstance().executeOperation(this, "MakeFuture");
    }

    @Override
    boolean canCloseImpl() throws ApplicationUnavailableException {
        return this.getInstance().canExecuteOperation(this, "Close");
    }

    @Override
    void closeImpl() throws UnsupportedOperationException {
        this.getInstance().executeOperation(this, "Close");
    }

    @Override
    void reactivateImpl() throws UnsupportedOperationException {
        this.getInstance().executeOperation(this, "Reactivate");
    }

    public Double getTotalEstimate(PrimaryWorkitemFilter filter) {
        filter = filter == null ? new PrimaryWorkitemFilter() : filter;
        return this.getSum("Workitems:PrimaryWorkitem", filter, "Estimate");
    }

    public Double getTotalDetailEstimate(WorkitemFilter filter) {
        filter = filter == null ? new WorkitemFilter() : filter;
        return this.getSum("Workitems", filter, "DetailEstimate");
    }

    public Double getTotalToDo(WorkitemFilter filter) {
        filter = filter == null ? new WorkitemFilter() : filter;
        return this.getSum("Workitems", filter, "ToDo");
    }

    public Double getTotalDone(WorkitemFilter filter) {
        filter = filter == null ? new WorkitemFilter() : filter;
        return this.getSum("Workitems", filter, "Actuals.Value");
    }
}

