/*
 * Decompiled with CFR 0.152.
 */
package com.versionone.om;

import com.versionone.DB;
import com.versionone.om.AssetID;
import com.versionone.om.BaseAsset;
import com.versionone.om.BuildProject;
import com.versionone.om.Defect;
import com.versionone.om.DefectTemplate;
import com.versionone.om.Effort;
import com.versionone.om.EntityCollection;
import com.versionone.om.Environment;
import com.versionone.om.Epic;
import com.versionone.om.Goal;
import com.versionone.om.IListValueProperty;
import com.versionone.om.Issue;
import com.versionone.om.Iteration;
import com.versionone.om.Member;
import com.versionone.om.MetaDataAttribute;
import com.versionone.om.MetaRenamedAttribute;
import com.versionone.om.PrimaryWorkitem;
import com.versionone.om.RegressionPlan;
import com.versionone.om.RegressionSuite;
import com.versionone.om.RegressionTest;
import com.versionone.om.Request;
import com.versionone.om.Retrospective;
import com.versionone.om.Schedule;
import com.versionone.om.SecondaryWorkitem;
import com.versionone.om.Story;
import com.versionone.om.StoryTemplate;
import com.versionone.om.Task;
import com.versionone.om.Test;
import com.versionone.om.TestSet;
import com.versionone.om.TestSuite;
import com.versionone.om.Theme;
import com.versionone.om.V1Instance;
import com.versionone.om.filters.DefectFilter;
import com.versionone.om.filters.EffortFilter;
import com.versionone.om.filters.EntityFilter;
import com.versionone.om.filters.EpicFilter;
import com.versionone.om.filters.GoalFilter;
import com.versionone.om.filters.IssueFilter;
import com.versionone.om.filters.IterationFilter;
import com.versionone.om.filters.PrimaryWorkitemFilter;
import com.versionone.om.filters.ProjectAssetFilter;
import com.versionone.om.filters.ProjectFilter;
import com.versionone.om.filters.RegressionPlanFilter;
import com.versionone.om.filters.RequestFilter;
import com.versionone.om.filters.RetrospectiveFilter;
import com.versionone.om.filters.SecondaryWorkitemFilter;
import com.versionone.om.filters.StoryFilter;
import com.versionone.om.filters.TaskFilter;
import com.versionone.om.filters.TestFilter;
import com.versionone.om.filters.TestSetFilter;
import com.versionone.om.filters.ThemeFilter;
import com.versionone.om.filters.WorkitemFilter;
import com.versionone.om.listvalue.ProjectStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@MetaDataAttribute(value="Scope")
public class Project
extends BaseAsset {
    private static final String PARENT = "Parent";
    private static final String BEGIN_DATE = "BeginDate";
    private static final String END_DATE = "EndDate";
    private static final String OWNER = "Owner";
    private static final String TEST_SUITE = "TestSuite";
    private static final String SCHEDULE = "Schedule";

    Project(AssetID id, V1Instance instance) {
        super(id, instance);
    }

    Project(V1Instance instance) {
        super(instance);
    }

    @MetaRenamedAttribute(value="Parent")
    public Project getParentProject() {
        return this.getRelation(Project.class, PARENT);
    }

    public void setParentProject(Project parentProject) {
        this.setRelation(PARENT, parentProject);
    }

    public DB.DateTime getBeginDate() {
        Object date = this.get(BEGIN_DATE);
        return date == null ? null : new DB.DateTime(date);
    }

    public void setBeginDate(DB.DateTime beginDate) {
        this.set(BEGIN_DATE, beginDate.getDate());
    }

    public DB.DateTime getEndDate() {
        Object date = this.get(END_DATE);
        return date == null ? null : new DB.DateTime(date);
    }

    public void setEndDate(DB.DateTime value) {
        this.set(END_DATE, value.getDate());
    }

    public Schedule getSchedule() {
        return this.getRelation(Schedule.class, SCHEDULE);
    }

    public void setSchedule(Schedule schedule) {
        this.setRelation(SCHEDULE, schedule);
    }

    public Member getOwner() {
        return this.getRelation(Member.class, OWNER);
    }

    public void setOwner(Member owner) {
        this.setRelation(OWNER, owner);
    }

    public TestSuite getTestSuite() {
        return this.getRelation(TestSuite.class, TEST_SUITE);
    }

    public void setTestSuite(TestSuite testSuite) {
        this.setRelation(TEST_SUITE, testSuite);
    }

    public IListValueProperty getStatus() {
        return this.getListValue(ProjectStatus.class, "Status");
    }

    public Collection<BuildProject> getBuildProjects() {
        return this.getMultiRelation("BuildProjects");
    }

    public Project createSubProject(String name, DB.DateTime beginDate, Schedule schedule) {
        return this.getInstance().create().project(name, this, beginDate, schedule);
    }

    public Project createSubProject(String name, DB.DateTime beginDate, Schedule schedule, Map<String, Object> attributes) {
        return this.getInstance().create().project(name, this, beginDate, schedule, attributes);
    }

    public Project createSubProject(String name, DB.DateTime beginDate) {
        return this.createSubProject(name, beginDate, null);
    }

    public Epic createEpic(String name) {
        return this.getInstance().create().epic(name, this);
    }

    public Epic createEpic(String name, Map<String, Object> attributes) {
        return this.getInstance().create().epic(name, this, attributes);
    }

    public Story createStory(String name) {
        return this.getInstance().create().story(name, this);
    }

    public Story createStory(String name, Map<String, Object> attributes) {
        return this.getInstance().create().story(name, this, attributes);
    }

    public Defect createDefect(String name) {
        return this.getInstance().create().defect(name, this);
    }

    public Defect createDefect(String name, Map<String, Object> attributes) {
        return this.getInstance().create().defect(name, this, attributes);
    }

    public Theme createTheme(String name) {
        return this.getInstance().create().theme(name, this);
    }

    public Theme createTheme(String name, Map<String, Object> attributes) {
        return this.getInstance().create().theme(name, this, attributes);
    }

    public Goal createGoal(String name) {
        return this.getInstance().create().goal(name, this);
    }

    public Goal createGoal(String name, Map<String, Object> attributes) {
        return this.getInstance().create().goal(name, this, attributes);
    }

    public Request createRequest(String name) {
        return this.getInstance().create().request(name, this);
    }

    public Request createRequest(String name, Map<String, Object> attributes) {
        return this.getInstance().create().request(name, this, attributes);
    }

    public Issue createIssue(String name) {
        return this.getInstance().create().issue(name, this);
    }

    public Issue createIssue(String name, Map<String, Object> attributes) {
        return this.getInstance().create().issue(name, this, attributes);
    }

    public Retrospective createRetrospective(String name) {
        return this.getInstance().create().retrospective(name, this);
    }

    public Retrospective createRetrospective(String name, Map<String, Object> attributes) {
        return this.getInstance().create().retrospective(name, this, attributes);
    }

    public Iteration createIteration() {
        return this.getInstance().create().iteration(this);
    }

    public Iteration createIteration(Map<String, Object> attributes) {
        return this.getInstance().create().iteration(this, attributes);
    }

    public Iteration createIteration(String name, DB.DateTime beginDate, DB.DateTime endDate) {
        return this.getInstance().create().iteration(name, this.getSchedule(), beginDate, endDate);
    }

    public Iteration createIteration(String name, DB.DateTime beginDate, DB.DateTime endDate, Map<String, Object> attributes) {
        return this.getInstance().create().iteration(name, this.getSchedule(), beginDate, endDate, attributes);
    }

    public RegressionPlan createRegressionPlan(String name) {
        return this.getInstance().create().regressionPlan(name, this);
    }

    public RegressionPlan createRegressionPlan(String name, Map<String, Object> attributes) {
        return this.getInstance().create().regressionPlan(name, this, attributes);
    }

    public TestSet createTestSet(String name, RegressionSuite suite, Map<String, Object> attributes) {
        return this.getInstance().create().testSet(name, suite, this, attributes);
    }

    public TestSet createTestSet(String name, RegressionSuite suite) {
        return this.getInstance().create().testSet(name, suite, this, null);
    }

    public Environment createEnvironment(String name) {
        return this.getInstance().create().environment(name, this);
    }

    public Environment createEnvironment(String name, Map<String, Object> attributes) {
        return this.getInstance().create().environment(name, this, attributes);
    }

    public RegressionTest createRegressionTest(String name) {
        return this.getInstance().create().regressionTest(name, this);
    }

    public RegressionTest createRegressionTest(String name, Map<String, Object> attributes) {
        return this.getInstance().create().regressionTest(name, this, attributes);
    }

    public Collection<Member> getAssignedMembers() {
        return this.getMultiRelation("Members");
    }

    public Collection<StoryTemplate> getStoryTemplates() {
        EntityCollection c = this.getMultiRelation("Workitems[AssetType='Story';AssetState='200']");
        return c.asReadOnly();
    }

    public Collection<DefectTemplate> getDefectTemplates() {
        EntityCollection c = this.getMultiRelation("Workitems[AssetType='Defect';AssetState='200']");
        return c.asReadOnly();
    }

    public Collection<Project> getThisAndAllChildProjects() {
        EntityCollection x = this.getMultiRelation("ChildrenMeAndDown[AssetState!='Closed']");
        return x.asReadOnly();
    }

    private <T extends ProjectAssetFilter> T getFilter(T filter, boolean includeSubprojects) {
        assert (filter != null);
        filter.project.clear();
        if (includeSubprojects) {
            filter.project.addAll(this.getThisAndAllChildProjects());
        } else {
            filter.project.add(this);
        }
        return filter;
    }

    public Collection<Project> getChildProjects(ProjectFilter filter) {
        return this.getChildProjects(filter, false);
    }

    public Collection<Project> getChildProjects(ProjectFilter filter, boolean includeSubprojects) {
        if (filter == null) {
            filter = new ProjectFilter();
        }
        filter.parent.clear();
        if (includeSubprojects) {
            filter.parent.addAll(this.getThisAndAllChildProjects());
        } else {
            filter.parent.add(this);
        }
        return this.getInstance().get().projects(filter);
    }

    public Collection<Effort> getEffortRecords(EffortFilter filter) {
        return this.getEffortRecords(filter, false);
    }

    public Collection<Effort> getEffortRecords(EffortFilter filter, boolean includeSubprojects) {
        filter = filter != null ? filter : new EffortFilter();
        filter.project.clear();
        if (includeSubprojects) {
            for (Project p : this.getThisAndAllChildProjects()) {
                filter.project.add(p);
            }
        } else {
            filter.project.add(this);
        }
        return this.getInstance().get().effortRecords(filter);
    }

    public Collection<Epic> getEpics(EpicFilter filter) {
        return this.getEpics(filter, false);
    }

    public Collection<Epic> getEpics(EpicFilter filter, boolean includeSubprojects) {
        filter = filter != null ? filter : new EpicFilter();
        return this.getInstance().get().epics(this.getFilter(filter, includeSubprojects));
    }

    public Collection<Epic> GetTrackedEpics() {
        ArrayList<Project> projects = new ArrayList<Project>();
        projects.add(this);
        return this.getInstance().get().trackedEpics(projects);
    }

    public Collection<Story> getStories(StoryFilter filter) {
        return this.getStories(filter, false);
    }

    public Collection<Story> getStories(StoryFilter filter, boolean includeSubprojects) {
        filter = filter != null ? filter : new StoryFilter();
        return this.getInstance().get().story(this.getFilter(filter, includeSubprojects));
    }

    public Collection<Defect> getDefects(DefectFilter filter) {
        return this.getDefects(filter, false);
    }

    public Collection<Defect> getDefects(DefectFilter filter, boolean includeSubprojects) {
        if (filter == null) {
            filter = new DefectFilter();
        }
        return this.getInstance().get().defects(this.getFilter(filter, includeSubprojects));
    }

    public Collection<TestSet> getTestSets(TestSetFilter filter) {
        return this.getTestSets(filter, false);
    }

    public Collection<TestSet> getTestSets(TestSetFilter filter, boolean includeSubprojects) {
        return this.getInstance().get().testSets(this.getFilter(filter, includeSubprojects));
    }

    public Collection<PrimaryWorkitem> getPrimaryWorkitems(PrimaryWorkitemFilter filter) {
        return this.getPrimaryWorkitems(filter, false);
    }

    public Collection<PrimaryWorkitem> getPrimaryWorkitems(PrimaryWorkitemFilter filter, boolean includeSubprojects) {
        filter = filter != null ? filter : new PrimaryWorkitemFilter();
        return this.getInstance().get().primaryWorkitems(this.getFilter(filter, includeSubprojects));
    }

    public Collection<Iteration> getIterations(IterationFilter filter) {
        return this.getIterations(filter, false);
    }

    public Collection<Iteration> getIterations(IterationFilter filter, boolean includeSubprojects) {
        filter = filter != null ? filter : new IterationFilter();
        filter.schedule.clear();
        if (includeSubprojects) {
            for (Project p : this.getThisAndAllChildProjects()) {
                filter.schedule.add(p.getSchedule());
            }
        } else {
            filter.schedule.add(this.getSchedule());
        }
        return this.getInstance().get().iterations(filter);
    }

    public Collection<Theme> getThemes(ThemeFilter filter) {
        return this.getThemes(filter, false);
    }

    public Collection<Theme> getThemes(ThemeFilter filter, boolean includeSubprojects) {
        filter = filter != null ? filter : new ThemeFilter();
        return this.getInstance().get().themes(this.getFilter(filter, includeSubprojects));
    }

    public Collection<SecondaryWorkitem> getSecondaryWorkitems(SecondaryWorkitemFilter filter) {
        return this.getSecondaryWorkitems(filter, false);
    }

    public Collection<SecondaryWorkitem> getSecondaryWorkitems(SecondaryWorkitemFilter filter, boolean includeSubprojects) {
        filter = filter != null ? filter : new SecondaryWorkitemFilter();
        return this.getInstance().get().secondaryWorkitems(this.getFilter(filter, includeSubprojects));
    }

    public Collection<Task> getTasks(TaskFilter filter) {
        filter = filter != null ? filter : new TaskFilter();
        return this.getInstance().get().tasks(this.getFilter(filter, false));
    }

    public Collection<Test> getTests(TestFilter filter) {
        filter = filter != null ? filter : new TestFilter();
        return this.getInstance().get().tests(this.getFilter(filter, false));
    }

    public Collection<Request> getRequests(RequestFilter filter) {
        return this.getRequests(filter, false);
    }

    public Collection<Request> getRequests(RequestFilter filter, boolean includeSubprojects) {
        filter = filter != null ? filter : new RequestFilter();
        return this.getInstance().get().requests(this.getFilter(filter, includeSubprojects));
    }

    public Collection<Goal> getGoals(GoalFilter filter) {
        return this.getGoals(filter, false);
    }

    public Collection<Goal> getGoals(GoalFilter filter, boolean includeSubprojects) {
        filter = filter != null ? filter : new GoalFilter();
        return this.getInstance().get().goals(this.getFilter(filter, includeSubprojects));
    }

    public Collection<Retrospective> getRetrospectives(RetrospectiveFilter filter) {
        return this.getRetrospectives(filter, false);
    }

    public Collection<Retrospective> getRetrospectives(RetrospectiveFilter filter, boolean includeSubprojects) {
        filter = filter != null ? filter : new RetrospectiveFilter();
        return this.getInstance().get().retrospectives(this.getFilter(filter, includeSubprojects));
    }

    public Collection<Issue> getIssues(IssueFilter filter) {
        return this.getIssues(filter, false);
    }

    public Collection<Issue> getIssues(IssueFilter filter, boolean includeSubprojects) {
        filter = filter != null ? filter : new IssueFilter();
        return this.getInstance().get().issues(this.getFilter(filter, includeSubprojects));
    }

    public Collection<RegressionPlan> getRegressionPlans(RegressionPlanFilter filter, boolean includeSubprojects) {
        filter = filter != null ? filter : new RegressionPlanFilter();
        filter.project.clear();
        if (includeSubprojects) {
            for (Project project : this.getThisAndAllChildProjects()) {
                filter.project.add(project);
            }
        } else {
            filter.project.add(this);
        }
        return this.getInstance().get().regressionPlans(filter);
    }

    public Collection<RegressionPlan> getRegressionPlans(RegressionPlanFilter filter) {
        return this.getRegressionPlans(filter, false);
    }

    @Override
    void closeImpl() throws UnsupportedOperationException {
        this.getInstance().executeOperation(this, "Inactivate");
    }

    @Override
    void reactivateImpl() throws UnsupportedOperationException {
        this.getInstance().executeOperation(this, "Reactivate");
    }

    private Double getRollup(String multiRelation, String attribute, EntityFilter filter, boolean includeChildProjects) {
        if (includeChildProjects) {
            multiRelation = "ChildrenMeAndDown[AssetState!='Closed']." + multiRelation;
        }
        return this.getSum(multiRelation, filter, attribute);
    }

    public Double getTotalEstimate(PrimaryWorkitemFilter filter, boolean includeChildProjects) {
        filter = filter != null ? filter : new PrimaryWorkitemFilter();
        return this.getRollup("Workitems:PrimaryWorkitem", "Estimate", filter, includeChildProjects);
    }

    public Double getTotalEstimate(PrimaryWorkitemFilter filter) {
        return this.getTotalEstimate(filter, false);
    }

    public Double getTotalDetailEstimate(WorkitemFilter filter, boolean includeChildProjects) {
        filter = filter != null ? filter : new WorkitemFilter();
        return this.getRollup("Workitems", "DetailEstimate", filter, includeChildProjects);
    }

    public Double getTotalDetailEstimate(WorkitemFilter filter) {
        return this.getTotalDetailEstimate(filter, false);
    }

    public Double getTotalToDo(WorkitemFilter filter, boolean includeChildProjects) {
        filter = filter != null ? filter : new WorkitemFilter();
        return this.getRollup("Workitems", "ToDo", filter, includeChildProjects);
    }

    public Double getTotalToDo(WorkitemFilter filter) {
        return this.getTotalToDo(filter, false);
    }

    public Double getTotalDone(WorkitemFilter filter, boolean includeChildProjects) {
        filter = filter != null ? filter : new WorkitemFilter();
        return this.getRollup("Workitems", "Actuals.Value", filter, includeChildProjects);
    }

    public Double getTotalDone(WorkitemFilter filter) {
        return this.getTotalDone(filter, false);
    }
}

