/*
 * Decompiled with CFR 0.152.
 */
package com.versionone.om;

import com.versionone.om.AssetID;
import com.versionone.om.Goal;
import com.versionone.om.IListValueProperty;
import com.versionone.om.Member;
import com.versionone.om.MetaDataAttribute;
import com.versionone.om.MetaRenamedAttribute;
import com.versionone.om.PrimaryWorkitem;
import com.versionone.om.ProjectAsset;
import com.versionone.om.V1Instance;
import com.versionone.om.filters.PrimaryWorkitemFilter;
import com.versionone.om.filters.ThemeFilter;
import com.versionone.om.filters.WorkitemFilter;
import com.versionone.om.listvalue.ThemeSource;
import com.versionone.om.listvalue.ThemeStatus;
import com.versionone.om.listvalue.ThemeType;
import com.versionone.om.listvalue.WorkitemPriority;
import com.versionone.om.listvalue.WorkitemRisk;
import java.util.Collection;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@MetaDataAttribute(value="Theme")
public class Theme
extends ProjectAsset {
    Theme(AssetID id, V1Instance instance) {
        super(id, instance);
    }

    Theme(V1Instance instance) {
        super(instance);
    }

    public Collection<Member> getOwners() {
        return this.getMultiRelation("Owners");
    }

    public IListValueProperty getRisk() {
        return this.getListValue(WorkitemRisk.class, "Risk");
    }

    public IListValueProperty getPriority() {
        return this.getListValue(WorkitemPriority.class, "Priority");
    }

    public IListValueProperty getSource() {
        return this.getListValue(ThemeSource.class, "Source");
    }

    @MetaRenamedAttribute(value="Category")
    public IListValueProperty getType() {
        return this.getListValue(ThemeType.class, "Category");
    }

    public IListValueProperty getStatus() {
        return this.getListValue(ThemeStatus.class, "Status");
    }

    @MetaRenamedAttribute(value="Parent")
    public Theme getParentTheme() {
        return this.getRelation(Theme.class, "Parent");
    }

    @MetaRenamedAttribute(value="Parent")
    public void setParentTheme(Theme value) {
        this.setRelation("Parent", value);
    }

    public Member getCustomer() {
        return this.getRelation(Member.class, "Customer");
    }

    public void setCustomer(Member value) {
        this.setRelation("Customer", value);
    }

    @MetaRenamedAttribute(value="LastVersion")
    public String getBuild() {
        return (String)this.get("LastVersion");
    }

    @MetaRenamedAttribute(value="LastVersion")
    public void setBuild(String value) {
        this.set("LastVersion", value);
    }

    public Double getEstimate() {
        return (Double)this.get("Estimate");
    }

    public void setEstimate(Double value) {
        this.set("Estimate", value);
    }

    public Collection<PrimaryWorkitem> getPrimaryWorkitems(PrimaryWorkitemFilter filter) {
        filter = filter != null ? filter : new PrimaryWorkitemFilter();
        filter.theme.clear();
        filter.theme.add(this);
        return this.getInstance().get().primaryWorkitems(filter);
    }

    public Collection<Theme> getChildThemes(ThemeFilter filter) {
        filter = filter != null ? filter : new ThemeFilter();
        filter.parent.clear();
        filter.parent.add(this);
        return this.getInstance().get().themes(filter);
    }

    public Double getTotalDetailEstimate(WorkitemFilter filter) {
        return this.getSum("ChildrenMeAndDown", filter != null ? filter : new WorkitemFilter(), "DetailEstimate");
    }

    public Double getTotalToDo(WorkitemFilter filter) {
        return this.getSum("ChildrenMeAndDown", filter != null ? filter : new WorkitemFilter(), "ToDo");
    }

    public Collection<Goal> getGoals() {
        return this.getMultiRelation("Goals");
    }

    @Override
    void closeImpl() throws UnsupportedOperationException {
        this.getInstance().executeOperation(this, "Inactivate");
    }

    @Override
    void reactivateImpl() throws UnsupportedOperationException {
        this.getInstance().executeOperation(this, "Reactivate");
    }

    public Theme createChildTheme(String name) {
        Theme theme = this.getInstance().create().theme(name, this.getProject());
        theme.setParentTheme(this);
        theme.save();
        return theme;
    }

    public Theme createChildTheme(String name, Map<String, Object> attributes) {
        Theme theme = this.getInstance().create().theme(name, this.getProject(), attributes);
        theme.setParentTheme(this);
        theme.save();
        return theme;
    }
}

