/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vipclient.i18n.messages.service;

import com.vmware.vipclient.i18n.VIPCfg;
import com.vmware.vipclient.i18n.base.DataSourceEnum;
import com.vmware.vipclient.i18n.messages.api.opt.server.ProductBasedOpt;
import com.vmware.vipclient.i18n.messages.dto.BaseDTO;
import com.vmware.vipclient.i18n.messages.dto.MessagesDTO;
import com.vmware.vipclient.i18n.messages.service.ComponentService;
import com.vmware.vipclient.i18n.util.LocaleUtility;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.json.simple.JSONArray;

public class ProductService {
    private MessagesDTO dto = null;

    public ProductService(MessagesDTO dto) {
        this.dto = dto;
    }

    public JSONArray getComponentsFromRemoteVIP() {
        BaseDTO baseDTO = new BaseDTO();
        baseDTO.setProductID(this.dto.getProductID());
        baseDTO.setVersion(this.dto.getVersion());
        ProductBasedOpt dao = new ProductBasedOpt(baseDTO);
        return dao.getComponentsFromRemoteVIP();
    }

    public JSONArray getSupportedLocalesFromRemoteVIP() {
        BaseDTO baseDTO = new BaseDTO();
        baseDTO.setProductID(this.dto.getProductID());
        baseDTO.setVersion(this.dto.getVersion());
        ProductBasedOpt dao = new ProductBasedOpt(baseDTO);
        return dao.getSupportedLocalesFromRemoteVIP();
    }

    public List<Map> getAllComponentTranslation() {
        ArrayList<Map> list = new ArrayList<Map>();
        Object[] locales = new Object[]{};
        Object[] components = new Object[]{};
        if (VIPCfg.getInstance().getMessageOrigin() == DataSourceEnum.VIP) {
            locales = this.getSupportedLocalesFromRemoteVIP().toArray();
            components = this.getComponentsFromRemoteVIP().toArray();
        }
        for (Object locale : locales) {
            for (Object component : components) {
                this.dto.setComponent(((String)component).trim());
                this.dto.setLocale(LocaleUtility.fmtToMappedLocale((String)locale).toString().trim());
                Map<String, String> retMap = new ComponentService(this.dto).getComponentTranslation();
                if (retMap == null) continue;
                list.add(retMap);
            }
        }
        return list;
    }
}

