/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vipclient.i18n.base.cache;

import com.vmware.vipclient.i18n.base.cache.Cache;
import com.vmware.vipclient.i18n.base.cache.MessageCache;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MessageCache2
implements Cache {
    private long expiredTime = 864000000L;
    private long lastClean = System.currentTimeMillis();
    private List<MessageCache> messageCacheList = new LinkedList<MessageCache>();
    private int capacityX = -1;
    private int capacityY = -1;
    private String dropId;

    @Override
    public Map<String, String> get(String cacheKey) {
        Map<String, String> r = null;
        for (MessageCache m : this.messageCacheList) {
            Map<String, String> o = m.getCachedTranslationMap().get(cacheKey);
            if (o == null) continue;
            r = o;
            break;
        }
        return r;
    }

    @Override
    public synchronized boolean put(String cacheKey, Map<String, String> map) {
        boolean created = true;
        for (int i = 0; i < this.messageCacheList.size(); ++i) {
            MessageCache m = this.messageCacheList.get(i);
            if (m.isFull()) continue;
            created = false;
            break;
        }
        if (created) {
            MessageCache m = new MessageCache(cacheKey);
            m.setXCapacity(this.getXCapacity());
            m.setDropId(this.getDropId());
            m.setExpiredTime(this.getExpiredTime());
            m.setId(new Integer(this.messageCacheList.size()).toString());
            if (this.isFull() && this.messageCacheList.size() > 0) {
                this.messageCacheList.remove(0);
            }
            if (!this.isFull()) {
                this.messageCacheList.add(m);
            }
        }
        int targetIndex = -1;
        int minSize = 0;
        for (int i = 0; i < this.messageCacheList.size(); ++i) {
            MessageCache m = this.messageCacheList.get(i);
            if (minSize == 0) {
                minSize = m.size();
                targetIndex = 0;
                continue;
            }
            if (m.size() >= minSize) continue;
            minSize = m.size();
            targetIndex = i;
        }
        if (targetIndex == -1) {
            return false;
        }
        MessageCache mc = this.messageCacheList.get(targetIndex);
        if (mc != null) {
            return mc.put(cacheKey, map);
        }
        return false;
    }

    @Override
    public synchronized boolean remove(String cacheKey) {
        boolean f = false;
        for (MessageCache m : this.messageCacheList) {
            f = m.remove(cacheKey);
        }
        return f;
    }

    @Override
    public synchronized boolean clear() {
        boolean f = false;
        for (MessageCache m : this.messageCacheList) {
            f = m.clear();
        }
        this.messageCacheList.clear();
        return f;
    }

    public int sizeOfComponent() {
        int s = 0;
        for (MessageCache m : this.messageCacheList) {
            s += m.size();
        }
        return s;
    }

    @Override
    public int size() {
        return this.messageCacheList.size();
    }

    @Override
    public Set<String> keySet() {
        HashSet<String> kset = new HashSet<String>();
        for (MessageCache m : this.messageCacheList) {
            kset.addAll(m.getCachedTranslationMap().keySet());
        }
        return kset;
    }

    @Override
    public synchronized long getExpiredTime() {
        return this.expiredTime;
    }

    @Override
    public synchronized void setExpiredTime(long millis) {
        this.expiredTime = millis;
    }

    @Override
    public synchronized long getLastClean() {
        return this.lastClean;
    }

    @Override
    public synchronized void setLastClean(long millis) {
        this.lastClean = millis;
    }

    public int getCacheKeySize() {
        int s = 0;
        for (MessageCache m : this.messageCacheList) {
            s += m.size();
        }
        return s;
    }

    @Override
    public synchronized void setXCapacity(int capacityX) {
        this.capacityX = capacityX;
    }

    @Override
    public synchronized int getXCapacity() {
        return this.capacityX;
    }

    public int getYCapacity() {
        return this.capacityY;
    }

    public void setYCapacity(int capacityY) {
        this.capacityY = capacityY;
    }

    public boolean isFull() {
        boolean f = false;
        if (this.getYCapacity() >= 0 && this.capacityY <= this.size()) {
            f = true;
        }
        return f;
    }

    @Override
    public boolean isExpired() {
        boolean f = false;
        long expired = this.getExpiredTime();
        long lastClean = this.getLastClean();
        long currentTime = System.currentTimeMillis();
        if (currentTime - lastClean > expired) {
            f = true;
        }
        return f;
    }

    @Override
    public String getDropId() {
        return this.dropId;
    }

    public void setDropId(String dropId) {
        this.dropId = dropId;
    }
}

