/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vipclient.i18n.messages.api.url;

import com.vmware.vipclient.i18n.VIPCfg;
import com.vmware.vipclient.i18n.l2.common.PatternCategory;
import com.vmware.vipclient.i18n.messages.api.url.URLUtils;
import com.vmware.vipclient.i18n.messages.dto.BaseDTO;
import com.vmware.vipclient.i18n.messages.dto.MessagesDTO;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class V2URL {
    private static Logger logger = LoggerFactory.getLogger(V2URL.class);

    private V2URL() {
    }

    public static String getComponentListURL(BaseDTO dto, String baseURL) {
        StringBuilder url = new StringBuilder(baseURL);
        String gurl = "/i18n/api/v2/translation/products/{productName}/versions/{version:.+}/componentlist".replace("{productName}", dto.getProductID()).replace("{version:.+}", dto.getVersion());
        url.append(gurl);
        return url.toString();
    }

    public static String getSupportedLocaleListURL(BaseDTO dto, String baseURL) {
        StringBuilder url = new StringBuilder(baseURL);
        String gurl = "/i18n/api/v2/translation/products/{productName}/versions/{version:.+}/localelist".replace("{productName}", dto.getProductID()).replace("{version:.+}", dto.getVersion());
        url.append(gurl);
        return url.toString();
    }

    public static String getComponentTranslationURL(MessagesDTO dto, String baseURL) {
        StringBuilder url = new StringBuilder(baseURL);
        String gurl = "/i18n/api/v2/translation/products/{productName}/versions/{version:.+}/locales/{locale}/components/{component}".replace("{productName}", dto.getProductID()).replace("{version:.+}", dto.getVersion()).replace("{component}", dto.getComponent()).replace("{locale}", dto.getLocale());
        url.append(gurl);
        if (VIPCfg.getInstance().isPseudo()) {
            URLUtils.appendParamToURL(url, "pseudo", Boolean.toString(VIPCfg.getInstance().isPseudo()));
        } else {
            URLUtils.appendParamToURL(url, "pseudo", Boolean.FALSE.toString());
        }
        if (VIPCfg.getInstance().isMachineTranslation()) {
            URLUtils.appendParamToURL(url, "machineTranslation", Boolean.toString(VIPCfg.getInstance().isMachineTranslation()));
        }
        return url.toString();
    }

    public static String getComponentsTranslationURL(String baseURL, VIPCfg cfg) {
        String url_path = "/i18n/api/v2/translation/products/{productName}/versions/{version:.+}".replace("{productName}", cfg.getProductName()).replace("{version:.+}", cfg.getVersion());
        StringBuilder url = new StringBuilder(baseURL).append(url_path);
        if (VIPCfg.getInstance().isPseudo()) {
            URLUtils.appendParamToURL(url, "pseudo", Boolean.toString(true));
        }
        return url.toString();
    }

    public static String getKeyTranslationURL(MessagesDTO dto, String baseURL) {
        StringBuilder url = new StringBuilder(baseURL);
        String url2 = "";
        try {
            url2 = "/i18n/api/v2/translation/products/{productName}/versions/{version:.+}/locales/{locale}/components/{component}/keys/{key:.+}".replace("{productName}", dto.getProductID()).replace("{version:.+}", dto.getVersion()).replace("{component}", dto.getComponent()).replace("{locale}", dto.getLocale()).replace("{key:.+}", URLEncoder.encode(dto.getKey(), "utf-8"));
        }
        catch (UnsupportedEncodingException e) {
            logger.info(e.getMessage());
        }
        url.append(url2);
        if (VIPCfg.getInstance().isPseudo()) {
            URLUtils.appendParamToURL(url, "pseudo", Boolean.toString(VIPCfg.getInstance().isPseudo()));
        }
        if (VIPCfg.getInstance().isCollectSource()) {
            URLUtils.appendParamToURL(url, "collectSource", Boolean.toString(VIPCfg.getInstance().isCollectSource()));
        }
        if (VIPCfg.getInstance().isMachineTranslation()) {
            URLUtils.appendParamToURL(url, "machineTranslation", Boolean.toString(VIPCfg.getInstance().isMachineTranslation()));
        }
        if (null != dto.getComment()) {
            try {
                URLUtils.appendParamToURL(url, "commentForSource", URLEncoder.encode(dto.getComment(), "utf-8"));
            }
            catch (UnsupportedEncodingException e) {
                logger.info(e.getMessage());
            }
        }
        return url.toString();
    }

    public static String getPostKeys(MessagesDTO dto, String baseURL) {
        StringBuilder url = new StringBuilder(baseURL);
        String url2 = "/i18n/api/v2/translation/products/{productName}/versions/{version:.+}/locales/{locale}/components/{component}/keys".replace("{productName}", dto.getProductID()).replace("{version:.+}", dto.getVersion()).replace("{component}", dto.getComponent()).replace("{locale}", dto.getLocale());
        url.append(url2);
        if (VIPCfg.getInstance().isCollectSource()) {
            URLUtils.appendParamToURL(url, "collectSource", Boolean.toString(VIPCfg.getInstance().isCollectSource()));
        }
        return url.toString();
    }

    public static String getPatternURL(String locale, String baseURL) {
        StringBuilder url = new StringBuilder(baseURL);
        String subUrl = "/i18n/api/v2/formatting/patterns/locales/{locale}".replace("{locale}", locale);
        url.append(subUrl);
        String i18nScope = VIPCfg.getInstance().getI18nScope();
        if (i18nScope != null && !"".equalsIgnoreCase(i18nScope)) {
            String[] scopeArray = i18nScope.split(",");
            PatternCategory[] categories = new PatternCategory[]{PatternCategory.NUMBERS, PatternCategory.CURRENCIES, PatternCategory.DATES, PatternCategory.PLURALS, PatternCategory.MEASUREMENTS};
            for (String category : scopeArray) {
                boolean flag = false;
                for (PatternCategory categoryConstant : categories) {
                    if (!categoryConstant.toString().equals(category.trim())) continue;
                    flag = true;
                    break;
                }
                if (flag) continue;
                throw new IllegalArgumentException("The value of initialize parameter 'i18nScope' defined in 'vipconfig.properties' contains wrong value!");
            }
            URLUtils.appendParamToURL(url, "scope", i18nScope);
        }
        return url.toString();
    }

    public static String getPatternURL(String language, String region, String baseURL) {
        StringBuilder url = new StringBuilder(baseURL);
        String subUrl = "/i18n/api/v2/formatting/patterns";
        url.append(subUrl);
        String i18nScope = VIPCfg.getInstance().getI18nScope();
        if (i18nScope != null && !"".equalsIgnoreCase(i18nScope)) {
            String[] scopeArray = i18nScope.split(",");
            PatternCategory[] categories = new PatternCategory[]{PatternCategory.NUMBERS, PatternCategory.CURRENCIES, PatternCategory.DATES, PatternCategory.PLURALS, PatternCategory.MEASUREMENTS};
            for (String category : scopeArray) {
                boolean flag = false;
                for (PatternCategory categoryConstant : categories) {
                    if (!categoryConstant.toString().equals(category.trim())) continue;
                    flag = true;
                    break;
                }
                if (flag) continue;
                throw new IllegalArgumentException("The value of initialize parameter 'i18nScope' defined in 'vipconfig.properties' contains wrong value!");
            }
            URLUtils.appendParamToURL(url, "language", language);
            URLUtils.appendParamToURL(url, "region", region);
            URLUtils.appendParamToURL(url, "scope", i18nScope);
        }
        return url.toString();
    }

    public static String getRegionListURL(String supportedLanguages, String baseUrl) {
        StringBuilder url = new StringBuilder(baseUrl);
        url.append("/i18n/api/v2/locale/regionList");
        return URLUtils.appendParamToURL(url, "supportedLanguageList", supportedLanguages);
    }

    public static String getSupportedLanguageListURL(String displayLanguage, String baseUrl) {
        StringBuilder url = new StringBuilder(baseUrl);
        url.append("/i18n/api/v2/locale/supportedLanguageList");
        URLUtils.appendParamToURL(url, "productName", VIPCfg.getInstance().getProductName());
        URLUtils.appendParamToURL(url, "version", VIPCfg.getInstance().getVersion());
        return URLUtils.appendParamToURL(url, "displayLanguage", displayLanguage);
    }
}

