/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vipclient.i18n.formats;

import com.vmware.vipclient.i18n.VIPCfg;
import com.vmware.vipclient.i18n.base.BaseFormat;
import com.vmware.vipclient.i18n.exceptions.VIPJavaClientException;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;
import org.json.simple.parser.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NumberFormat
extends BaseFormat {
    Logger logger = LoggerFactory.getLogger(NumberFormat.class);

    public String getLocalizedNumber(String number, String scale) {
        if (null == number || number.length() == 0) {
            throw new VIPJavaClientException("number can't be empty");
        }
        if (null == scale || scale.length() == 0) {
            throw new VIPJavaClientException("scale can't be empty");
        }
        if (VIPCfg.getInstance().getVipService().getHttpRequester().isConnected()) {
            return this.getFormatFromRemote(number, scale);
        }
        return "";
    }

    private String getFormatFromRemote(String number, String scale) {
        String format = "";
        StringBuffer numberAPIUrl = new StringBuffer(VIPCfg.getInstance().getVipService().getHttpRequester().getBaseURL());
        numberAPIUrl.append("/i18n/api/v1/number/localizedNumber?locale=");
        numberAPIUrl.append(this.locale);
        numberAPIUrl.append("&number=");
        numberAPIUrl.append(number);
        numberAPIUrl.append("&scale=");
        numberAPIUrl.append(scale);
        String retJsonStr = VIPCfg.getInstance().getVipService().getHttpRequester().request(numberAPIUrl.toString(), "GET", null);
        if (null == retJsonStr || retJsonStr.length() == 0) {
            return format;
        }
        try {
            JSONObject dataJson;
            JSONObject retJson = (JSONObject)JSONValue.parseWithException((String)retJsonStr);
            if (retJson != null && (dataJson = (JSONObject)retJson.get((Object)"data")) != null) {
                format = dataJson.get((Object)"formattedNumber") == null ? "" : dataJson.get((Object)"formattedNumber").toString();
            }
        }
        catch (ParseException e) {
            this.logger.error(e.getMessage());
        }
        return format;
    }
}

