/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vipclient.i18n.l2.text;

import com.vmware.vipclient.i18n.l2.text.RegionDateFormat;
import com.vmware.vipclient.i18n.l2.text.SimpleDateFormat;
import com.vmware.vipclient.i18n.util.FormatUtils;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.simple.JSONObject;

public abstract class DateFormat {
    public static final int DATETIME = 0;
    public static final int DATE = 1;
    public static final int TIME = 2;
    public static final int NONE = -1;
    public static final String FULL = "full";
    public static final String LONG = "long";
    public static final String MEDIUM = "medium";
    public static final String SHORT = "short";
    public static final String DEFAULT = "medium";

    public static DateFormat getInstance(JSONObject formatData, String format, String locale) {
        String pattern = DateFormat.getPattern(formatData, format);
        SimpleDateFormat dateFormat = new SimpleDateFormat(pattern, formatData, locale);
        return dateFormat;
    }

    public static DateFormat getInstance(JSONObject formatData, String format, String language, String region) {
        String pattern = DateFormat.getPattern(formatData, format);
        RegionDateFormat dateFormat = new RegionDateFormat(pattern, formatData, language, region);
        return dateFormat;
    }

    public static String getPattern(JSONObject formatData, String format) {
        String pattern;
        String patternType = null;
        String patternStyle = "";
        if (format.indexOf(SHORT) != -1) {
            patternType = SHORT;
        } else if (format.indexOf("medium") != -1) {
            patternType = "medium";
        } else if (format.indexOf(LONG) != -1) {
            patternType = LONG;
        } else if (format.indexOf(FULL) != -1) {
            patternType = FULL;
        }
        if (patternType != null && !"".equals(patternType)) {
            patternStyle = format.indexOf("Date") != -1 ? "dateFormats" : (format.indexOf("Time") != -1 ? "timeFormats" : "dateTimeFormats");
        }
        if (!"".equals(patternStyle)) {
            JSONObject patternObj = (JSONObject)formatData.get((Object)patternStyle);
            pattern = (String)patternObj.get((Object)patternType);
            if ("dateTimeFormats".equalsIgnoreCase(patternStyle)) {
                String datePattern = (String)((JSONObject)formatData.get((Object)"dateFormats")).get((Object)format);
                String timePattern = (String)((JSONObject)formatData.get((Object)"timeFormats")).get((Object)format);
                pattern = FormatUtils.format(pattern, timePattern, datePattern);
            }
        } else {
            pattern = format;
        }
        return pattern;
    }

    public String format(Object obj, String timeZone) {
        if (obj instanceof Calendar) {
            return this.format(((Calendar)obj).getTime(), timeZone);
        }
        if (obj instanceof Date) {
            return this.format((Date)obj, timeZone);
        }
        if (obj instanceof Number) {
            return this.format(new Date(((Number)obj).longValue()), timeZone);
        }
        if (obj instanceof String) {
            Date date = this.parseStr2Date(obj.toString());
            return this.format(date, timeZone);
        }
        throw new IllegalArgumentException("Cannot format given Object (" + obj.getClass().getName() + ") as a Date");
    }

    public abstract String format(Date var1, String var2);

    public Date parseStr2Date(String str) {
        if (this.isNumeric(str)) {
            if (str.endsWith("l") || str.endsWith("L")) {
                str = str.substring(0, str.length() - 1);
            }
            long date = str.indexOf(".") > 0 ? new BigDecimal(str).longValue() : new BigInteger(str).longValue();
            return new Date(date);
        }
        return this.getDateByString(str);
    }

    public Date getDateByString(String dateStr) {
        if (dateStr.indexOf(".") > 0 || dateStr.indexOf(",") > 0 || dateStr.indexOf("/") > 0) {
            dateStr = dateStr.replace(".", "-").replace(",", "-").replace("/", "-");
        }
        if (dateStr.indexOf("T") < 0) {
            dateStr = dateStr.replace("-", "/");
            Date date = new Date(dateStr);
            return date;
        }
        return this.IsoToDate(dateStr);
    }

    public Date IsoToDate(String isoDateStr) {
        Calendar cal = Calendar.getInstance();
        String[] dateTimeArray = isoDateStr.split("T");
        String[] dateArray = dateTimeArray[0].split("-");
        for (int i = 0; i < dateArray.length; ++i) {
            switch (i) {
                case 0: {
                    cal.set(1, Integer.parseInt(dateArray[0]));
                }
                case 1: {
                    cal.set(2, Integer.parseInt(dateArray[1]) - 1);
                }
                case 2: {
                    cal.set(5, Integer.parseInt(dateArray[2]));
                }
            }
        }
        if (dateTimeArray.length > 1) {
            String timeStr = dateTimeArray[1];
            if (dateTimeArray[1].indexOf("+") > 0) {
                timeStr = dateTimeArray[1].substring(0, dateTimeArray[1].indexOf("+"));
            } else if (dateTimeArray[1].indexOf("-") > 0) {
                timeStr = dateTimeArray[1].substring(0, dateTimeArray[1].indexOf("-"));
            }
            String[] timeArray = timeStr.split(":");
            for (int i = 0; i < timeArray.length; ++i) {
                switch (i) {
                    case 0: {
                        cal.set(11, Integer.parseInt(timeArray[0]));
                    }
                    case 1: {
                        cal.set(12, Integer.parseInt(timeArray[1]));
                    }
                    case 2: {
                        cal.set(13, Integer.parseInt(timeArray[2]));
                    }
                }
            }
        }
        return cal.getTime();
    }

    public boolean isNumeric(String str) {
        Pattern pattern = Pattern.compile("-?[0-9]+.?[0-9]+([l,L]$)?");
        Matcher isNum = pattern.matcher(str);
        return isNum.matches();
    }
}

