/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vipclient.i18n.messages.service;

import com.vmware.vipclient.i18n.VIPCfg;
import com.vmware.vipclient.i18n.base.cache.Cache;
import com.vmware.vipclient.i18n.base.cache.TranslationCacheManager;
import com.vmware.vipclient.i18n.messages.api.opt.server.LocaleOpt;
import com.vmware.vipclient.i18n.util.JSONUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocaleService {
    Logger logger = LoggerFactory.getLogger((String)LocaleService.class.getName());
    private static final String REGION_PREFIX = "region_";
    private static final String DISPN_PREFIX = "dispn_";

    public Map<String, Map<String, String>> getTerritoriesFromCLDR(List<String> languages) {
        HashMap<String, Map<String, String>> respMap = new HashMap<String, Map<String, String>>();
        for (String language : languages) {
            language = language.toLowerCase();
            Map<String, String> regionMap = null;
            this.logger.trace("look for region list of '" + language + "' from cache");
            VIPCfg.getInstance().getCacheManager();
            Cache c = TranslationCacheManager.getCache("CACHE_L2");
            if (c != null) {
                regionMap = c.get(REGION_PREFIX + language);
            }
            if (regionMap != null) {
                respMap.put(language, regionMap);
                continue;
            }
            this.logger.trace("get region list of '" + language + "' data from backend");
            Map<String, String> tmpMap = new LocaleOpt().getTerritoriesFromCLDR(language);
            regionMap = JSONUtils.map2SortMap(tmpMap);
            respMap.put(language, regionMap);
            if (c == null) continue;
            c.put(REGION_PREFIX + language, regionMap);
        }
        return respMap;
    }

    public Map<String, String> getDisplayNamesFromCLDR(String language) {
        Map<String, String> dispMap = null;
        this.logger.trace("look for displayNames from cache");
        VIPCfg.getInstance().getCacheManager();
        Cache c = TranslationCacheManager.getCache("CACHE_L2");
        if (c != null && ((dispMap = c.get(DISPN_PREFIX + language)) == null || dispMap.size() == 0)) {
            this.logger.trace("get displayname data from backend");
            Map<String, String> tmpMap = new LocaleOpt().getDisplayNamesFromCLDR(language);
            dispMap = JSONUtils.map2SortMap(tmpMap);
            if (dispMap != null && dispMap.size() > 0) {
                c.put(DISPN_PREFIX + language, dispMap);
            }
        }
        return dispMap;
    }
}

