/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vipclient.i18n.l2.text;

import com.vmware.vipclient.i18n.I18nFactory;
import com.vmware.vipclient.i18n.base.instances.NumberFormatting;
import com.vmware.vipclient.i18n.l2.plural.parser.PluralRules;
import com.vmware.vipclient.i18n.l2.text.MessagePattern;
import java.text.FieldPosition;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class PluralFormat {
    private Locale locale = null;
    private PluralRules pluralRules = null;
    private String pattern = null;
    private transient MessagePattern msgPattern;
    private transient double offset = 0.0;
    private String dataKey_prevIndex = "prevIndex";
    private String dataKey_result = "result";
    private transient PluralSelectorAdapter pluralRulesWrapper = new PluralSelectorAdapter();

    public PluralFormat(String pattern) {
        this.init(null, PluralRules.PluralType.CARDINAL, Locale.getDefault(Locale.Category.FORMAT));
        this.applyPattern(pattern);
    }

    public PluralFormat(Locale locale, String pattern) {
        this.init(null, PluralRules.PluralType.CARDINAL, locale);
        this.applyPattern(pattern);
    }

    private void init(PluralRules rules, PluralRules.PluralType type, Locale locale) {
        this.locale = locale;
        this.pluralRules = rules == null ? PluralRules.forLocale(locale, type) : rules;
        this.resetPattern();
    }

    private void resetPattern() {
        this.pattern = null;
        if (this.msgPattern != null) {
            this.msgPattern.clear();
        }
        this.offset = 0.0;
    }

    public void applyPattern(String pattern) {
        this.pattern = pattern;
        if (this.msgPattern == null) {
            this.msgPattern = new MessagePattern();
        }
        try {
            this.msgPattern.parsePluralStyle(pattern);
            this.offset = this.msgPattern.getPluralOffset(0);
        }
        catch (RuntimeException e) {
            this.resetPattern();
            throw e;
        }
    }

    public final String format(double number) {
        return this.format(number, number);
    }

    public StringBuilder format(Object number, StringBuilder toAppendTo, FieldPosition pos) {
        if (!(number instanceof Number)) {
            throw new IllegalArgumentException("'" + number + "' is not a Number");
        }
        Number numberObject = (Number)number;
        toAppendTo.append(this.format(numberObject, numberObject.doubleValue()));
        return toAppendTo;
    }

    private String format(Number numberObject, double number) {
        I18nFactory factory = I18nFactory.getInstance();
        NumberFormatting p = (NumberFormatting)factory.getFormattingInstance(NumberFormatting.class);
        if (this.msgPattern == null || this.msgPattern.countParts() == 0) {
            return p.formatNumber(numberObject, this.locale);
        }
        double numberMinusOffset = number - this.offset;
        String numberString = this.offset == 0.0 ? p.formatNumber(numberObject, this.locale) : p.formatNumber(numberMinusOffset, this.locale);
        PluralRules.FixedDecimal dec = new PluralRules.FixedDecimal(numberMinusOffset);
        int partIndex = PluralFormat.findSubMessage(this.msgPattern, 0, this.pluralRulesWrapper, dec, number);
        return this.formatSubMessage(partIndex, numberString);
    }

    private String formatSubMessage(int partIndex, String numberString) {
        StringBuilder result = null;
        int prevIndex = this.msgPattern.getPart(partIndex).getLimit();
        Map<Object, Object> map = new HashMap();
        while (true) {
            MessagePattern.Part part = this.msgPattern.getPart(++partIndex);
            MessagePattern.Part.Type type = part.getType();
            int index = part.getIndex();
            if (type == MessagePattern.Part.Type.MSG_LIMIT) {
                return this.handleMsgLimit(result, prevIndex, index);
            }
            if (type == MessagePattern.Part.Type.REPLACE_NUMBER || type == MessagePattern.Part.Type.SKIP_SYNTAX && this.msgPattern.jdkAposMode()) {
                map = this.handleReplaceNumberOrSkipSyntax(result, prevIndex, index, part, type, numberString);
            } else if (type == MessagePattern.Part.Type.ARG_START) {
                map = this.handleArg(result, prevIndex, partIndex, index);
            }
            prevIndex = (Integer)map.get(this.dataKey_prevIndex);
            result = (StringBuilder)map.get(this.dataKey_result);
        }
    }

    private String handleMsgLimit(StringBuilder result, int prevIndex, int index) {
        if (result == null) {
            return this.pattern.substring(prevIndex, index);
        }
        return result.append(this.pattern, prevIndex, index).toString();
    }

    private Map<String, Object> handleReplaceNumberOrSkipSyntax(StringBuilder result, int prevIndex, int index, MessagePattern.Part part, MessagePattern.Part.Type type, String numberString) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (result == null) {
            result = new StringBuilder();
        }
        result.append(this.pattern, prevIndex, index);
        if (type == MessagePattern.Part.Type.REPLACE_NUMBER) {
            result.append(numberString);
        }
        prevIndex = part.getLimit();
        map.put(this.dataKey_prevIndex, prevIndex);
        map.put(this.dataKey_result, result);
        return map;
    }

    private Map<String, Object> handleArg(StringBuilder result, int prevIndex, int partIndex, int index) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (result == null) {
            result = new StringBuilder();
        }
        result.append(this.pattern, prevIndex, index);
        prevIndex = index;
        partIndex = this.msgPattern.getLimitPartIndex(partIndex);
        index = this.msgPattern.getPart(partIndex).getLimit();
        MessagePattern.appendReducedApostrophes(this.pattern, prevIndex, index, result);
        prevIndex = index;
        map.put(this.dataKey_prevIndex, prevIndex);
        map.put(this.dataKey_result, result);
        return map;
    }

    static int findSubMessage(MessagePattern pattern, int partIndex, PluralSelector selector, Object context, double number) {
        int count = pattern.countParts();
        MessagePattern.Part part = pattern.getPart(partIndex);
        double offset = part.getType().hasNumericValue() ? pattern.getNumericValue(part) : 0.0;
        String keyword = null;
        boolean haveKeywordMatch = false;
        int msgStart = 0;
        do {
            int n = ++partIndex;
            ++partIndex;
            part = pattern.getPart(n);
            MessagePattern.Part.Type type = part.getType();
            if (type == MessagePattern.Part.Type.ARG_LIMIT) break;
            assert (type == MessagePattern.Part.Type.ARG_SELECTOR);
            Map<String, Object> map = PluralFormat.handleArgSelector(pattern, partIndex, keyword, selector, context, number, offset);
            keyword = (String)map.get("keyword");
            haveKeywordMatch = (Boolean)map.get("haveKeywordMatch");
            partIndex = (Integer)map.get("partIndex");
            if (haveKeywordMatch) {
                return partIndex;
            }
            partIndex = pattern.getLimitPartIndex(partIndex);
        } while (++partIndex < count);
        return msgStart;
    }

    private static Map<String, Object> handleArgSelector(MessagePattern pattern, int partIndex, String keyword, PluralSelector selector, Object context, double number, double offset) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        boolean haveKeywordMatch = false;
        MessagePattern.Part part = pattern.getPart(partIndex - 1);
        if (pattern.getPartType(partIndex).hasNumericValue()) {
            if (number == pattern.getNumericValue(part = pattern.getPart(partIndex++))) {
                haveKeywordMatch = true;
            }
        } else {
            if (keyword == null) {
                keyword = selector.select(context, number - offset);
            }
            if (pattern.partSubstringMatches(part, keyword)) {
                haveKeywordMatch = true;
            }
        }
        map.put("keyword", keyword);
        map.put("haveKeywordMatch", haveKeywordMatch);
        map.put("partIndex", partIndex);
        return map;
    }

    private final class PluralSelectorAdapter
    implements PluralSelector {
        private PluralSelectorAdapter() {
        }

        @Override
        public String select(Object context, double number) {
            double num;
            PluralRules.FixedDecimal dec = (PluralRules.FixedDecimal)context;
            double d = num = dec.isNegative ? -number : number;
            if (dec.source != num) {
                throw new IllegalArgumentException();
            }
            return PluralFormat.this.pluralRules.select(dec);
        }
    }

    static interface PluralSelector {
        public String select(Object var1, double var2);
    }
}

