/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vipclient.i18n.l2.text.parser;

import com.vmware.vipclient.i18n.l2.text.PatternItem;
import com.vmware.vipclient.i18n.l2.text.parser.PatternParser;
import java.util.Calendar;

public class DatePatternParser
implements PatternParser {
    private int offset;
    private boolean trim = false;
    private boolean negWrap = false;

    public DatePatternParser(int offset, boolean trim, boolean negWrap) {
        this.offset = offset;
        this.trim = trim;
        this.negWrap = negWrap;
    }

    public DatePatternParser() {
        this(0);
    }

    public DatePatternParser(int offset) {
        this(offset, false, false);
    }

    @Override
    public String parse(PatternItem item, Calendar cal) {
        int value = cal.get(item.patternCharToCalendarField());
        int len = item.getLength();
        if (this.offset > 0 || value > -this.offset) {
            value += this.offset;
        }
        String neg = "";
        if (value < 0 || this.negWrap && value <= 0) {
            if (this.negWrap) {
                value = -value + 1;
            } else {
                value = -value;
                neg = "-";
            }
        }
        String valueStr = String.valueOf(value);
        while (valueStr.length() < len) {
            valueStr = "0" + valueStr;
        }
        if (this.trim) {
            valueStr = valueStr.substring(valueStr.length() - len);
        }
        return neg + valueStr;
    }
}

