/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vipclient.i18n.messages.api.opt.server;

import com.vmware.vipclient.i18n.VIPCfg;
import com.vmware.vipclient.i18n.base.HttpRequester;
import com.vmware.vipclient.i18n.messages.api.url.V2URL;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;
import org.json.simple.parser.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemotePatternOpt {
    Logger logger = LoggerFactory.getLogger(RemotePatternOpt.class);

    public JSONObject getPatternsByLocale(String locale) {
        String responseStr = "";
        String i18nScope = VIPCfg.getInstance().getI18nScope();
        HttpRequester httpRequester = VIPCfg.getInstance().getVipService().getHttpRequester();
        if (i18nScope != null && !"".equalsIgnoreCase(i18nScope)) {
            responseStr = httpRequester.request(V2URL.getPatternURL(locale, httpRequester.getBaseURL()), "GET", null);
        }
        if (null == responseStr || responseStr.equals("")) {
            return null;
        }
        Object dataObj = this.getCategoriesFromResponse(responseStr, "categories");
        JSONObject msgObject = null;
        if (dataObj != null) {
            msgObject = (JSONObject)dataObj;
        }
        return msgObject;
    }

    public JSONObject getPatternsByLocale(String language, String region) {
        String responseStr = "";
        String i18nScope = VIPCfg.getInstance().getI18nScope();
        HttpRequester httpRequester = VIPCfg.getInstance().getVipService().getHttpRequester();
        if (i18nScope != null && !"".equalsIgnoreCase(i18nScope)) {
            responseStr = httpRequester.request(V2URL.getPatternURL(language, region, httpRequester.getBaseURL()), "GET", null);
        }
        if (null == responseStr || responseStr.equals("")) {
            return null;
        }
        Object dataObj = this.getCategoriesFromResponse(responseStr, "categories");
        JSONObject msgObject = null;
        if (dataObj != null) {
            msgObject = (JSONObject)dataObj;
        }
        return msgObject;
    }

    private Object getCategoriesFromResponse(String responseStr, String node) {
        Object msgObject = null;
        try {
            JSONObject dataObj;
            JSONObject responseObj = (JSONObject)JSONValue.parseWithException((String)responseStr);
            if (responseObj != null && (dataObj = (JSONObject)responseObj.get((Object)"data")) != null) {
                msgObject = dataObj.get((Object)node);
            }
        }
        catch (ParseException e) {
            this.logger.error(e.getMessage());
        }
        return msgObject;
    }
}

