/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vipclient.i18n.base;

import com.vmware.vipclient.i18n.VIPCfg;
import com.vmware.vipclient.i18n.base.HttpRequester;
import com.vmware.vipclient.i18n.base.cache.Cache;
import com.vmware.vipclient.i18n.base.cache.TranslationCacheManager;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Task {
    private static Logger logger = LoggerFactory.getLogger(Task.class);
    private static boolean connected = true;
    private static int min = 60000;
    private static int intevalPing = 10 * min;
    private static int defaultIntevalCache = 1440 * min;

    private Task() {
    }

    public static void startTaskOfCacheClean(final VIPCfg gc, int interalCleanCache) {
        TimerTask taskPing = new TimerTask(){

            @Override
            public void run() {
                if (!connected && null != gc.getVipServer() && HttpRequester.ping(gc.getVipServer())) {
                    connected = true;
                    logger.info("Ping the host[" + gc.getVipServer() + "] is passed and reset connection.");
                }
            }
        };
        TimerTask cleanCacheTask = new TimerTask(){

            @Override
            public void run() {
                VIPCfg.getInstance().getCacheManager();
                Cache translationCache = TranslationCacheManager.getCache("CACHE_L3");
                if (translationCache == null) {
                    return;
                }
                Set<String> set = translationCache.keySet();
                if (!set.isEmpty() && HttpRequester.ping(gc.getVipServer())) {
                    translationCache.clear();
                    logger.info("Cache was clean up.");
                    gc.initializeMessageCache();
                } else {
                    logger.info("There's no cache or VIP service is not connected, unable to clean the cache.");
                }
            }
        };
        Timer timer = new Timer();
        timer.scheduleAtFixedRate(taskPing, intevalPing, (long)intevalPing);
        if (interalCleanCache > 0) {
            timer.scheduleAtFixedRate(cleanCacheTask, (long)interalCleanCache * (long)min, (long)interalCleanCache * (long)min);
        } else {
            timer.scheduleAtFixedRate(cleanCacheTask, defaultIntevalCache, (long)defaultIntevalCache);
        }
    }
}

