/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vipclient.i18n.l2.text;

import com.vmware.vipclient.i18n.l2.text.DecimalFormat;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.json.simple.JSONObject;

public abstract class NumberFormat {
    public static final int NUMBERSTYLE = 0;
    public static final int CURRENCYSTYLE = 1;
    public static final int PERCENTSTYLE = 2;
    public static final int SCIENTIFICSTYLE = 3;
    public static final int INTEGERSTYLE = 4;
    public static final int STANDARDCURRENCYSTYLE = 9;

    public static NumberFormat getInstance(JSONObject patterns, int style) {
        DecimalFormat df;
        if (style < 0 || style > 9) {
            throw new IllegalArgumentException("choice should be from NUMBERSTYLE to STANDARDCURRENCYSTYLE");
        }
        DecimalFormat nf = df = new DecimalFormat(patterns, style);
        return nf;
    }

    public static String getPattern(JSONObject numberFormats, int style) {
        String pattern = "";
        switch (style) {
            case 0: {
                pattern = (String)numberFormats.get((Object)"decimalFormats");
                break;
            }
            case 1: {
                pattern = (String)numberFormats.get((Object)"currencyFormats");
                break;
            }
            case 2: {
                pattern = (String)numberFormats.get((Object)"percentFormats");
                break;
            }
            case 3: {
                pattern = (String)numberFormats.get((Object)"scientificFormats");
                break;
            }
            default: {
                pattern = (String)numberFormats.get((Object)"decimalFormats");
            }
        }
        return pattern;
    }

    public String format(Object value, Integer fractionSize) {
        if (value instanceof Long || value instanceof Integer || value instanceof Short || value instanceof Byte) {
            return this.format(((Number)value).longValue(), fractionSize);
        }
        if (value instanceof BigInteger) {
            return this.format((BigInteger)value, fractionSize);
        }
        if (value instanceof BigDecimal) {
            return this.format((BigDecimal)value, fractionSize);
        }
        if (value instanceof Float) {
            return this.format(String.valueOf(value), fractionSize);
        }
        if (value instanceof Double) {
            return this.format(((Number)value).doubleValue(), fractionSize);
        }
        if (value instanceof String) {
            return this.format((String)value, fractionSize);
        }
        throw new IllegalArgumentException("Cannot format given Object as a Number");
    }

    public abstract String format(long var1, Integer var3);

    public abstract String format(double var1, Integer var3);

    public abstract String format(BigInteger var1, Integer var2);

    public abstract String format(BigDecimal var1, Integer var2);

    public abstract String format(String var1, Integer var2);
}

