/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vipclient.i18n.l2.text;

import com.vmware.vipclient.i18n.l2.text.parser.AMPMPatternParser;
import com.vmware.vipclient.i18n.l2.text.parser.DatePatternParser;
import com.vmware.vipclient.i18n.l2.text.parser.DateStrPatternParser;
import com.vmware.vipclient.i18n.l2.text.parser.DefaultPatternParser;
import com.vmware.vipclient.i18n.l2.text.parser.EraPatternParser;
import com.vmware.vipclient.i18n.l2.text.parser.PatternParser;
import com.vmware.vipclient.i18n.l2.text.parser.TimeZonePatternParser;
import org.json.simple.JSONObject;

public class PatternItem {
    private char type;
    private int length;
    private static final int[] PATTERN_CHAR_TO_INDEX = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 8, -1, 11, 4, -1, -1, -1, 2, 1, -1, -1, -1, -1, -1, 9, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 10, -1, -1, 3, -1, -1, -1, 5, -1, -1, -1, -1, 6, -1, -1, -1, -1, -1, 7, -1, -1, -1, -1, -1, 0, 12, -1, -1, -1, -1, -1};
    private static final int[] PATTERN_INDEX_TO_CALENDAR_FIELD = new int[]{1, 2, 2, 5, 11, 10, 12, 13, 7, 14, 9, 0, 15};

    public PatternItem(char type, int length) {
        this.type = type;
        this.length = length;
    }

    public int getLength() {
        return this.length;
    }

    public char getType() {
        return this.type;
    }

    private int getIndexFromChar() {
        return this.type < PATTERN_CHAR_TO_INDEX.length ? PATTERN_CHAR_TO_INDEX[this.type & 0xFF] : -1;
    }

    public Integer patternCharToCalendarField() {
        int patternCharIndex = this.getIndexFromChar();
        if (patternCharIndex != -1) {
            return PATTERN_INDEX_TO_CALENDAR_FIELD[patternCharIndex];
        }
        return null;
    }

    protected PatternParser getParser(JSONObject formatData) {
        PatternParser parser = null;
        switch (this.getIndexFromChar()) {
            case 0: {
                boolean trim = false;
                if (this.length == 2) {
                    trim = true;
                }
                parser = new DatePatternParser(0, trim, true);
                break;
            }
            case 1: {
                if (this.length > 2) {
                    parser = new DateStrPatternParser((JSONObject)formatData.get((Object)"monthsFormat"));
                    break;
                }
                parser = new DatePatternParser(1);
                break;
            }
            case 2: {
                parser = new DateStrPatternParser((JSONObject)formatData.get((Object)"monthsFormat"));
                break;
            }
            case 5: {
                parser = new DatePatternParser(-12);
                break;
            }
            case 8: {
                parser = new DateStrPatternParser(formatData);
                break;
            }
            case 10: {
                parser = new AMPMPatternParser((JSONObject)formatData.get((Object)"dayPeriodsFormat"));
                break;
            }
            case 11: {
                if (this.length == 4) {
                    parser = new EraPatternParser((JSONObject)formatData.get((Object)"eras"), true);
                    break;
                }
                parser = new EraPatternParser((JSONObject)formatData.get((Object)"eras"));
                break;
            }
            case 12: {
                parser = new TimeZonePatternParser();
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: {
                parser = new DatePatternParser();
                break;
            }
            default: {
                parser = new DefaultPatternParser();
            }
        }
        return parser;
    }
}

