/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vipclient.i18n.l2.text.parser;

import com.vmware.vipclient.i18n.l2.text.PatternItem;
import com.vmware.vipclient.i18n.l2.text.parser.PatternParser;
import java.util.Calendar;

public class TimeZonePatternParser
implements PatternParser {
    @Override
    public String parse(PatternItem item, Calendar cal) {
        String timeZoneStr = null;
        int value = cal.get(item.patternCharToCalendarField());
        if (String.valueOf(item.getType()).indexOf("z") != -1) {
            int offset = cal.getTimeZone().getRawOffset() / 3600000;
            switch (item.getLength()) {
                case 4: {
                    if (offset >= 0) {
                        if (offset < 10) {
                            timeZoneStr = "GMT+0" + String.valueOf(offset) + ":00";
                            break;
                        }
                        timeZoneStr = "GMT+" + String.valueOf(offset) + ":00";
                        break;
                    }
                    if (offset > -10) {
                        timeZoneStr = "GMT-0" + String.valueOf(Math.abs(offset)) + ":00";
                        break;
                    }
                    timeZoneStr = "GMT" + String.valueOf(offset) + ":00";
                    break;
                }
                default: {
                    timeZoneStr = offset >= 0 ? "GMT+" + String.valueOf(offset) : "GMT" + String.valueOf(offset);
                }
            }
        }
        return timeZoneStr;
    }
}

