/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vipclient.i18n.messages.service;

import com.vmware.vipclient.i18n.VIPCfg;
import com.vmware.vipclient.i18n.base.DataSourceEnum;
import com.vmware.vipclient.i18n.base.cache.CacheMode;
import com.vmware.vipclient.i18n.base.cache.persist.DiskCacheLoader;
import com.vmware.vipclient.i18n.base.cache.persist.Loader;
import com.vmware.vipclient.i18n.messages.api.opt.local.LocalMessagesOpt;
import com.vmware.vipclient.i18n.messages.api.opt.server.ComponentBasedOpt;
import com.vmware.vipclient.i18n.messages.dto.MessagesDTO;
import com.vmware.vipclient.i18n.messages.service.CacheService;
import com.vmware.vipclient.i18n.util.JSONUtils;
import java.util.HashMap;
import java.util.Map;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;
import org.json.simple.parser.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentService {
    private MessagesDTO dto = null;
    Logger logger = LoggerFactory.getLogger(ComponentService.class);

    public ComponentService(MessagesDTO dto) {
        this.dto = dto;
    }

    public Map<String, String> getMessages() {
        JSONObject transMap = new HashMap();
        if (VIPCfg.getInstance().getMessageOrigin() == DataSourceEnum.VIP) {
            transMap = new ComponentBasedOpt(this.dto).getComponentMessages();
        } else if (VIPCfg.getInstance().getMessageOrigin() == DataSourceEnum.Bundle) {
            transMap = new LocalMessagesOpt(this.dto).getComponentMessages();
        }
        return transMap;
    }

    public Map<String, String> getComponentTranslation() {
        Map<Object, Object> retMap = new HashMap();
        CacheService cs = new CacheService(this.dto);
        retMap = cs.getCacheOfComponent();
        if (retMap == null && VIPCfg.getInstance().getCacheMode() == CacheMode.DISK) {
            Loader loader = VIPCfg.getInstance().getCacheManager().getLoaderInstance(DiskCacheLoader.class);
            retMap = loader.load(this.dto.getCompositStrAsCacheKey());
        }
        if (retMap == null && !cs.isContainComponent()) {
            Map<String, String> o = this.getMessages();
            Map<String, String> dataMap = o == null ? null : o;
            cs.addCacheOfComponent(dataMap);
            retMap = dataMap;
        }
        return retMap;
    }

    public boolean isComponentAvailable() {
        boolean r = false;
        Long s = null;
        if (VIPCfg.getInstance().getMessageOrigin() == DataSourceEnum.VIP) {
            ComponentBasedOpt dao = new ComponentBasedOpt(this.dto);
            String json = dao.getTranslationStatus();
            if (!JSONUtils.isEmpty(json)) {
                try {
                    s = (Long)JSONValue.parseWithException((String)json);
                }
                catch (ParseException e) {
                    this.logger.error(e.getMessage());
                }
            }
            r = s != null && s == 206L;
        }
        return r;
    }
}

