/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vipclient.i18n.messages.service;

import com.vmware.vipclient.i18n.VIPCfg;
import com.vmware.vipclient.i18n.exceptions.VIPJavaClientException;
import com.vmware.vipclient.i18n.messages.api.opt.server.ComponentsBasedOpt;
import com.vmware.vipclient.i18n.messages.dto.MessagesDTO;
import com.vmware.vipclient.i18n.messages.service.CacheService;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentsService {
    Logger logger = LoggerFactory.getLogger(ComponentsService.class);
    private final VIPCfg cfg;

    public ComponentsService(VIPCfg config) {
        this.cfg = config;
    }

    public Map<Locale, Map<String, Map<String, String>>> getTranslation(Set<String> components, Set<Locale> locales) {
        HashMap<String, Map<String, Map<String, String>>> dataMap = new HashMap<String, Map<String, Map<String, String>>>();
        TreeSet localesSet = new TreeSet(locales.stream().map(Locale::toLanguageTag).collect(Collectors.toSet()));
        TreeSet<String> componentsToQuery = new TreeSet<String>();
        TreeSet<String> localesToQuery = new TreeSet<String>();
        for (String locale : localesSet) {
            HashMap<String, Map<String, String>> localeMap = new HashMap<String, Map<String, String>>();
            for (String component : components) {
                MessagesDTO dto = new MessagesDTO();
                dto.setProductID(this.cfg.getProductName());
                dto.setVersion(this.cfg.getVersion());
                dto.setLocale(locale);
                dto.setComponent(component);
                CacheService cs = new CacheService(dto);
                Map<String, String> translations = cs.getCacheOfComponent();
                if (translations == null && !cs.isContainComponent()) {
                    componentsToQuery.add(component);
                    localesToQuery.add(locale);
                    continue;
                }
                localeMap.put(component, translations);
            }
            dataMap.put(locale, localeMap);
        }
        if (componentsToQuery.isEmpty() || localesToQuery.isEmpty()) {
            return this.convertDataMap(dataMap, locales);
        }
        ComponentsBasedOpt opt = new ComponentsBasedOpt(this.cfg);
        JSONObject response = opt.queryFromServer(componentsToQuery, localesToQuery);
        JSONArray bundles = (JSONArray)opt.getDataPart(response).get((Object)"bundles");
        JSONArray localesFromServer = (JSONArray)opt.getDataPart(response).get((Object)"locales");
        Map<String, String> localeMap = this.makeLocaleMap(localesToQuery, (List<String>)localesFromServer);
        for (JSONObject bundle : bundles) {
            String locale = localeMap.get(bundle.get((Object)"locale"));
            String comp = (String)bundle.get((Object)"component");
            JSONObject messages = (JSONObject)bundle.get((Object)"messages");
            MessagesDTO dto = new MessagesDTO();
            dto.setComponent(comp);
            dto.setLocale(locale);
            new CacheService(dto).addCacheOfComponent((Map<String, String>)messages);
            ((Map)dataMap.get(locale)).put(comp, messages);
        }
        return this.convertDataMap(dataMap, locales);
    }

    private Map<Locale, Map<String, Map<String, String>>> convertDataMap(Map<String, Map<String, Map<String, String>>> dataMap, Set<Locale> locales) {
        HashMap<Locale, Map<String, Map<String, String>>> retMap = new HashMap<Locale, Map<String, Map<String, String>>>();
        for (Locale locale : locales) {
            retMap.put(locale, dataMap.get(locale.toLanguageTag()));
        }
        return retMap;
    }

    private Map<String, String> makeLocaleMap(SortedSet<String> localesToQuery, List<String> localesFromServer) {
        if (localesToQuery.size() != localesFromServer.size()) {
            throw new VIPJavaClientException("The content from server is wrong!");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        Iterator iterOriginal = localesToQuery.iterator();
        Iterator<String> iterServer = localesFromServer.iterator();
        while (iterOriginal.hasNext()) {
            map.put(iterServer.next(), (String)iterOriginal.next());
        }
        return map;
    }
}

